/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xmlsig;

import com.verisign.domutil.DOMWriteCursor;
import com.verisign.xmlsig.VerifyingKey;
import com.verisign.xmlsig.elements.KeyInfo;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import org.w3c.dom.Element;

public class RSAVerifyingKey
implements VerifyingKey {
    private static String algorithmUri = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    private RSAPublicKey publicKey;
    private KeyInfo keyInfo = null;

    public RSAPublicKey getPublicKey() {
        return this.publicKey;
    }

    public RSAVerifyingKey(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new InvalidKeyException("Bad key type: " + publicKey);
        }
        this.publicKey = (RSAPublicKey)publicKey;
        this.keyInfo = new KeyInfo();
        this.keyInfo.addKeyValue(publicKey);
    }

    public RSAVerifyingKey(X509Certificate[] cert) throws InvalidKeyException, CertificateException {
        if (cert == null || cert[0] == null) {
            throw new IllegalArgumentException("certificate chain cannot be null");
        }
        this.keyInfo = new KeyInfo();
        this.keyInfo.addCertificateChain(cert);
        this.keyInfo.explodeCertificate();
        PublicKey publicKey = cert[0].getPublicKey();
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new InvalidKeyException("Bad key type: " + publicKey);
        }
        this.publicKey = (RSAPublicKey)publicKey;
    }

    public String getAlgorithmUri() {
        return algorithmUri;
    }

    public boolean verifySignature(byte[] data, byte[] sigd) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        try {
            Signature sig = Signature.getInstance("SHA1withRSA");
            sig.initVerify(this.publicKey);
            sig.update(data);
            return sig.verify(sigd);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw nsae;
        }
        catch (InvalidKeyException ike) {
            throw ike;
        }
        catch (SignatureException se) {
            throw se;
        }
    }

    public void readKeyInfo(Element keyInfoElement) {
    }

    public void writeKeyInfo(Element keyInfoElement) {
        if (this.keyInfo != null) {
            DOMWriteCursor wc = new DOMWriteCursor();
            this.keyInfo.toXml(wc);
            DOMWriteCursor copyTo = new DOMWriteCursor(keyInfoElement);
            boolean more = wc.moveToChild(1);
            while (more) {
                copyTo.copyUnder(wc);
                more = wc.moveToSibling(1);
            }
        }
    }
}

