/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xmlsig;

import com.verisign.xmlsig.HardwarePrivateKey;
import com.verisign.xmlsig.SigningKey;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.util.StringTokenizer;

public class HardwareSigningKey
implements SigningKey {
    private static String algorithmUri = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    private URL url = null;
    private HardwarePrivateKey privateKey = null;
    private static final int BBN_ENCRBLOCK_REQ = 1;
    private static final int REQ_HEADER_LENGTH = 8;
    private static final int REQ_ENCRYPT_LENGTH = 16;
    static final String urlDelims = "/=ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

    public HardwareSigningKey(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof HardwarePrivateKey)) {
            throw new InvalidKeyException("Bad key type: " + privateKey);
        }
        this.privateKey = (HardwarePrivateKey)privateKey;
    }

    public HardwareSigningKey(URL url) throws InvalidKeyException {
        this.url = url;
    }

    public String getAlgorithmUri() {
        return algorithmUri;
    }

    public byte[] signData(byte[] data) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        MessageDigest sha1 = MessageDigest.getInstance("SHA1");
        try {
            String s = this.url != null ? this.url.toString() : this.privateKey.getUrl().toString();
            return this.encryptReq(s.trim(), sha1.digest(data));
        }
        catch (IOException ioex) {
            throw new SignatureException(ioex + "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] encryptReq(String serverReference, byte[] data) throws IOException, MalformedURLException {
        byte[] byArray;
        URL keyURL = new URL(serverReference);
        String host = keyURL.getHost();
        int port = keyURL.getPort();
        String fileName = keyURL.getFile();
        StringTokenizer items = new StringTokenizer(fileName, urlDelims);
        int boxIndex = Integer.parseInt(items.nextToken());
        int keyIndex = Integer.parseInt(items.nextToken());
        byte[] ai = new byte[]{48, 33, 48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0, 4, 20};
        byte[] aidata = new byte[ai.length + data.length];
        System.arraycopy(ai, 0, aidata, 0, ai.length);
        System.arraycopy(data, 0, aidata, ai.length, data.length);
        Socket sock = new Socket(host, port);
        try {
            byArray = this.encryptReq(sock, boxIndex, keyIndex, aidata);
            Object var15_14 = null;
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            sock.close();
            throw throwable;
        }
        sock.close();
        return byArray;
    }

    private byte[] encryptReq(Socket sock, int boxIndex, int keyIndex, byte[] data) throws IOException {
        int encryptFlag = 0;
        DataOutputStream out = new DataOutputStream(sock.getOutputStream());
        int reqLen = 16 + data.length;
        out.writeInt(reqLen);
        out.writeShort(1);
        out.writeShort(boxIndex);
        out.writeShort(keyIndex);
        out.writeShort(0);
        out.writeInt(encryptFlag);
        out.writeInt(data.length);
        out.write(data);
        out.flush();
        DataInputStream in = new DataInputStream(sock.getInputStream());
        int rspLen = in.readInt();
        short rspType = in.readShort();
        int retCode = in.readInt();
        short discard2 = in.readShort();
        if (retCode != 0) {
            throw new IOException("Got error code " + retCode + " from server");
        }
        int msgLen = in.readInt();
        byte[] message = null;
        byte discard = in.readByte();
        if (msgLen > 0) {
            message = new byte[msgLen - 1];
            in.readFully(message);
        }
        return message;
    }

    static {
        BBN_ENCRBLOCK_REQ = 1;
        REQ_HEADER_LENGTH = 8;
        REQ_ENCRYPT_LENGTH = 16;
        urlDelims = urlDelims;
    }
}

