/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xmlsig;

import com.verisign.xmlsig.SigningKey;
import com.verisign.xmlsig.VerifyingKey;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.w3c.dom.Element;

public class HMACKey
implements SigningKey,
VerifyingKey {
    private static String algorithmUri = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
    private SecretKeySpec shaMacKey;

    public HMACKey(byte[] key) {
        this.shaMacKey = new SecretKeySpec(key, "HmacSHA1");
    }

    public String getAlgorithmUri() {
        return algorithmUri;
    }

    public byte[] signData(byte[] data) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        try {
            Mac mac = null;
            try {
                mac = Mac.getInstance("HmacSHA1");
            }
            catch (NoSuchAlgorithmException nsae) {
                try {
                    mac = Mac.getInstance("HMAC-SHA1");
                }
                catch (NoSuchAlgorithmException nsae1) {
                    mac = Mac.getInstance("HMAC/SHA");
                }
            }
            mac.init(this.shaMacKey);
            return mac.doFinal(data);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw nsae;
        }
        catch (InvalidKeyException ike) {
            throw ike;
        }
    }

    public String toString() {
        return "[HMACKey]";
    }

    public boolean verifySignature(byte[] data, byte[] sigd) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        return Arrays.equals(this.signData(data), sigd);
    }

    public void readKeyInfo(Element keyInfoElement) {
    }

    public void writeKeyInfo(Element keyInfoElement) {
    }
}

