/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xmlsig;

import com.verisign.domutil.DOMWriteCursor;
import com.verisign.util.Debug;
import com.verisign.xmlsig.VerifyingKey;
import com.verisign.xmlsig.elements.KeyInfo;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import org.w3c.dom.Element;

public class DSAVerifyingKey
implements VerifyingKey {
    private static String algorithmUri = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
    private DSAPublicKey publicKey;
    private KeyInfo keyInfo = null;

    public DSAPublicKey getPublicKey() {
        return this.publicKey;
    }

    public DSAVerifyingKey(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof DSAPublicKey)) {
            throw new InvalidKeyException("Bad key type: " + publicKey);
        }
        this.publicKey = (DSAPublicKey)publicKey;
        this.keyInfo = new KeyInfo();
        this.keyInfo.addKeyValue(publicKey);
    }

    public DSAVerifyingKey(X509Certificate[] cert) throws InvalidKeyException, CertificateException {
        if (cert == null || cert[0] == null) {
            throw new IllegalArgumentException("certificate chain cannot be null");
        }
        this.keyInfo = new KeyInfo();
        this.keyInfo.addCertificateChain(cert);
        this.keyInfo.explodeCertificate();
        PublicKey publicKey = cert[0].getPublicKey();
        if (!(publicKey instanceof DSAPublicKey)) {
            throw new InvalidKeyException("Bad key type: " + publicKey);
        }
        this.publicKey = (DSAPublicKey)publicKey;
    }

    public String getAlgorithmUri() {
        return algorithmUri;
    }

    public boolean verifySignature(byte[] data, byte[] sigd) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        try {
            Signature sig = Signature.getInstance("DSS");
            sig.initVerify(this.publicKey);
            sig.update(data);
            return sig.verify(this.fix(sigd));
        }
        catch (NoSuchAlgorithmException nsae) {
            throw nsae;
        }
        catch (InvalidKeyException ike) {
            throw ike;
        }
        catch (SignatureException se) {
            throw se;
        }
    }

    private byte[] fix(byte[] a) {
        int debugLevel = Debug.getLevel();
        if (a[0] == 48 && a[2] == 2 && a[1] == a.length - 2) {
            if (debugLevel >= Debug.HIGH) {
                Debug.out("Sigvalue already ASN.1 encoded", Debug.HIGH);
            }
            return a;
        }
        if (debugLevel >= Debug.HIGH) {
            Debug.out("Sigvalue not ASN.1 encoded, a[0]=" + Integer.toHexString(a[0]) + " a[1]=" + Integer.toHexString(a[1]) + " a[2]=" + Integer.toHexString(a[2]) + " a[3]=" + Integer.toHexString(a[3]), Debug.HIGH);
        }
        byte[] b = new byte[a.length + 6];
        b[0] = 48;
        b[1] = 44;
        b[2] = 2;
        b[3] = 20;
        System.arraycopy(a, 0, b, 4, 20);
        b[24] = 2;
        b[25] = 20;
        System.arraycopy(a, 20, b, 26, 20);
        return b;
    }

    public void readKeyInfo(Element keyInfoElement) {
    }

    public void writeKeyInfo(Element keyInfoElement) {
        if (this.keyInfo != null) {
            DOMWriteCursor wc = new DOMWriteCursor();
            this.keyInfo.toXml(wc);
            DOMWriteCursor copyTo = new DOMWriteCursor(keyInfoElement);
            boolean more = wc.moveToChild(1);
            while (more) {
                copyTo.copyUnder(wc);
                more = wc.moveToSibling(1);
            }
        }
    }

    public String toString() {
        return "[DSAVerifyingKey]";
    }
}

