/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xmlsig;

import com.verisign.xmlsig.SigningKey;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAPrivateKey;

public class DSASigningKey
implements SigningKey {
    private static String algorithmUri = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
    private DSAPrivateKey privateKey;

    public DSASigningKey(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof DSAPrivateKey)) {
            throw new InvalidKeyException("Bad key type: " + privateKey);
        }
        this.privateKey = (DSAPrivateKey)privateKey;
    }

    public String getAlgorithmUri() {
        return algorithmUri;
    }

    public byte[] signData(byte[] data) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        try {
            Signature sig = Signature.getInstance("SHA1withDSA");
            sig.initSign(this.privateKey);
            sig.update(data);
            return sig.sign();
        }
        catch (NoSuchAlgorithmException nsae) {
            throw nsae;
        }
        catch (InvalidKeyException ike) {
            throw ike;
        }
        catch (SignatureException se) {
            throw se;
        }
    }

    public String toString() {
        return "[DSASigningKey]";
    }
}

