/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xmlenc.tools;

import com.verisign.domutil.DOMCursor;
import com.verisign.domutil.DOMWriteCursor;
import com.verisign.resource.DOMOperations;
import com.verisign.resource.ResourceFactory;
import com.verisign.resource.XMLResource;
import com.verisign.xmlenc.tools.ConversionException;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Converter {
    private static final String WRAPPER_NAME = "x";
    private static final String WRAPPER_BEGIN = "<x>";
    private static final String WRAPPER_END = "</x>";
    private static final XMLResource xmlres;
    private static final DOMOperations ops;

    public static String xmlElementToString(Element e) {
        return Converter.xmlToString(e);
    }

    public static void stringToXmlElement(String s, DOMWriteCursor pos) throws ConversionException {
        Document toDoc = pos.getDocument();
        Element toElem = pos.getElement();
        Document fromDoc = Converter.stringToXmlWrapper(s, pos);
        DOMCursor fromCursor = new DOMCursor(fromDoc);
        fromCursor.moveToChild(1);
        Node fromCopy = toDoc.importNode(fromCursor.getElement(), true);
        DOMCursor testIfTop = pos.cloneCursor();
        testIfTop.moveToTop();
        if (pos.equals(testIfTop)) {
            pos.remove();
            toDoc.appendChild(fromCopy);
        } else {
            DOMCursor posParent = pos.cloneCursor();
            posParent.moveToParent();
            posParent.getElement().insertBefore(fromCopy, pos.getElement());
            pos.remove();
        }
    }

    public static String xmlContentToString(Node parent) {
        Document tempDoc = xmlres.createDocument();
        Element tempTop = ops.createElementNS(tempDoc, null, WRAPPER_NAME);
        tempDoc.appendChild(tempTop);
        Converter.copyChildren(tempTop, parent);
        String str = Converter.xmlToString(tempTop);
        if (str.startsWith(WRAPPER_BEGIN) && str.endsWith(WRAPPER_END)) {
            return str.substring(WRAPPER_BEGIN.length(), str.length() - WRAPPER_END.length());
        }
        throw new IllegalArgumentException("internal error: " + str);
    }

    public static void stringToXmlContent(String s, DOMWriteCursor pos) throws ConversionException {
        Document tempDoc = Converter.stringToXmlWrapper(s, pos);
        Element tempTop = tempDoc.getDocumentElement();
        pos.remove();
        pos.clear();
        Converter.copyChildren(pos.getElement(), tempTop);
    }

    private static void copyChildren(Node dest, Node srcParent) {
        Document doc = ops.document(dest);
        Node src = srcParent.getFirstChild();
        while (src != null) {
            Node copy = doc.importNode(src, true);
            dest.appendChild(copy);
            src = src.getNextSibling();
        }
    }

    private static Document stringToXmlWrapper(String s, DOMWriteCursor pos) throws ConversionException {
        String wrapper = Converter.publishWrapperBegin(pos);
        s = wrapper + s + WRAPPER_END;
        StringReader reader = new StringReader(s);
        try {
            return xmlres.parseXML(reader, false);
        }
        catch (IOException e) {
            throw new ConversionException(e.toString());
        }
    }

    public static String xmlToString(Element e) {
        StringWriter writer = new StringWriter();
        try {
            xmlres.publish((Node)e, (Writer)writer);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        String str = writer.toString();
        str = str.trim();
        return str;
    }

    private static String publishWrapperBegin(DOMCursor pos) {
        Document tempDoc = xmlres.createDocument();
        Element tempTop = ops.createElementNS(tempDoc, null, WRAPPER_NAME);
        tempDoc.appendChild(tempTop);
        pos = pos.cloneCursor();
        pos.moveToParent();
        ops.transferInScopeNamespaces(tempTop, pos.getElement());
        String str = Converter.xmlToString(tempTop);
        if (str.endsWith("/>")) {
            return str.substring(0, str.length() - 2) + '>';
        }
        throw new IllegalArgumentException("internal error: " + str);
    }

    static {
        WRAPPER_NAME = WRAPPER_NAME;
        WRAPPER_BEGIN = WRAPPER_BEGIN;
        WRAPPER_END = WRAPPER_END;
        xmlres = ResourceFactory.getXMLResource();
        ops = DOMOperations.getInstance();
    }
}

