/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xmlenc.elements;

import com.verisign.domutil.DOMCursor;
import com.verisign.domutil.DOMWriteCursor;
import com.verisign.domutil.elements.Element;
import com.verisign.domutil.elements.ElementImpl;
import com.verisign.util.Namespaces;
import com.verisign.xmlenc.AlgorithmType;

public class EncryptionMethod
extends ElementImpl {
    private static String name = "EncryptionMethod";
    private static String algorithmAttributeName = "Algorithm";
    private static String prefix = Namespaces.XMLENC.getPrefix();
    private static String uri = Namespaces.XMLENC.getUri();
    private static String[] ns = new String[]{prefix, uri};
    private AlgorithmType type = null;

    public static Element fromXml(DOMCursor c) {
        DOMCursor cc = ElementImpl.placeCursor(c, name, prefix, uri, ns);
        String uri = cc.getAttribute(algorithmAttributeName);
        EncryptionMethod e = new EncryptionMethod();
        AlgorithmType type = AlgorithmType.getInstance(uri);
        if (type == null) {
            throw new UnsupportedOperationException("Algorithm " + uri + " is not supported");
        }
        e.setAlgorithmType(type);
        return e;
    }

    public void setAlgorithmType(AlgorithmType type) {
        this.type = type;
    }

    public AlgorithmType getAlgorithmType() {
        return this.type;
    }

    public void toXml(DOMWriteCursor wc) {
        wc = wc.addUnder(uri, prefix, name);
        if (this.type != null) {
            wc.setAttribute(algorithmAttributeName, this.type.getUri());
        }
    }
}

