/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xmlenc.elements;

import com.verisign.datatypes.Base64;
import com.verisign.domutil.DOMCursor;
import com.verisign.domutil.DOMWriteCursor;
import com.verisign.domutil.elements.ElementException;
import com.verisign.domutil.elements.ElementExtension;
import com.verisign.domutil.elements.ElementImpl;
import com.verisign.util.Debug;
import com.verisign.util.Namespaces;
import com.verisign.xmlenc.AlgorithmType;
import com.verisign.xmlenc.elements.CipherData;
import com.verisign.xmlenc.elements.EncryptionMethod;
import com.verisign.xmlsig.KeyInfo;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public class EncryptedKey
extends ElementImpl
implements ElementExtension {
    static EncryptedKey INSTANCE = new EncryptedKey();
    private static String name = "EncryptedKey";
    private static String prefix = Namespaces.XMLENC.getPrefix();
    private static String uri = Namespaces.XMLENC.getUri();
    private static String[] ns = new String[]{prefix, uri};
    private static final boolean DUMP = false;
    private Key encryptionKey;
    private Key decryptionKey;
    private Key keyToEncrypt;
    private EncryptionMethod encryptionMethod;
    private com.verisign.xmlsig.elements.KeyInfo keyInfo;
    private CipherData cipherData;
    private DOMCursor cursor;

    public EncryptedKey() {
        this.encryptionMethod = new EncryptionMethod();
        this.keyInfo = new com.verisign.xmlsig.elements.KeyInfo();
        this.cipherData = new CipherData();
    }

    public EncryptedKey(EncryptionMethod encryptionMethod, com.verisign.xmlsig.elements.KeyInfo keyInfo, CipherData cipherData) {
        this.encryptionMethod = encryptionMethod;
        this.keyInfo = keyInfo;
        this.cipherData = cipherData;
    }

    public void setEncryptionKey(Key encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    public void setDecryptionKey(Key decryptionKey) {
        this.decryptionKey = decryptionKey;
    }

    public void setKeyToEncrypt(Key keyToEncrypt) {
        this.keyToEncrypt = keyToEncrypt;
    }

    public Key getDecryptedKey() {
        return this.keyToEncrypt;
    }

    public void setCursor(DOMCursor cursor) {
        this.cursor = cursor.cloneCursor();
    }

    public void setKeyInfo(KeyInfo keyInfo) {
        this.keyInfo = new com.verisign.xmlsig.elements.KeyInfo(keyInfo);
    }

    public KeyInfo getKeyInfo() {
        if (this.keyInfo != null) {
            return this.keyInfo.getKeyInfo();
        }
        return null;
    }

    public void encrypt(AlgorithmType type) throws NoSuchAlgorithmException, IllegalArgumentException {
        String s;
        if (type != AlgorithmType.RSA1_5) {
            throw new IllegalArgumentException("AlgorithmType must be RSA1_5 for key encryption");
        }
        String cipher = type.getJceAlgorithm();
        try {
            byte[] dec = this.keyToEncrypt.getEncoded();
            Cipher c = EncryptedKey.getCipher(cipher);
            c.init(1, this.encryptionKey);
            byte[] enc = c.doFinal(dec);
            s = Base64.encode(enc);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e.toString());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Probable mismatch of key with algorithm: " + e);
        }
        this.encryptionMethod.setAlgorithmType(type);
        this.cipherData.setEncryptedValue(s);
    }

    private Key convertToKey(byte[] b) {
        return new SecretKeySpec(b, "DESede");
    }

    public void decrypt() throws NoSuchAlgorithmException {
        AlgorithmType type = this.encryptionMethod.getAlgorithmType();
        String cipher = type.getJceAlgorithm();
        if (Debug.getLevel() >= Debug.ALL) {
            Debug.out("Decrypting using cipher: " + cipher, Debug.ALL);
        }
        try {
            byte[] enc = Base64.decode(this.cipherData.getEncryptedValue());
            Cipher c = EncryptedKey.getCipher(cipher);
            c.init(2, this.decryptionKey);
            byte[] dec = c.doFinal(enc);
            this.keyToEncrypt = this.convertToKey(dec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e.toString());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Probable mismatch of key with algorithm: " + e);
        }
    }

    private static boolean hasBouncyCastle() {
        return Security.getProvider("BC") != null;
    }

    private static boolean hasChrysalis() {
        return Security.getProvider("LunaJCEProvider") != null;
    }

    private static boolean installBouncyCastle() {
        try {
            if (!EncryptedKey.hasBouncyCastle()) {
                Class<?> cls = Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider");
                Security.insertProviderAt((Provider)cls.newInstance(), 2);
                return true;
            }
        }
        catch (ClassNotFoundException ignore) {
        }
        catch (IllegalAccessException ignore) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        return false;
    }

    private static void removeBouncyCastle() {
        Security.removeProvider("BC");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Cipher getCipher(String alg) throws NoSuchAlgorithmException {
        Cipher cipher;
        boolean weInstalledBouncyCastle = false;
        try {
            try {
                if (!EncryptedKey.hasBouncyCastle()) {
                    weInstalledBouncyCastle = EncryptedKey.installBouncyCastle();
                }
                if ((EncryptedKey.hasBouncyCastle() || EncryptedKey.hasChrysalis()) && "RSA".equals(alg)) {
                    alg = "RSA/ECB/PKCS1PADDING";
                }
                cipher = Cipher.getInstance(alg);
                Object var5_4 = null;
                if (!weInstalledBouncyCastle) return cipher;
            }
            catch (NoSuchAlgorithmException e) {
                throw e;
            }
            catch (NoSuchPaddingException e) {
                throw new NoSuchAlgorithmException(e.toString());
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!weInstalledBouncyCastle) throw throwable;
            EncryptedKey.removeBouncyCastle();
            throw throwable;
        }
        EncryptedKey.removeBouncyCastle();
        return cipher;
    }

    public ElementExtension fromXml(DOMCursor cursor) {
        try {
            if (cursor.moveToChild(uri, name)) {
                cursor.moveToParent();
                return EncryptedKey.fromXmlStatic(cursor);
            }
            return null;
        }
        catch (ElementException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public static EncryptedKey fromXmlStatic(DOMCursor c) throws ElementException {
        DOMCursor cc = c.cloneCursor();
        cc.moveToChild(uri, name);
        EncryptionMethod encryptionMethod = (EncryptionMethod)EncryptionMethod.fromXml(cc);
        com.verisign.xmlsig.elements.KeyInfo keyInfo = null;
        if (com.verisign.xmlsig.elements.KeyInfo.isAnElementIn(cc)) {
            keyInfo = com.verisign.xmlsig.elements.KeyInfo.fromXml(cc);
        }
        CipherData cipherData = CipherData.fromXml(cc);
        return new EncryptedKey(encryptionMethod, keyInfo, cipherData);
    }

    public void toXml(DOMWriteCursor wc) {
        wc = wc.addUnder(uri, prefix, name);
        this.encryptionMethod.toXml(wc);
        if (this.keyInfo != null) {
            this.keyInfo.toXml(wc);
        }
        this.cipherData.toXml(wc);
    }

    static {
        DUMP = false;
    }
}

