/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xmlenc.elements;

import com.verisign.datatypes.Base64;
import com.verisign.domutil.DOMCursor;
import com.verisign.domutil.DOMWriteCursor;
import com.verisign.domutil.elements.ElementException;
import com.verisign.domutil.elements.ElementExtension;
import com.verisign.domutil.elements.ElementImpl;
import com.verisign.util.Namespaces;
import com.verisign.xmlenc.AlgorithmType;
import com.verisign.xmlenc.elements.CipherData;
import com.verisign.xmlenc.elements.EncryptedKey;
import com.verisign.xmlenc.elements.EncryptionMethod;
import com.verisign.xmlenc.tools.Converter;
import com.verisign.xmlsig.KeyInfo;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;

public class EncryptedData
extends ElementImpl {
    private static final String name = "EncryptedData";
    private static final String prefix;
    private static final String uri;
    private static final String[] ns;
    private static final String elementEncryption;
    private static final String contentEncryption;
    private static final boolean DUMP = false;
    private static IvParameterSpec staticIv;
    private static SecureRandom random;
    private Key key;
    private EncryptionMethod encryptionMethod;
    private com.verisign.xmlsig.elements.KeyInfo keyInfo;
    private CipherData cipherData;
    private DOMCursor cursor;
    private boolean isContentType;
    private String encryptionType;

    public EncryptedData() {
        this.encryptionMethod = new EncryptionMethod();
        this.keyInfo = new com.verisign.xmlsig.elements.KeyInfo();
        this.cipherData = new CipherData();
        this.init();
    }

    public EncryptedData(EncryptionMethod encryptionMethod, com.verisign.xmlsig.elements.KeyInfo keyInfo, CipherData cipherData, String encryptionType) {
        this.encryptionMethod = encryptionMethod;
        this.keyInfo = keyInfo;
        this.cipherData = cipherData;
        this.encryptionType = encryptionType;
        this.isContentType = contentEncryption.equals(encryptionType);
        this.init();
    }

    private void init() {
        if (random == null) {
            try {
                random = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (NoSuchAlgorithmException e) {
                throw new UnsupportedOperationException(e.toString());
            }
        }
        if (staticIv == null) {
            staticIv = new IvParameterSpec(new byte[]{12, 34, 44, 17, 95, 87, 65, 43});
        }
    }

    public void setKey(Key key) {
        this.key = key;
    }

    public void setCursor(DOMCursor cursor) {
        this.cursor = cursor.cloneCursor();
    }

    public void setKeyInfo(KeyInfo keyInfo) {
        this.keyInfo = new com.verisign.xmlsig.elements.KeyInfo(keyInfo);
    }

    public KeyInfo getKeyInfo() {
        if (this.keyInfo != null) {
            return this.keyInfo.getKeyInfo();
        }
        return null;
    }

    public void setEncryptedKey(EncryptedKey encryptedKey) {
        this.keyInfo = new com.verisign.xmlsig.elements.KeyInfo();
        this.keyInfo.setExtension(encryptedKey);
    }

    public EncryptedKey getEncryptedKey() {
        ElementExtension ext;
        if (this.keyInfo != null && (ext = this.keyInfo.getExtension()) instanceof EncryptedKey) {
            return (EncryptedKey)ext;
        }
        return null;
    }

    public boolean isContentType() {
        return this.isContentType;
    }

    public void encrypt(AlgorithmType type, boolean encryptContent, boolean useOldEncrypt) throws IllegalArgumentException {
        if (type != AlgorithmType.TRIPLEDES) {
            throw new IllegalArgumentException("AlgorithmType must be TRIPLEDES for key encryption");
        }
        String s = encryptContent ? Converter.xmlContentToString(this.cursor.getElement()) : Converter.xmlElementToString(this.cursor.getElement());
        String cipher = "DESede/CBC/NoPadding";
        try {
            byte[] enc;
            Cipher c = Cipher.getInstance(cipher);
            byte[] dec = s.getBytes();
            dec = this.addPadding(dec);
            if (useOldEncrypt) {
                c.init(1, this.key, staticIv);
                enc = c.doFinal(dec);
            } else {
                byte[] ivBytes = new byte[8];
                random.nextBytes(ivBytes);
                IvParameterSpec encryptIv = new IvParameterSpec(ivBytes);
                c.init(1, this.key, encryptIv);
                byte[] dataBytes = c.doFinal(dec);
                enc = new byte[8 + dataBytes.length];
                System.arraycopy(ivBytes, 0, enc, 0, 8);
                System.arraycopy(dataBytes, 0, enc, 8, dataBytes.length);
            }
            s = Base64.encode(enc);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e.toString());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Probable mismatch of key with algorithm: " + e);
        }
        this.encryptionMethod.setAlgorithmType(type);
        this.cipherData.setEncryptedValue(s);
        this.isContentType = encryptContent;
        this.encryptionType = this.isContentType ? contentEncryption : elementEncryption;
    }

    public void decrypt(boolean useOldDecrypt) {
        AlgorithmType type = this.encryptionMethod.getAlgorithmType();
        String cipher = "DESede/CBC/NoPadding";
        try {
            byte[] dec;
            Cipher c = Cipher.getInstance(cipher);
            byte[] enc = Base64.decode(this.cipherData.getEncryptedValue());
            if (useOldDecrypt) {
                c.init(2, this.key, staticIv);
                dec = c.doFinal(enc);
            } else {
                IvParameterSpec decryptIv = new IvParameterSpec(enc, 0, 8);
                c.init(2, this.key, decryptIv);
                dec = c.doFinal(enc, 8, enc.length - 8);
            }
            dec = this.removePadding(dec);
            this.cipherData.setDecryptedValue(new String(dec));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Probable mismatch of key with algorithm: " + e);
        }
    }

    public static EncryptedData fromXml(DOMCursor c) throws ElementException {
        DOMCursor cc = c.cloneCursor();
        cc.moveToChild(uri, name);
        String type = cc.getAttribute("Type");
        EncryptionMethod encryptionMethod = (EncryptionMethod)EncryptionMethod.fromXml(cc);
        com.verisign.xmlsig.elements.KeyInfo keyInfo = null;
        if (com.verisign.xmlsig.elements.KeyInfo.isAnElementIn(cc)) {
            keyInfo = com.verisign.xmlsig.elements.KeyInfo.fromXml(cc, EncryptedKey.INSTANCE);
        }
        CipherData cipherData = CipherData.fromXml(cc);
        return new EncryptedData(encryptionMethod, keyInfo, cipherData, type);
    }

    public String getDecryptedData() {
        return this.cipherData.getDecryptedValue();
    }

    public void toXml(DOMWriteCursor wc) {
        wc = wc.addUnder(uri, prefix, name);
        wc.setAttribute("Type", this.encryptionType);
        this.encryptionMethod.toXml(wc);
        if (this.keyInfo != null) {
            this.keyInfo.toXml(wc);
        }
        this.cipherData.toXml(wc);
    }

    private byte[] addPadding(byte[] in) {
        int len = 8 - in.length % 8;
        byte[] out = new byte[in.length + len];
        System.arraycopy(in, 0, out, 0, in.length);
        int i = in.length;
        while (i < out.length) {
            out[i] = (byte)len;
            ++i;
        }
        return out;
    }

    private byte[] removePadding(byte[] in) throws BadPaddingException {
        byte len = in[in.length - 1];
        if (len < 1 || len > 8) {
            throw new BadPaddingException("bad pad length: " + len);
        }
        byte[] out = new byte[in.length - len];
        System.arraycopy(in, 0, out, 0, out.length);
        return out;
    }

    static {
        name = name;
        prefix = Namespaces.XMLENC.getPrefix();
        uri = Namespaces.XMLENC.getUri();
        ns = new String[]{prefix, uri};
        elementEncryption = uri + "Element";
        contentEncryption = uri + "Content";
        DUMP = false;
    }
}

