/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xmlenc.elements;

import com.verisign.domutil.DOMCursor;
import com.verisign.domutil.DOMWriteCursor;
import com.verisign.domutil.elements.ElementImpl;
import com.verisign.util.Namespaces;
import com.verisign.xmlenc.elements.CipherReference;
import com.verisign.xmlenc.elements.CipherValue;

public class CipherData
extends ElementImpl {
    private static String name = "CipherData";
    private static String prefix = Namespaces.XMLENC.getPrefix();
    private static String uri = Namespaces.XMLENC.getUri();
    private static String[] ns = new String[]{prefix, uri};
    private CipherValue encryptedValue;
    private CipherValue decryptedValue;
    private CipherReference cipherReference;

    public CipherData() {
        this.encryptedValue = new CipherValue();
        this.decryptedValue = new CipherValue();
        this.cipherReference = new CipherReference();
    }

    private CipherData(CipherValue encryptedValue, CipherReference cipherReference) {
        this.encryptedValue = encryptedValue;
        this.decryptedValue = new CipherValue();
        this.cipherReference = cipherReference;
    }

    public void setEncryptedValue(String base64) {
        this.encryptedValue.setValue(base64);
    }

    public String getEncryptedValue() {
        return this.encryptedValue.getValue();
    }

    public void setDecryptedValue(String val) {
        this.decryptedValue.setValue(val);
    }

    public String getDecryptedValue() {
        return this.decryptedValue.getValue();
    }

    public static CipherData fromXml(DOMCursor cursor) {
        DOMCursor cc = cursor.cloneCursor();
        cc.moveToChild(uri, name);
        CipherValue cipherValue = CipherValue.fromXml(cc);
        CipherReference cipherReference = CipherReference.fromXml(cc);
        return new CipherData(cipherValue, cipherReference);
    }

    public void toXml(DOMWriteCursor wc) {
        wc = wc.addUnder(uri, prefix, name);
        this.encryptedValue.toXml(wc);
    }
}

