/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xmlenc;

import com.verisign.datatypes.HashedByteArray;
import com.verisign.xmlenc.KeyResolver;
import com.verisign.xmlsig.KeyInfo;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class X509KeyResolver
implements KeyResolver {
    private Map bySki = new HashMap();
    private Map byCert = new HashMap();

    public X509KeyResolver(boolean isSynchronized) {
        if (isSynchronized) {
            this.bySki = Collections.synchronizedMap(this.bySki);
            this.byCert = Collections.synchronizedMap(this.byCert);
        }
    }

    public void putCertificate(X509Certificate cert) throws GeneralSecurityException {
        this.put(cert, new Info(null, new X509Certificate[]{cert}));
    }

    public void putKey(Key privateKey, X509Certificate[] chain) throws GeneralSecurityException {
        this.put(chain[0], new Info(privateKey, chain));
    }

    private void put(X509Certificate cert, Info info) throws GeneralSecurityException {
        byte[] bytes = KeyInfo.getSKIExtension(cert);
        if (bytes != null) {
            HashedByteArray hba = new HashedByteArray(bytes);
            if (this.bySki.containsKey(hba)) {
                Info testInfo = (Info)this.bySki.get(hba);
                if (testInfo.key == null || info.key != null) {
                    this.bySki.put(hba, info);
                }
            } else {
                this.bySki.put(hba, info);
            }
        }
        bytes = cert.getEncoded();
        this.byCert.put(new HashedByteArray(bytes), info);
    }

    public boolean putKey(KeyStore keyStore, String alias, char[] password) throws GeneralSecurityException {
        Certificate[] array;
        Key key = keyStore.getKey(alias, password);
        if (key != null && (array = keyStore.getCertificateChain(alias)) != null && array.length > 0) {
            X509Certificate[] chain = new X509Certificate[array.length];
            System.arraycopy(array, 0, chain, 0, array.length);
            this.putKey(key, chain);
            return true;
        }
        return false;
    }

    public void putAllKeys(KeyStore keyStore, char[] password) throws GeneralSecurityException {
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!keyStore.isKeyEntry(alias)) continue;
            this.putKey(keyStore, alias, password);
        }
    }

    public boolean putCertificate(KeyStore keyStore, String alias) throws GeneralSecurityException {
        X509Certificate cert = (X509Certificate)keyStore.getCertificate(alias);
        if (cert != null) {
            this.putCertificate(cert);
            return true;
        }
        return false;
    }

    public void putAllCertificates(KeyStore keyStore) throws GeneralSecurityException {
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!keyStore.isCertificateEntry(alias)) continue;
            this.putCertificate(keyStore, alias);
        }
    }

    public Key resolve(KeyInfo keyInfo) {
        X509Certificate cert;
        Info info = null;
        byte[] ski = keyInfo.getKeyIdentifier();
        if (ski != null) {
            info = (Info)this.bySki.get(new HashedByteArray(ski));
        }
        if (info == null && (cert = keyInfo.getCertificate()) != null) {
            try {
                byte[] bytes = cert.getEncoded();
                info = (Info)this.byCert.get(new HashedByteArray(bytes));
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        if (info != null) {
            if (keyInfo.getCertificateChain() == null) {
                keyInfo.setCertificateChain(info.getChain());
            }
            return info.getKey();
        }
        return null;
    }

    private static class Info {
        private X509Certificate[] chain;
        private Key key;

        Info(Key key, X509Certificate[] chain) {
            this.key = key;
            this.chain = chain;
        }

        final X509Certificate[] getChain() {
            return this.chain;
        }

        final Key getKey() {
            return this.key;
        }
    }
}

