/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xkms.tools.elements;

import com.verisign.datatypes.Base64;
import com.verisign.domutil.DOMCursor;
import com.verisign.domutil.DOMWriteCursor;
import com.verisign.domutil.elements.ElementException;
import com.verisign.domutil.elements.ElementExtension;
import com.verisign.resource.ResourceFactory;
import com.verisign.resource.XMLResource;
import com.verisign.util.Namespaces;
import com.verisign.xkms.tools.elements.KeyInfoExtension;
import com.verisign.xkms.tools.elements.XmlKeyStoreException;
import com.verisign.xmlenc.AlgorithmType;
import com.verisign.xmlenc.Decryptor;
import com.verisign.xmlenc.Encryptor;
import com.verisign.xmlenc.tools.ConversionException;
import com.verisign.xmlenc.tools.Converter;
import com.verisign.xmlsig.elements.KeyInfo;
import com.verisign.xmlsig.tools.KeyConverter;
import com.verisign.xpath.XPath;
import com.verisign.xpath.XPathException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.w3c.dom.Document;

public class XmlKeyStore {
    private static String prefix = Namespaces.XKMSKS.getPrefix();
    public static String uri = Namespaces.XKMSKS.getUri();
    private static String name = "XmlKeyStore";
    private static String[] ns = new String[]{prefix, uri};
    private ElementExtension extension = null;
    private Hashtable aliasMap;
    private Hashtable keyMap;
    private Hashtable trustedCertMap;

    private XmlKeyStore() {
    }

    public XmlKeyStore(Vector keyInfos) {
        this.aliasMap = new Hashtable();
        this.keyMap = new Hashtable();
        this.trustedCertMap = new Hashtable();
        if (keyInfos == null) {
            return;
        }
        int i = 0;
        while (i < keyInfos.size()) {
            KeyInfo ki = (KeyInfo)keyInfos.elementAt(i);
            KeyInfoExtension kie = (KeyInfoExtension)ki.getExtension();
            Enumeration e = kie.getAliases().elements();
            while (e.hasMoreElements()) {
                String s = (String)e.nextElement();
                this.aliasMap.put(s, ki);
                if (kie.getPrivateKey() != null) {
                    this.keyMap.put(s, ki);
                    continue;
                }
                this.trustedCertMap.put(s, ki);
            }
            ++i;
        }
    }

    public ElementExtension getExtension() {
        if (this.extension == null) {
            throw new IllegalStateException("empty!");
        }
        return this.extension;
    }

    public void setExtension(ElementExtension extension) {
        this.extension = extension;
    }

    public static XmlKeyStore fromXml(DOMCursor c) throws ElementException {
        return XmlKeyStore.fromXml(c, null);
    }

    public static XmlKeyStore fromXml(DOMCursor c, ElementExtension ext) throws ElementException {
        String s;
        XPath xpath;
        DOMCursor cc = c.cloneCursor();
        boolean b = cc.moveToXPath(xpath = new XPath(s = "//" + prefix + ":" + name, ns));
        if (!b) {
            s = "XML does not contain a <" + uri + ":" + name + "> element";
            throw new IllegalArgumentException(s);
        }
        Vector<KeyInfo> v = new Vector<KeyInfo>();
        boolean more = cc.moveToChild(KeyInfo.uri, "KeyInfo");
        while (more) {
            v.add(KeyInfo.fromXml(cc, new KeyInfoExtension()));
            more = cc.moveToSibling(KeyInfo.uri, "KeyInfo");
        }
        XmlKeyStore xks = new XmlKeyStore(v);
        if (ext != null) {
            cc.moveToTop();
            ElementExtension e = ext.fromXml(cc);
            xks.setExtension(e);
        }
        return xks;
    }

    public DOMCursor toXml() {
        try {
            DOMWriteCursor wc = new DOMWriteCursor();
            wc.addUnder(uri, prefix, name);
            this.addExtension(wc);
            Enumeration e = this.aliasMap.keys();
            while (e.hasMoreElements()) {
                String s = (String)e.nextElement();
                if (s.startsWith("<Key")) continue;
                KeyInfo ki = (KeyInfo)this.aliasMap.get(s);
                ki.toXml(wc);
            }
            wc.moveToTop();
            return wc;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public int numberOfEntries() {
        return this.aliasMap.size();
    }

    private void addExtension(DOMWriteCursor wc) {
        if (this.extension != null) {
            this.extension.toXml(wc);
        }
    }

    public Enumeration aliases() {
        return this.aliasMap.keys();
    }

    public void delete(String alias) {
        this.keyMap.remove(alias);
        this.trustedCertMap.remove(alias);
        this.aliasMap.remove(alias);
    }

    public Map getKeyAndCert(String alias, Key key) throws XmlKeyStoreException {
        KeyInfo ki = (KeyInfo)this.keyMap.get(alias);
        KeyInfoExtension kie = (KeyInfoExtension)ki.getExtension();
        String s = kie.getPrivateKey();
        Key k = null;
        try {
            k = this.decryptKey(s, key);
        }
        catch (ConversionException ce) {
            throw new XmlKeyStoreException(ce.toString());
        }
        catch (IllegalArgumentException iae) {
            throw new XmlKeyStoreException(iae.toString());
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new XmlKeyStoreException(nsae.toString());
        }
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("key", k);
        map.put("cert", ki.getCertificate());
        return map;
    }

    public X509Certificate getCertificate(String alias) {
        KeyInfo ki = (KeyInfo)this.trustedCertMap.get(alias);
        if (ki == null) {
            ki = (KeyInfo)this.keyMap.get(alias);
        }
        return ki.getCertificate();
    }

    public X509Certificate[] getCertificateChain(String alias) {
        KeyInfo ki = (KeyInfo)this.keyMap.get(alias);
        return ki.getCertificateChain();
    }

    public boolean isKey(String alias) {
        return this.keyMap.containsKey(alias);
    }

    public boolean isTrustedCert(String alias) {
        return this.trustedCertMap.containsKey(alias);
    }

    public Date getCreationDate(String alias) {
        KeyInfo ki = (KeyInfo)this.aliasMap.get(alias);
        if (ki == null) {
            throw new IllegalStateException("Alias " + alias + " not found, but it should be");
        }
        KeyInfoExtension kie = (KeyInfoExtension)ki.getExtension();
        return kie.getCreationDate();
    }

    public String getAliasFor(X509Certificate cert) {
        Enumeration e = this.aliasMap.elements();
        while (e.hasMoreElements()) {
            KeyInfo k = (KeyInfo)e.nextElement();
            if (!this.isEqual(cert, k.getCertificate())) continue;
            KeyInfoExtension kie = (KeyInfoExtension)k.getExtension();
            return kie.getAlias();
        }
        return null;
    }

    public void addKey(Vector aliases, PrivateKey privateKey, Key key, X509Certificate[] chain) {
        try {
            KeyInfo k = new KeyInfo();
            String s = this.encryptKey(privateKey, key);
            k.addCertificateChain(chain);
            KeyInfoExtension kie = new KeyInfoExtension();
            kie.setPrivateKey(s);
            kie.addAliases(aliases);
            kie.setCreationDate(new Date());
            k.setExtension(kie);
            Enumeration e = aliases.elements();
            while (e.hasMoreElements()) {
                String alias = (String)e.nextElement();
                this.aliasMap.put(alias, k);
                this.keyMap.put(alias, k);
            }
        }
        catch (Throwable t) {
            System.out.println(t);
            t.printStackTrace();
        }
    }

    public void addCertificate(String alias, X509Certificate cert) {
        if (this.isTrustedCert(alias)) {
            throw new IllegalArgumentException(alias + " already exists in keystore");
        }
        KeyInfo k = new KeyInfo();
        k.addCertificate(cert);
        KeyInfoExtension kie = new KeyInfoExtension();
        kie.addAlias(alias);
        kie.setCreationDate(new Date());
        k.setExtension(kie);
        this.aliasMap.put(alias, k);
        this.trustedCertMap.put(alias, k);
    }

    private boolean isEqual(X509Certificate cert, X509Certificate cert2) {
        String dn = cert.getSubjectDN().toString();
        return dn.equals(cert2.getSubjectDN().toString());
    }

    private String encryptKey(PrivateKey privateKey, Key key) throws NoSuchAlgorithmException {
        Document doc = KeyConverter.privateKeyToKeyInfo(privateKey);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLResource xml = ResourceFactory.getXMLResource();
        try {
            xml.publish(doc, (OutputStream)baos);
        }
        catch (IOException e) {
            throw new NoSuchAlgorithmException(e.toString());
        }
        byte[] b = baos.toByteArray();
        String s = Base64.encode(b);
        DOMWriteCursor wc = new DOMWriteCursor();
        wc.addUnder(null, null, "tag");
        wc.moveToChild(null, "tag");
        wc.setText(s);
        Encryptor e = new Encryptor(wc.getDocument(), key, AlgorithmType.TRIPLEDES);
        try {
            doc = e.encrypt(new XPath("/"));
        }
        catch (XPathException xe) {
            throw new NoSuchAlgorithmException(xe.toString());
        }
        s = Converter.xmlToString(doc.getDocumentElement());
        return Base64.encode(s.getBytes());
    }

    private Key decryptKey(String s, Key key) throws NoSuchAlgorithmException, ConversionException {
        Document doc;
        XMLResource xmlres = ResourceFactory.getXMLResource();
        byte[] b = Base64.decode(s);
        try {
            doc = xmlres.parseXML(new ByteArrayInputStream(b), false);
        }
        catch (IOException e) {
            throw new ConversionException(e.toString());
        }
        String encPrefix = Namespaces.XMLENC.getPrefix();
        String[] encNs = new String[]{encPrefix, Namespaces.XMLENC.getUri()};
        XPath xpath = new XPath("//" + encPrefix + ":EncryptedData", encNs);
        Decryptor d = new Decryptor(doc, key, xpath);
        try {
            doc = d.decrypt();
        }
        catch (XPathException xpe) {
            throw new NoSuchAlgorithmException(xpe.toString());
        }
        DOMCursor c = new DOMCursor(doc);
        c.moveToChild(null, "tag");
        b = Base64.decode(c.getText());
        try {
            doc = xmlres.parseXML(new ByteArrayInputStream(b), false);
            key = KeyConverter.keyInfoToPrivateKey(doc, new XPath("/*"));
        }
        catch (IOException e) {
            throw new NoSuchAlgorithmException(e.toString());
        }
        catch (GeneralSecurityException e) {
            throw new NoSuchAlgorithmException(e.toString());
        }
        catch (XPathException xe) {
            throw new NoSuchAlgorithmException(xe.toString());
        }
        return key;
    }

    public String toString() {
        return "[XmlKeyStore: extension: " + this.extension + "]";
    }
}

