/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xkms.tools.elements;

import com.verisign.domutil.DOMCursor;
import com.verisign.domutil.DOMWriteCursor;
import com.verisign.domutil.elements.ElementExtension;
import com.verisign.util.Namespaces;
import com.verisign.xpath.XPath;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.TimeZone;
import java.util.Vector;

public class KeyInfoExtension
implements ElementExtension {
    private static String prefix = Namespaces.XKMSKS.getPrefix();
    private static String uri = Namespaces.XKMSKS.getUri();
    private static String[] ns = new String[]{prefix, uri};
    private static String name = "KeyInfoExtension";
    private static String aliasTag = "Alias";
    private static String creationDateTag = "Created";
    private static String privateKeyTag = "Private";
    private Vector aliases = null;
    private Date creationDate = null;
    private String privateKeyString = null;

    public void addAliases(Vector aliases) {
        if (this.aliases == null) {
            this.aliases = new Vector();
        }
        if (aliases != null) {
            this.aliases.addAll(aliases);
        }
    }

    public void addAlias(String alias) {
        if (this.aliases == null) {
            this.aliases = new Vector();
        }
        this.aliases.add(alias);
    }

    public void setCreationDate(Date date) {
        this.creationDate = date;
    }

    public void setPrivateKey(String privateKeyString) {
        this.privateKeyString = privateKeyString;
    }

    public void toXml(DOMWriteCursor wc) {
        String s;
        XPath xpath;
        wc.addUnder(uri, prefix, name);
        if (this.aliases != null && !wc.moveToXPath(xpath = new XPath(s = ".//" + prefix + ":" + aliasTag, ns))) {
            this.addAliases(wc.cloneWriteCursor());
        }
        if (this.creationDate != null && !wc.moveToXPath(xpath = new XPath(s = ".//" + prefix + ":" + creationDateTag, ns))) {
            this.addCreationDate(wc.cloneWriteCursor());
        }
        if (this.privateKeyString != null && !wc.moveToXPath(xpath = new XPath(s = ".//" + prefix + ":" + privateKeyTag, ns))) {
            this.addPrivateKey(wc.cloneWriteCursor());
        }
    }

    private void addAliases(DOMWriteCursor wc) {
        this.moveToTop(wc);
        Enumeration e = this.aliases.elements();
        while (e.hasMoreElements()) {
            wc = wc.addUnder(uri, prefix, aliasTag);
            wc.setText((String)e.nextElement());
            wc.moveToParent();
        }
    }

    private void moveToTop(DOMWriteCursor wc) {
        wc.moveToXPath(new XPath(".//" + prefix + ":" + name, ns));
    }

    private void addCreationDate(DOMWriteCursor wc) {
        this.moveToTop(wc);
        wc.addUnder(uri, prefix, creationDateTag);
        wc.moveToChild(uri, creationDateTag);
        wc.setText(this.getIsoDateAsString(this.creationDate));
    }

    private void addPrivateKey(DOMWriteCursor wc) {
        this.moveToTop(wc);
        wc.addUnder(uri, prefix, privateKeyTag);
        wc.moveToChild(uri, privateKeyTag);
        wc.setText(this.privateKeyString);
    }

    private static Vector parseAliases(DOMCursor c) {
        Vector<String> v = new Vector<String>();
        String s = ".//" + prefix + ":" + aliasTag;
        XPath xpath = new XPath(s, ns);
        if (c.moveToXPath(xpath)) {
            v.add(c.getText());
            while (c.moveToSibling(1) && c.getLocalName().equals(aliasTag)) {
                v.add(c.getText());
            }
            return v;
        }
        return null;
    }

    private static String parsePrivateKey(DOMCursor c) {
        String s = ".//" + prefix + ":" + privateKeyTag;
        XPath xpath = new XPath(s, ns);
        if (c.moveToXPath(xpath)) {
            return c.getText();
        }
        return null;
    }

    private static Date parseCreationDate(DOMCursor c) {
        String s = ".//" + prefix + ":" + creationDateTag;
        XPath xpath = new XPath(s, ns);
        if (c.moveToXPath(xpath)) {
            try {
                return KeyInfoExtension.parseIsoDate(c.getText());
            }
            catch (ParseException pe) {
                s = "<" + uri + ":" + creationDateTag + "> element is messed up in position " + pe.getErrorOffset() + ": " + c.getText();
                throw new IllegalStateException(s);
            }
        }
        return null;
    }

    private String getIsoDateAsString(Date d) {
        SimpleDateFormat isoDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        isoDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return isoDateFormat.format(d);
    }

    private static Date parseIsoDate(String text) throws ParseException {
        SimpleDateFormat isoDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        isoDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        int lenMinusOne = text.length() - 1;
        if (lenMinusOne > 0 && text.charAt(lenMinusOne) == 'Z') {
            text = text.substring(0, lenMinusOne);
        }
        return isoDateFormat.parse(text);
    }

    public ElementExtension fromXml(DOMCursor cursor) {
        DOMCursor cc = cursor.cloneCursor();
        XPath xpath = new XPath(".//" + prefix + ":" + name, ns);
        cc.moveToXPath(xpath);
        Vector aliases = KeyInfoExtension.parseAliases(cc.cloneCursor());
        Date date = KeyInfoExtension.parseCreationDate(cc.cloneCursor());
        String key = KeyInfoExtension.parsePrivateKey(cc.cloneCursor());
        KeyInfoExtension kie = new KeyInfoExtension();
        kie.addAliases(aliases);
        kie.setCreationDate(date);
        kie.setPrivateKey(key);
        return kie;
    }

    public Vector getAliases() {
        return this.aliases;
    }

    public String getAlias() {
        if (this.aliases == null) {
            return null;
        }
        Enumeration e = this.aliases.elements();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if (s.startsWith("<Key")) continue;
            return s;
        }
        return null;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public String getPrivateKey() {
        return this.privateKeyString;
    }
}

