/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xkms.tools;

import com.verisign.domutil.DOMCursor;
import com.verisign.domutil.DOMWriteCursor;
import com.verisign.domutil.elements.ElementExtension;
import com.verisign.util.Namespaces;
import com.verisign.xkms.tools.elements.XmlKeyStore;
import com.verisign.xpath.XPath;

class XmlKeyStoreExtension
implements ElementExtension {
    private static String prefix = Namespaces.XKMSKS.getPrefix();
    private static String uri = Namespaces.XKMSKS.getUri();
    private static String[] ns = new String[]{prefix, uri};
    private static String name = "XmlKeyStoreExtension";
    private String serviceUriTag = "ServiceURI";
    private String validationIntervalTag = "ValidationInterval";
    private String autoloadTag = "Autoload";
    private String serviceUri;
    private String validationInterval;
    private String autoload;

    public void setServiceUri(String serviceUri) {
        this.serviceUri = serviceUri;
    }

    public void setValidationInterval(String validationInterval) {
        this.validationInterval = validationInterval;
    }

    public void setAutoload(String autoload) {
        this.autoload = autoload;
    }

    public String getServiceUri() {
        return this.serviceUri;
    }

    public String getValidationInterval() {
        return this.validationInterval;
    }

    public String getAutoload() {
        return this.autoload;
    }

    public void toXml(DOMWriteCursor wc) {
        wc.addUnder(uri, prefix, name);
        this.set(wc, this.serviceUriTag, this.serviceUri);
        this.set(wc, this.validationIntervalTag, this.validationInterval);
        this.set(wc, this.autoloadTag, this.autoload);
    }

    private void set(DOMWriteCursor wc, String tag, String value) {
        if (tag == null) {
            return;
        }
        String s = ".//" + prefix + ":" + tag;
        XPath xpath = new XPath(s, ns);
        DOMWriteCursor c = wc.cloneWriteCursor();
        if (!c.moveToXPath(xpath)) {
            this.moveToTop(c);
            c.addUnder(uri, prefix, tag);
            c.moveToChild(XmlKeyStore.uri, tag);
            c.setText(value);
        }
    }

    private void moveToTop(DOMWriteCursor wc) {
        wc.moveToXPath(new XPath(".//" + prefix + ":" + name, ns));
    }

    private static String parse(DOMCursor c, String tag) {
        String s = ".//" + prefix + ":" + tag;
        XPath xpath = new XPath(s, ns);
        if (c.moveToXPath(xpath)) {
            return c.getText();
        }
        return null;
    }

    public ElementExtension fromXml(DOMCursor cursor) {
        DOMCursor cc = cursor.cloneCursor();
        XPath xpath = new XPath(".//" + prefix + ":" + name, ns);
        cc.moveToXPath(xpath);
        XmlKeyStoreExtension ext = new XmlKeyStoreExtension();
        ext.setServiceUri(XmlKeyStoreExtension.parse(cc.cloneCursor(), this.serviceUriTag));
        ext.setValidationInterval(XmlKeyStoreExtension.parse(cc.cloneCursor(), this.validationIntervalTag));
        ext.setAutoload(XmlKeyStoreExtension.parse(cc.cloneCursor(), this.autoloadTag));
        return ext;
    }

    public String toString() {
        String s = "[XmlKeyStoreExtension ";
        s = s + "URI=" + this.serviceUri;
        s = s + "ValidationInterval=" + this.validationInterval;
        s = s + "Autoload=" + this.autoload;
        s = s + "]";
        return s;
    }
}

