/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xkms.tools;

import com.verisign.datatypes.Base64;
import com.verisign.messaging.InsecureTransportException;
import com.verisign.messaging.XmlMessageException;
import com.verisign.messaging.XmlTransportSOAP;
import com.verisign.resource.ResourceFactory;
import com.verisign.resource.XMLResource;
import com.verisign.xkms.client.XKMSAuthInfo;
import com.verisign.xkms.client.XKMSException;
import com.verisign.xkms.client.XKMSIllegalArgumentException;
import com.verisign.xkms.client.XKMSKeyData;
import com.verisign.xkms.client.XKMSKeyName;
import com.verisign.xkms.client.XKMSRegister;
import com.verisign.xkms.client.XKMSRegisterResponse;
import com.verisign.xkms.tools.Debug;
import com.verisign.xkms.tools.XKMSKeyStore;
import com.verisign.xkms.tools.XKMSKeyStoreProvider;
import com.verisign.xmlsig.tools.KeyConverter;
import com.verisign.xpath.XPath;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.StreamCorruptedException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.w3c.dom.Document;

public class XKMSTool {
    private static boolean DEBUG = false;
    private static String keyStorePassword;
    private static XKMSKeyStore xks;
    private static KeyStore ks;

    private static void readKeystore(String keyStoreName) throws Exception {
        if (keyStorePassword == null) {
            throw new Exception("keystore password missing");
        }
        File keyStoreFile = new File(keyStoreName);
        if (keyStoreFile.exists()) {
            FileInputStream fis = new FileInputStream(keyStoreFile);
            if (XKMSTool.isXml(keyStoreFile)) {
                XKMSTool.dbg(3, "reading xkms keystore in " + keyStoreName);
                xks = new XKMSKeyStore();
                xks.engineLoad(fis, keyStorePassword.toCharArray());
            } else {
                XKMSTool.dbg(3, "reading jks keystore in " + keyStoreName);
                ks = KeyStore.getInstance("JKS");
                ks.load(fis, keyStorePassword.toCharArray());
            }
        } else {
            xks = new XKMSKeyStore();
            xks.engineLoad(null, keyStorePassword.toCharArray());
        }
    }

    private static void writeKeystore(String keyStoreName) throws Exception {
        File keyStoreFile = new File(keyStoreName);
        FileOutputStream fos = new FileOutputStream(keyStoreFile);
        if (XKMSTool.isXkmsKeyStore()) {
            xks.engineStore(fos, keyStorePassword.toCharArray());
        } else {
            ks.store(fos, keyStorePassword.toCharArray());
        }
    }

    private static boolean isXml(File file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            XMLResource xmlres = ResourceFactory.getXMLResource();
            Document document = xmlres.parseXML(fis, false);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static boolean isXkmsKeyStore() {
        return xks != null;
    }

    private static boolean isXkmsKeyStore(String fileName) throws Exception {
        File file = new File(fileName);
        if (file.exists()) {
            return XKMSTool.isXml(file);
        }
        return false;
    }

    private static void setDebug(PrintStream out, int level) {
    }

    public static void main(String[] argv) {
        try {
            if (XKMSTool.findFlag("-v", argv)) {
                Debug.setLevel(2);
                Debug.setPrintStream(System.err);
            }
            if (XKMSTool.findFlag("-vv", argv)) {
                Debug.setLevel(3);
                Debug.setPrintStream(System.err);
                Debug.out("Setting maximum debug output", 3);
            }
            String keyStoreName = XKMSTool.findValue("-keystore", argv);
            keyStorePassword = XKMSTool.findValue("-storepass", argv);
            if (keyStoreName == null) {
                keyStoreName = System.getProperty("user.home") + "/.keystore";
            }
            if (argv.length >= 1 && argv[0].equals("-config")) {
                XKMSTool.readKeystore(keyStoreName);
                XKMSTool.config(argv);
            } else if (argv.length >= 1 && argv[0].equals("-register")) {
                XKMSTool.readKeystore(keyStoreName);
                XKMSTool.register(argv);
            } else {
                Security.addProvider(new XKMSKeyStoreProvider());
                String[] st = null;
                if (XKMSTool.isXkmsKeyStore(keyStoreName)) {
                    st = new String[argv.length + 2];
                    System.arraycopy(argv, 0, st, 0, argv.length);
                    st[argv.length] = "-storetype";
                    st[argv.length + 1] = "xkms";
                } else {
                    st = new String[argv.length];
                    System.arraycopy(argv, 0, st, 0, argv.length);
                }
                String s = "";
                int i = 0;
                while (i < st.length) {
                    if ("-vv".equals(st[i])) {
                        st[i] = "-v";
                    }
                    s = s + st[i] + " ";
                    ++i;
                }
                XKMSTool.dbg(2, "Executing Sun keytool: " + s);
                ClassLoader clr = ClassLoader.getSystemClassLoader();
                Class<?> cl = clr != null ? clr.loadClass("sun.security.tools.KeyTool") : Class.forName("sun.security.tools.KeyTool");
                Class[] classes = new Class[]{argv.getClass()};
                if (XKMSTool.findFlag("-help", st)) {
                    XKMSTool.printHelp();
                }
                cl.getMethod("main", classes).invoke(null, new Object[]{st});
                return;
            }
            XKMSTool.writeKeystore(keyStoreName);
        }
        catch (Exception e) {
            if (DEBUG) {
                e.printStackTrace();
            } else {
                System.out.println(e.toString());
            }
            System.exit(1);
        }
    }

    private static void printHelp() {
        PrintStream p = System.err;
        p.println("XKMSTool usage:");
        p.println("-config      [-service <uri>][-interval <s>]");
        p.println("             [-autoload <yes|no>]\n");
        p.println("-register    [-sharedsecret <string>][-keyname <string>]");
        p.println("             [-alias <string>][-revokepassword <string>]");
        p.println("             [-password <string>][-storepass <string>]\n");
    }

    private static void config(String[] argv) throws Exception {
        String autoload;
        String interval;
        if (!XKMSTool.isXkmsKeyStore()) {
            throw new Exception("-config is only available on XKMS Keystores");
        }
        String uri = XKMSTool.findValue("-service", argv);
        if (uri != null) {
            xks.setServiceUri(uri);
        }
        if ((interval = XKMSTool.findValue("-interval", argv)) != null) {
            xks.setValidationInterval(interval);
        }
        if ((autoload = XKMSTool.findValue("-autoload", argv)) != null) {
            xks.setAutoload(autoload);
        }
    }

    private static void register(String[] argv) throws Exception {
        String keyname = XKMSTool.findValue(true, "-keyname", argv);
        String sharedSecret = XKMSTool.findValue(true, "-sharedsecret", argv);
        String password = XKMSTool.findValue(true, "-password", argv);
        String revokePassword = XKMSTool.findValue(true, "-revokepassword", argv);
        String alias = XKMSTool.findValue(true, "-alias", argv);
        String keySize = XKMSTool.findValue("-keysize", argv);
        String serviceUrl = null;
        String signingKeyAlias = null;
        if (!XKMSTool.isXkmsKeyStore()) {
            serviceUrl = XKMSTool.findValue(true, "-service", argv);
            signingKeyAlias = "__xkms_signing_key__";
        } else {
            serviceUrl = xks.getServiceUri();
            XKMSTool.dbg(3, "service url is " + serviceUrl);
            signingKeyAlias = xks.getSigningKeyAlias();
        }
        boolean generateKeys = true;
        String keyFileName = XKMSTool.findValue("-keyfile", argv);
        String certFileName = XKMSTool.findValue("-certfile", argv);
        if (keyFileName != null && certFileName == null || keyFileName == null && certFileName != null) {
            throw new IllegalArgumentException("Must specify both key file and certificate file");
        }
        if (keyFileName != null && certFileName != null) {
            generateKeys = false;
        }
        if (alias.equals(signingKeyAlias) && !password.equals(keyStorePassword)) {
            String s = "The XKMS signing key (" + signingKeyAlias + ") must be stored under the same password as the keystore.";
            throw new IllegalArgumentException(s);
        }
        if (keySize == null) {
            keySize = "512";
        }
        KeyPair kp = null;
        if (generateKeys) {
            kp = XKMSTool.generateKeyPair(Integer.parseInt(keySize));
        } else {
            PrivateKey key = (PrivateKey)XKMSTool.readKey(keyFileName);
            Certificate cert = XKMSTool.readCert(certFileName);
            kp = new KeyPair(cert.getPublicKey(), key);
        }
        XKMSTool.setKeyEntry(alias, kp, password, keyname, revokePassword, sharedSecret, serviceUrl);
    }

    private static void setKeyEntry(String alias, KeyPair keypair, String password, String keyname, String revokePass, String sharedSecret, String url) throws KeyStoreException {
        FileOutputStream debugos = null;
        if (Debug.getLevel() >= 3) {
            File tmpdir = new File(System.getProperty("java.io.tmpdir"));
            File debugout = new File(tmpdir, "xkmstool.out");
            try {
                debugos = new FileOutputStream(debugout);
                XKMSTool.dbg(3, "sending debug output to " + debugout);
            }
            catch (FileNotFoundException e) {
                XKMSTool.dbg(3, e.toString());
                debugos = null;
            }
        }
        XmlTransportSOAP transport = null;
        try {
            transport = debugos != null ? new XmlTransportSOAP(new URL(url), debugos) : new XmlTransportSOAP(new URL(url));
        }
        catch (MalformedURLException e) {
            throw new KeyStoreException(e.toString());
        }
        XKMSKeyData data = new XKMSKeyData(keypair, new XKMSKeyName(keyname));
        XKMSAuthInfo authInfo = new XKMSAuthInfo(revokePass, sharedSecret);
        XKMSRegisterResponse resp = null;
        try {
            XKMSRegister register = new XKMSRegister(data, authInfo);
            resp = register.sendRequest(transport);
        }
        catch (IOException ie) {
            throw new KeyStoreException(ie.toString());
        }
        catch (XKMSIllegalArgumentException xiae) {
            throw new KeyStoreException(xiae.toString());
        }
        catch (InsecureTransportException ite) {
            throw new KeyStoreException(ite.toString());
        }
        catch (XKMSException ee) {
            throw new KeyStoreException(ee.toString());
        }
        catch (XmlMessageException e) {
            throw new KeyStoreException(e.toString());
        }
        boolean isOK = resp.getStatus();
        XKMSTool.dbg(2, "Response status is " + isOK);
        if (!isOK) {
            throw new KeyStoreException("Could not add key (XKMS error)");
        }
        XKMSTool.dbg(3, "XKMS key name is " + resp.getKeyName());
        X509Certificate[] resultChain = new X509Certificate[]{resp.getCert()};
        Vector<String> v = new Vector<String>();
        v.add(alias);
        v.add("<KeyName>" + resp.getKeyName() + "</KeyName>");
        PublicKey pk = resp.getPublicKey();
        v.add("<KeyValue>" + Base64.encode(pk.getEncoded()) + "</KeyValue>");
        XKMSTool.addKey(v, keypair.getPrivate(), password, resultChain);
    }

    private static void addKey(Vector aliases, PrivateKey privateKey, String password, X509Certificate[] chain) throws KeyStoreException {
        if (XKMSTool.isXkmsKeyStore()) {
            xks.addKey(aliases, privateKey, password.toCharArray(), chain);
        } else {
            Enumeration e = aliases.elements();
            if (e.hasMoreElements()) {
                ks.setKeyEntry((String)e.nextElement(), privateKey, password.toCharArray(), chain);
            }
        }
    }

    private static KeyPair generateKeyPair(int modulus) throws NoSuchAlgorithmException {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(modulus);
        return kpg.generateKeyPair();
    }

    private static Certificate readCert(String filename) throws Exception {
        FileInputStream fis = new FileInputStream(filename);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        Collection<? extends Certificate> c = cf.generateCertificates(fis);
        fis.close();
        Iterator<? extends Certificate> i = c.iterator();
        return i.next();
    }

    private static Key readKey(String filename) throws Exception {
        try {
            FileInputStream fis = new FileInputStream(filename);
            ObjectInputStream p = new ObjectInputStream(fis);
            RSAPrivateKey key = (RSAPrivateKey)p.readObject();
            fis.close();
            return key;
        }
        catch (StreamCorruptedException e) {
            XKMSTool.dbg(3, filename + " is not a serialized key.");
            XKMSTool.dbg(3, "Converting XML to java.security.RSAPublicKey");
            XMLResource xmlres = ResourceFactory.getXMLResource();
            FileInputStream fis = new FileInputStream(filename);
            return (RSAPrivateKey)KeyConverter.keyInfoToPrivateKey(xmlres.parseXML(fis, false), new XPath("/"));
        }
    }

    private static Key readPublicKey(String filename) throws Exception {
        try {
            FileInputStream fis = new FileInputStream(filename);
            ObjectInputStream p = new ObjectInputStream(fis);
            RSAPublicKey key = (RSAPublicKey)p.readObject();
            fis.close();
            return key;
        }
        catch (StreamCorruptedException e) {
            XKMSTool.dbg(3, filename + " is not a serialized key.");
            XKMSTool.dbg(3, "Converting XML to java.security.RSAPublicKey");
            XMLResource xmlres = ResourceFactory.getXMLResource();
            FileInputStream fis = new FileInputStream(filename);
            return (RSAPublicKey)KeyConverter.keyInfoToPublicKey(xmlres.parseXML(fis, false), new XPath("/"));
        }
    }

    private static void dbg(int level, String s) {
        Debug.out("[XKMSTool] " + s, level);
    }

    private static String findValue(String toFind, String[] argv) {
        return XKMSTool.findValue(false, toFind, argv);
    }

    private static String findValue(boolean required, String toFind, String[] argv) {
        int i = 0;
        while (i < argv.length) {
            if (argv[i].equals(toFind)) {
                String s = XKMSTool.nextArgv(argv, i);
                XKMSTool.dbg(4, "Argument: " + toFind + "=" + s);
                return s;
            }
            ++i;
        }
        if (required) {
            throw new IllegalArgumentException("'" + toFind + "' argument missing in input");
        }
        return null;
    }

    private static boolean findFlag(String toFind, String[] argv) {
        int i = 0;
        while (i < argv.length) {
            if (argv[i].equals(toFind)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String nextArgv(String[] argv, int i) {
        if (argv[i + 1] != null && !argv[i + 1].startsWith("-")) {
            return argv[i + 1];
        }
        return null;
    }

    static {
        xks = null;
        ks = null;
    }
}

