/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xkms.tools;

import com.verisign.domutil.DOMCursor;
import com.verisign.domutil.elements.ElementException;
import com.verisign.messaging.XmlTransport;
import com.verisign.messaging.XmlTransportSOAP;
import com.verisign.resource.ResourceFactory;
import com.verisign.resource.XMLResource;
import com.verisign.util.Namespaces;
import com.verisign.xkms.client.XKMSValidate;
import com.verisign.xkms.client.XKMSValidateResponse;
import com.verisign.xkms.tools.Debug;
import com.verisign.xkms.tools.XmlKeyStoreExtension;
import com.verisign.xkms.tools.elements.XmlKeyStore;
import com.verisign.xkms.tools.elements.XmlKeyStoreException;
import com.verisign.xmlenc.AlgorithmType;
import com.verisign.xmlenc.Decryptor;
import com.verisign.xmlenc.Encryptor;
import com.verisign.xpath.XPath;
import com.verisign.xpath.XPathException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import org.w3c.dom.Document;

public final class XKMSKeyStore
extends KeyStoreSpi {
    private XmlKeyStore keystore;
    private XMLResource xmlres;
    private KeyPair signingKeyPair = null;
    private boolean ENCRYPTEDSTORE = true;
    private static boolean DEBUG = false;
    private boolean ALLOW_NON_XKMS_KEYS = false;
    private static XmlTransport transport = null;
    private static String defaultServiceUri = "http://interop-xkms.verisign.com/xkms/Acceptor.nano";
    private static String defaultAutoload = "false";
    private static String defaultValidationInterval = "always";
    private static String signingKeyAlias = "__xkms_signing_key__";
    private String keyStorePassword;
    private HashMap validationMap = null;

    public boolean engineIsKeyEntry(String alias) {
        return this.keystore.isKey(alias);
    }

    public boolean engineIsCertificateEntry(String alias) {
        return this.keystore.isTrustedCert(alias);
    }

    public String engineGetCertificateAlias(Certificate cert) {
        if (!(cert instanceof X509Certificate)) {
            throw new IllegalArgumentException("Certificate is not X.509");
        }
        return this.keystore.getAliasFor((X509Certificate)cert);
    }

    public int engineSize() {
        return this.keystore.numberOfEntries();
    }

    public boolean engineContainsAlias(String alias) {
        boolean b = this.keystore.isKey(alias);
        return b ? true : this.keystore.isTrustedCert(alias);
    }

    public Enumeration engineAliases() {
        return this.keystore.aliases();
    }

    public void engineDeleteEntry(String alias) throws KeyStoreException {
        if (!this.engineContainsAlias(alias)) {
            throw new KeyStoreException(alias + " is not in the keystore");
        }
        this.keystore.delete(alias);
    }

    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        if (!(cert instanceof X509Certificate)) {
            throw new IllegalArgumentException("Certificate is not X.509");
        }
        if (!this.validateCert(cert)) {
            String s = "Certificate does not pass XKMS validation";
            throw new KeyStoreException(s);
        }
        this.keystore.addCertificate(alias, (X509Certificate)cert);
    }

    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        throw new UnsupportedOperationException("The XKMS KeyStore does not support arbitrary keys");
    }

    public void addKey(Vector aliases, PrivateKey privateKey, char[] password, X509Certificate[] chain) throws KeyStoreException {
        Key key = null;
        try {
            key = XKMSKeyStore.createKey(password);
        }
        catch (InvalidKeyException ike) {
            throw new KeyStoreException(ike.toString());
        }
        this.keystore.addKey(aliases, privateKey, key, chain);
    }

    public void engineSetKeyEntry(String alias, Key keyToStore, char[] password, Certificate[] chain) throws KeyStoreException {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        new Exception("MyException").printStackTrace(new PrintStream(bs));
        if (bs.toString().indexOf("sun.security.tools.KeyTool.doChangeKeyPasswd") == -1 && !this.ALLOW_NON_XKMS_KEYS) {
            String s = "You cannot add keys to this keystore using the -genkey, -selfcert, or -keyclone commands. You must use XKMSTool's -register command.";
            throw new KeyStoreException(s);
        }
        if (!(keyToStore instanceof PrivateKey)) {
            throw new KeyStoreException("Key must be a private key");
        }
        X509Certificate[] x509chain = new X509Certificate[chain.length];
        int i = 0;
        while (i < chain.length) {
            if (!(chain[i] instanceof X509Certificate)) {
                throw new KeyStoreException("Certificate must be X.509");
            }
            x509chain[i] = (X509Certificate)chain[i];
            ++i;
        }
        Vector<String> v = new Vector<String>();
        v.add(alias);
        this.addKey(v, (PrivateKey)keyToStore, password, x509chain);
    }

    public Date engineGetCreationDate(String alias) {
        if (!this.engineContainsAlias(alias)) {
            throw new IllegalStateException(alias + " is not in the keystore");
        }
        return this.keystore.getCreationDate(alias);
    }

    public Certificate engineGetCertificate(String alias) {
        X509Certificate cert = this.keystore.getCertificate(alias);
        if (!this.validateCert(cert)) {
            String s = "Certificate does not pass XKMS validation";
            throw new IllegalStateException(s);
        }
        return cert;
    }

    public Certificate[] engineGetCertificateChain(String alias) {
        if (!this.engineContainsAlias(alias)) {
            return null;
        }
        if (this.engineIsCertificateEntry(alias)) {
            return null;
        }
        Certificate[] certs = this.keystore.getCertificateChain(alias);
        if (!this.validateCert(certs[0])) {
            String s = "Leaf certificate does not pass XKMS validation";
            throw new IllegalStateException(s);
        }
        return certs;
    }

    public Key engineGetKey(String alias, char[] password) throws UnrecoverableKeyException {
        if (!this.engineIsKeyEntry(alias)) {
            return null;
        }
        Key key = null;
        try {
            key = XKMSKeyStore.createKey(password);
        }
        catch (InvalidKeyException ike) {
            throw new UnrecoverableKeyException(ike.toString());
        }
        try {
            Map map = this.keystore.getKeyAndCert(alias, key);
            Certificate cert = (Certificate)map.get("cert");
            if (!this.validateCert(cert)) {
                String s = "Key's certificate does not pass XKMS validation";
                throw new UnrecoverableKeyException(s);
            }
            return (Key)map.get("key");
        }
        catch (XmlKeyStoreException xkse) {
            throw new UnrecoverableKeyException(xkse.toString());
        }
    }

    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.keyStorePassword = new String(password);
        this.xmlres = ResourceFactory.getXMLResource();
        this.validationMap = new HashMap();
        if (stream == null) {
            this.keystore = new XmlKeyStore(null);
            XmlKeyStoreExtension ext = new XmlKeyStoreExtension();
            ext.setServiceUri(defaultServiceUri);
            ext.setValidationInterval(defaultValidationInterval);
            ext.setAutoload(defaultAutoload);
            this.keystore.setExtension(ext);
        } else {
            Document doc = this.xmlres.parseXML(stream, false);
            doc = this.decryptStore(doc, this.keyStorePassword.toCharArray());
            try {
                this.keystore = XmlKeyStore.fromXml(new DOMCursor(doc), new XmlKeyStoreExtension());
            }
            catch (ElementException e) {
                throw new IOException(e.toString());
            }
        }
    }

    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        DOMCursor c = this.keystore.toXml();
        Document doc = c.getDocument();
        doc = this.encryptStore(doc, password);
        this.xmlres.publish(doc, stream);
    }

    public void setServiceUri(String serviceURI) {
        XmlKeyStoreExtension ext = (XmlKeyStoreExtension)this.keystore.getExtension();
        ext.setServiceUri(serviceURI);
    }

    public void setValidationInterval(String validationInterval) {
        XmlKeyStoreExtension ext = (XmlKeyStoreExtension)this.keystore.getExtension();
        ext.setValidationInterval(validationInterval);
    }

    public void setAutoload(String autoload) {
        XmlKeyStoreExtension ext = (XmlKeyStoreExtension)this.keystore.getExtension();
        ext.setAutoload(autoload);
    }

    public String getSigningKeyAlias() {
        return signingKeyAlias;
    }

    public String getServiceUri() {
        if (this.keystore == null) {
            throw new IllegalStateException("gggdsfgds");
        }
        XmlKeyStoreExtension ext = (XmlKeyStoreExtension)this.keystore.getExtension();
        return ext.getServiceUri();
    }

    public String getValidationInterval() {
        XmlKeyStoreExtension ext = (XmlKeyStoreExtension)this.keystore.getExtension();
        return ext.getValidationInterval();
    }

    public String getAutoload() {
        XmlKeyStoreExtension ext = (XmlKeyStoreExtension)this.keystore.getExtension();
        return ext.getAutoload();
    }

    public void setDebug(PrintStream out, int level) {
        Debug.setLevel(level);
        Debug.setPrintStream(out);
    }

    private void getSigningPair() throws UnrecoverableKeyException {
        if (this.signingKeyPair != null) {
            return;
        }
        Key key = null;
        try {
            key = XKMSKeyStore.createKey(this.keyStorePassword.toCharArray());
        }
        catch (InvalidKeyException ike) {
            throw new UnrecoverableKeyException(ike.toString());
        }
        Map map = null;
        try {
            map = this.keystore.getKeyAndCert(signingKeyAlias, key);
        }
        catch (XmlKeyStoreException xkse) {
            throw new UnrecoverableKeyException(xkse.toString());
        }
        Certificate cert = (Certificate)map.get("cert");
        PrivateKey priv = (PrivateKey)map.get("key");
        this.signingKeyPair = new KeyPair(cert.getPublicKey(), priv);
    }

    private boolean validateCert(Certificate cert) {
        XKMSValidateResponse vr;
        XKMSValidate validate;
        boolean willValidate = false;
        String s = this.getValidationInterval();
        if ("always".equalsIgnoreCase(s)) {
            willValidate = true;
        } else if ("never".equalsIgnoreCase(s)) {
            willValidate = false;
        } else {
            Long then = (Long)this.validationMap.get(cert);
            if (then == null) {
                XKMSKeyStore.dbg(3, "Certificate has not been validated");
                willValidate = true;
            } else {
                XKMSKeyStore.dbg(3, "Key store validation interval: " + s + " s");
                long interval = Long.parseLong(s);
                if (interval == 0L) {
                    XKMSKeyStore.dbg(3, "Keystore set to always validate");
                    willValidate = true;
                } else {
                    long now = System.currentTimeMillis();
                    long duration = (now - then) / 1000L;
                    XKMSKeyStore.dbg(3, "Time since last validation: " + duration + " s");
                    if (duration > Long.parseLong(s)) {
                        willValidate = true;
                    }
                }
            }
        }
        if (!willValidate) {
            XKMSKeyStore.dbg(3, "Skipping validation");
            return true;
        }
        XKMSKeyStore.dbg(3, "Validating...");
        String[] responses = new String[]{"Status"};
        try {
            this.getSigningPair();
        }
        catch (UnrecoverableKeyException e) {
            XKMSKeyStore.dbg(3, e);
            return false;
        }
        try {
            validate = new XKMSValidate((X509Certificate)cert, responses, this.signingKeyPair);
        }
        catch (Exception e) {
            XKMSKeyStore.dbg(3, e);
            return false;
        }
        FileOutputStream debugos = null;
        if (Debug.getLevel() >= 3) {
            File tmpdir = new File(System.getProperty("java.io.tmpdir"));
            File debugout = new File(tmpdir, "keystore.out");
            try {
                debugos = new FileOutputStream(debugout);
                XKMSKeyStore.dbg(3, "sending debug output to " + debugout);
            }
            catch (FileNotFoundException e) {
                XKMSKeyStore.dbg(3, e);
                debugos = null;
            }
        }
        try {
            URL url = new URL(this.getServiceUri());
            XKMSKeyStore.dbg(3, "using XKMS service: " + url);
            transport = debugos != null ? new XmlTransportSOAP(url, debugos) : new XmlTransportSOAP(url);
        }
        catch (MalformedURLException e) {
            XKMSKeyStore.dbg(2, e);
            return false;
        }
        try {
            vr = validate.sendRequest(transport);
        }
        catch (Exception e) {
            XKMSKeyStore.dbg(2, e);
            return false;
        }
        XKMSKeyStore.dbg(3, "Response status is " + vr.getStatus());
        if (vr.getStatus() && vr.getAssertionStatus().equals("Valid")) {
            XKMSKeyStore.dbg(3, "Setting validation time");
            this.validationMap.put(cert, new Long(System.currentTimeMillis()));
            return true;
        }
        XKMSKeyStore.dbg(3, "Certificate status is not valid -- not setting validation time");
        return false;
    }

    private Document decryptStore(Document doc, char[] password) throws NoSuchAlgorithmException {
        Key key;
        if (!this.ENCRYPTEDSTORE) {
            return doc;
        }
        try {
            key = XKMSKeyStore.createKey(password);
        }
        catch (InvalidKeyException ike) {
            throw new NoSuchAlgorithmException(ike.toString());
        }
        String prefix = Namespaces.XMLENC.getPrefix();
        String uri = Namespaces.XMLENC.getUri();
        String[] ns = new String[]{prefix, uri};
        XPath xpath = new XPath("//" + prefix + ":EncryptedData", ns);
        Decryptor dec = new Decryptor(doc, key, xpath);
        try {
            return dec.decrypt();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Cannot decrypt keystore");
        }
        catch (XPathException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    private Document encryptStore(Document doc, char[] password) throws NoSuchAlgorithmException {
        Key key;
        if (!this.ENCRYPTEDSTORE) {
            return doc;
        }
        try {
            key = XKMSKeyStore.createKey(password);
        }
        catch (InvalidKeyException ike) {
            throw new NoSuchAlgorithmException(ike.toString());
        }
        Encryptor e = new Encryptor(doc, key, AlgorithmType.TRIPLEDES);
        XPath xpath = new XPath("/");
        try {
            return e.encrypt(xpath);
        }
        catch (XPathException xpe) {
            throw new IllegalArgumentException(xpe.toString());
        }
    }

    private static void dbg(int level, String s) {
        Debug.out("[XKMSKeyStore] " + s, level);
    }

    private static void dbg(int level, Exception e) {
        Debug.out("[XKMSKeyStore] " + e.toString(), level);
        if (Debug.getLevel() >= 3) {
            e.printStackTrace(Debug.getPrintStream());
        }
    }

    private static Key createKey(char[] password) throws InvalidKeyException {
        try {
            byte[] bytes = new byte[24];
            byte[] octet = XKMSKeyStore.hash(new String(password).getBytes());
            System.arraycopy(octet, 0, bytes, 0, 8);
            System.arraycopy(octet, 0, bytes, 16, 8);
            octet = XKMSKeyStore.hash(octet);
            System.arraycopy(octet, 0, bytes, 8, 8);
            DESedeKeySpec spec = new DESedeKeySpec(bytes);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DESede");
            return keyFactory.generateSecret(spec);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new InvalidKeyException(nsae.toString());
        }
        catch (InvalidKeySpecException ikse) {
            throw new InvalidKeyException(ikse.toString());
        }
    }

    private static byte[] hash(byte[] b) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA");
        return md.digest(b);
    }
}

