/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xkms.tools;

import com.verisign.messaging.InsecureTransportException;
import com.verisign.messaging.XmlMessageException;
import com.verisign.messaging.XmlTransport;
import com.verisign.messaging.XmlTransportDoc;
import com.verisign.messaging.XmlTransportSOAP;
import com.verisign.xkms.client.XKMSAuthInfo;
import com.verisign.xkms.client.XKMSException;
import com.verisign.xkms.client.XKMSKeyData;
import com.verisign.xkms.client.XKMSKeyName;
import com.verisign.xkms.client.XKMSRegister;
import com.verisign.xkms.client.XKMSRegisterResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Iterator;
import java.util.List;

class StoreXKMS {
    public static final String DEFAULT_KEYSTORE_NAME = ".keystore";
    static final File homeDir;
    static XmlTransport debugTransport;
    private XmlTransport transport = null;
    private boolean keyStoreLoaded = false;
    private boolean keyStoreChanged = false;
    protected String alias = null;
    protected KeyStore keyStore = null;
    protected String keyStorePass = null;
    protected String keyStoreName = null;
    private File keyStoreFile = new File(homeDir, ".keystore");
    protected boolean debugMode = false;
    protected boolean verboseMode = false;
    protected int keySize = 1024;
    protected String keyAlgorithm = "RSA";
    protected String keyStoreType = "JKS";
    protected String keyPass;
    protected URL serverURL;
    protected String revokePass;
    protected String commonName;
    protected String corp;
    protected String org;
    protected String city;
    protected String state;
    protected String country;
    protected String email;
    protected String jurisdiction;
    private String keyName;
    protected String sharedSecret;
    protected String raAlias;
    protected String raPass;

    public void outln(String message) {
        if (this.verboseMode || this.debugMode) {
            System.out.println(message);
        }
    }

    private XmlTransport getTransport() {
        if (this.transport == null) {
            this.transport = this.debugMode ? debugTransport : new XmlTransportSOAP(this.serverURL, System.out);
        }
        return this.transport;
    }

    public void addProvider(String providerClassName) {
        this.outln("Adding Provider: " + providerClassName);
        try {
            Class<?> providerClass = Class.forName(providerClassName);
            Provider provider = (Provider)providerClass.newInstance();
            Security.addProvider(provider);
        }
        catch (ClassNotFoundException cnf) {
            throw new RuntimeException("Provider class not found: " + providerClassName);
        }
        catch (InstantiationException inst) {
            throw new RuntimeException("Error instantiating class: " + providerClassName + ": " + inst);
        }
        catch (IllegalAccessException ia) {
            throw new RuntimeException("Error instantiating class: " + providerClassName + ": " + ia);
        }
    }

    public void addProviders(List providerList) {
        Iterator iter = providerList.iterator();
        while (iter.hasNext()) {
            this.addProvider((String)iter.next());
        }
    }

    public void loadKeyStore() throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (!this.keyStoreLoaded) {
            if (this.keyStoreName != null) {
                this.keyStoreFile = new File(this.keyStoreName);
            }
            if (this.keyStoreType == null) {
                this.keyStoreType = "JKS";
            }
            this.keyStore = KeyStore.getInstance(this.keyStoreType);
            char[] storePass = this.keyStorePass.toCharArray();
            if (this.keyStoreFile.exists()) {
                FileInputStream keyStoreIn = new FileInputStream(this.keyStoreFile);
                this.keyStore.load(keyStoreIn, storePass);
                ((InputStream)keyStoreIn).close();
            } else {
                this.outln("New KeyStore (" + this.keyStoreFile + ") ...");
                this.keyStore.load(null, storePass);
            }
            this.keyStoreLoaded = true;
        }
    }

    private String addURL(StringBuffer urlBuffer, String sep, String name, String value) {
        if (value != null) {
            urlBuffer.append(sep);
            urlBuffer.append(name);
            urlBuffer.append("=");
            urlBuffer.append(value);
            return "&";
        }
        return sep;
    }

    private void buildKeyName() {
        String sep = "?";
        StringBuffer urlBuffer = new StringBuffer("http://xkms.verisign.com/key");
        sep = this.addURL(urlBuffer, sep, "company", this.corp);
        sep = this.addURL(urlBuffer, sep, "org_unit", this.org);
        sep = this.addURL(urlBuffer, sep, "locality", this.city);
        sep = this.addURL(urlBuffer, sep, "state", this.state);
        sep = this.addURL(urlBuffer, sep, "country", this.country);
        sep = this.addURL(urlBuffer, sep, "mail_email", this.email);
        sep = this.addURL(urlBuffer, sep, "jurisdiction", this.jurisdiction);
        this.keyName = urlBuffer.toString();
        this.outln("<KeyName>" + this.keyName + "</KeyName>");
    }

    protected KeyPair genKeyPair(String algorithm, int keySize) throws NoSuchAlgorithmException, XKMSException {
        this.outln("Generating " + keySize + " bit " + algorithm + " Keypair ...");
        long startTime = System.currentTimeMillis();
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance(algorithm);
        keyGen.initialize(keySize);
        KeyPair result = keyGen.generateKeyPair();
        long duration = System.currentTimeMillis() - startTime;
        this.outln(" took " + (double)duration / 1000.0 + " seconds.");
        return result;
    }

    public void doRegister() throws IOException, GeneralSecurityException, InsecureTransportException, XmlMessageException {
        this.outln("doRegister()");
        this.loadKeyStore();
        this.buildKeyName();
        KeyPair keyPair = this.genKeyPair(this.keyAlgorithm, this.keySize);
        XKMSKeyName xkmsKeyName = new XKMSKeyName(this.keyName);
        XKMSKeyData xkmsKeyData = new XKMSKeyData(keyPair, xkmsKeyName);
        XKMSAuthInfo xkmsAuthInfo = new XKMSAuthInfo(this.revokePass, this.sharedSecret);
        XKMSRegister xkmsRegister = new XKMSRegister(xkmsKeyData, xkmsAuthInfo);
        long startReg = System.currentTimeMillis();
        this.outln("Registering ...");
        XKMSRegisterResponse resp = xkmsRegister.sendRequest(this.getTransport());
        long regduration = System.currentTimeMillis() - startReg;
        this.outln("Registered in " + (double)regduration / 1000.0 + " seconds.");
        if (!this.debugMode) {
            if (resp.getStatus()) {
                PrivateKey privateKey = keyPair.getPrivate();
                char[] keyPassCA = this.keyPass.toCharArray();
                Certificate[] certChain = resp.getChain();
                this.keyStore.setKeyEntry(this.alias, privateKey, keyPassCA, certChain);
                this.keyStoreChanged = true;
            } else {
                System.err.println("Got status error");
            }
        }
    }

    public void doRevoke() throws IOException, GeneralSecurityException, XKMSException {
        this.outln("doRevoke()");
        this.loadKeyStore();
        this.buildKeyName();
    }

    public void changedKeyStore() {
        this.keyStoreChanged = true;
    }

    public void saveKeyStore() throws IOException, NoSuchAlgorithmException, KeyStoreException, CertificateException {
        if (this.keyStoreChanged) {
            char[] storePass = this.keyStorePass.toCharArray();
            this.outln("Saving KeyStore to " + this.keyStoreFile + " ...");
            this.keyStoreFile.delete();
            FileOutputStream keyStoreOS = new FileOutputStream(this.keyStoreFile);
            this.keyStore.store(keyStoreOS, storePass);
            keyStoreOS.close();
        }
    }

    static {
        DEFAULT_KEYSTORE_NAME = DEFAULT_KEYSTORE_NAME;
        homeDir = new File(System.getProperty("user.home"));
        debugTransport = new XmlTransportDoc(System.out);
    }
}

