/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xkms.tools;

import com.verisign.xkms.tools.UsageException;
import com.verisign.xkms.tools.Useful;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Provider;
import java.security.Security;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class CheckJCE {
    static final String ALGORITHM_RESOURCE = "/com/verisign/xkms/tools/Algorithms.properties";
    static final Class[] stringArg;
    static final String USAGE_RESOURCE = "/com/verisign/xkms/tools/CheckJCE.usage";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$verisign$xkms$tools$CheckJCE;

    public void run() {
        try {
            System.out.println("Providers:");
            Provider[] providers = Security.getProviders();
            int i = 0;
            while (i < providers.length) {
                System.out.println(i + 1 + ": " + providers[i]);
                ++i;
            }
            System.out.println("");
            Properties alg = Useful.getPropertyResource(ALGORITHM_RESOURCE);
            TreeMap<Object, Object> algTree = new TreeMap<Object, Object>(alg);
            Iterator algIter = algTree.keySet().iterator();
            Object[] actArg = new String[1];
            while (algIter.hasNext()) {
                String algClassName = (String)algIter.next();
                String algs = alg.getProperty(algClassName);
                try {
                    this.getClass();
                    Class<?> algClass = Class.forName(algClassName);
                    Method getInstance = algClass.getMethod("getInstance", stringArg);
                    StringTokenizer algToks = new StringTokenizer(algs);
                    while (algToks.hasMoreTokens()) {
                        String algorithm;
                        actArg[0] = algorithm = algToks.nextToken();
                        System.out.print(algClassName + ".getInstance(" + algorithm + ")");
                        System.out.flush();
                        try {
                            Object algObj = getInstance.invoke(null, actArg);
                            Method getProvider = algClass.getMethod("getProvider", null);
                            Provider algProvider = (Provider)getProvider.invoke(algObj, null);
                            System.out.println("\t= " + algProvider);
                        }
                        catch (InvocationTargetException itex) {
                            System.out.println("\t### " + itex.getTargetException());
                        }
                    }
                }
                catch (ClassNotFoundException cnfex) {
                    System.out.println(algClassName + "\t### not found!");
                }
            }
        }
        catch (UsageException usage) {
            CheckJCE.usage(usage.getMessage());
        }
        catch (Exception except) {
            System.err.println("Unhandled Exception: " + except);
            except.printStackTrace(System.err);
        }
    }

    private static void usage(String message) {
        try {
            System.err.println("usage: " + message);
            Useful.printResource(System.err, USAGE_RESOURCE);
        }
        catch (Exception except) {
            System.err.println("Can not print usage: " + except);
            except.printStackTrace(System.err);
        }
        System.exit(1);
    }

    public static void main(String[] argv) {
        try {
            System.out.println("Running " + (class$com$verisign$xkms$tools$CheckJCE == null ? (class$com$verisign$xkms$tools$CheckJCE = CheckJCE.class$("com.verisign.xkms.tools.CheckJCE")) : class$com$verisign$xkms$tools$CheckJCE) + " ...");
            System.out.println("");
            Map args = Useful.parseCommand(argv);
            Useful.list(System.out, args);
            CheckJCE tool = new CheckJCE();
            tool.run();
        }
        catch (Throwable e) {
            System.out.println("Caught Exception " + e.getMessage());
            e.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ALGORITHM_RESOURCE = ALGORITHM_RESOURCE;
        stringArg = new Class[]{class$java$lang$String == null ? (class$java$lang$String = CheckJCE.class$("java.lang.String")) : class$java$lang$String};
        USAGE_RESOURCE = USAGE_RESOURCE;
    }
}

