/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xkms.client;

import com.verisign.digsig.keys.XKeyInfo;
import com.verisign.messaging.AbstractResponse;
import com.verisign.messaging.XmlRequest;
import com.verisign.xkms.client.XKMSKeyInfo;
import com.verisign.xkms.client.XKMSKeyInfoImpl;
import com.verisign.xkms.client.XKMSMalformedResponseException;
import com.verisign.xkms.client.XKMSServiceFailureException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Vector;
import org.w3c.dom.Document;

public class XKMSValidateResponse
extends AbstractResponse
implements XKMSKeyInfo {
    String assertionStatus = null;
    XKeyInfo kinfo = null;
    Date notBefore = null;
    Date notAfter = null;
    X509Certificate[] chain = null;
    Vector keyUsage = null;

    XKMSValidateResponse(XmlRequest req, boolean ok, Document resultDoc) throws XKMSMalformedResponseException, XKMSServiceFailureException {
        super(req, resultDoc);
        if (!ok) {
            throw new XKMSServiceFailureException(resultDoc);
        }
    }

    public String getKeyName() {
        return this.kinfo != null ? this.kinfo.getKeyName() : null;
    }

    public PublicKey getPublicKey() {
        try {
            return this.kinfo != null ? this.kinfo.getAsPublicKey() : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public X509Certificate getCert() {
        if (this.chain == null) {
            this.chain = XKMSKeyInfoImpl.getCertChainFromKeyInfo(this.getKeyInfo());
        }
        return this.chain.length > 0 ? this.chain[0] : null;
    }

    public X509Certificate[] getChain() {
        if (this.chain == null) {
            this.chain = XKMSKeyInfoImpl.getCertChainFromKeyInfo(this.getKeyInfo());
        }
        return this.chain;
    }

    public String getAssertionStatus() {
        return this.assertionStatus;
    }

    public Date getNotBefore() {
        return this.notBefore;
    }

    public Date getNotAfter() {
        return this.notAfter;
    }

    public XKeyInfo getKeyInfo() {
        return this.kinfo;
    }

    public Vector getKeyUsage() {
        return this.keyUsage;
    }

    public String getKeyID() {
        return null;
    }

    void setKeyInfo(XKMSKeyInfoImpl xkmsKeyInfo) {
        this.kinfo = xkmsKeyInfo.getAsXKeyInfo();
    }

    void setNotBefore(Date before) {
        this.notBefore = before;
    }

    void setNotAfter(Date after) {
        this.notAfter = after;
    }

    void setAssertionStatus(String status) {
        this.assertionStatus = status;
    }

    void addKeyUsage(String ku) {
        if (this.keyUsage == null) {
            this.keyUsage = new Vector();
        }
        this.keyUsage.add(ku);
    }

    void setKeyUsage(Vector kuv) {
        this.keyUsage = kuv;
    }
}

