/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xkms.client;

import com.nanobiz.xpath.XPathAPI;
import com.verisign.digsig.keys.XKeyInfo;
import com.verisign.digsig.keys.XRSAKeyValue;
import com.verisign.messaging.InsecureTransportException;
import com.verisign.messaging.XmlMessageException;
import com.verisign.messaging.XmlRequest;
import com.verisign.messaging.XmlResponse;
import com.verisign.messaging.XmlTransport;
import com.verisign.resource.DOMOperations;
import com.verisign.uuid.UUID;
import com.verisign.xkms.client.CertificateToKeyName;
import com.verisign.xkms.client.XKMSCommon;
import com.verisign.xkms.client.XKMSException;
import com.verisign.xkms.client.XKMSIllegalArgumentException;
import com.verisign.xkms.client.XKMSKeyInfoImpl;
import com.verisign.xkms.client.XKMSMalformedResponseException;
import com.verisign.xkms.client.XKMSRequest;
import com.verisign.xkms.client.XKMSServiceFailureException;
import com.verisign.xkms.client.XKMSSignatureVerificationException;
import com.verisign.xkms.client.XKMSValidateResponse;
import java.io.IOException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAKey;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.TimeZone;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class XKMSValidate
extends XKMSRequest {
    static final DOMOperations ops = DOMOperations.getInstance();
    static DateFormat isoDateFormat;
    private String requestUUID;
    Document request = null;
    String[] responses = null;
    private String requestKeyName;
    private PublicKey requestKeyValue;
    private KeyPair oldSigningKey;

    public XKMSValidate(String keyName, String[] responses) throws XKMSIllegalArgumentException, XKMSException {
        this.request = this.internalValidate(keyName, null, responses);
    }

    public XKMSValidate(String keyName, String[] responses, KeyPair signingKey) throws XKMSIllegalArgumentException, XKMSException {
        this.oldSigningKey = signingKey;
        this.request = this.internalValidate(keyName, null, responses);
    }

    public XKMSValidate(PublicKey publicKey, String[] responses) throws XKMSIllegalArgumentException, XKMSException {
        this.request = this.internalValidate(null, publicKey, responses);
    }

    public XKMSValidate(PublicKey publicKey, String[] responses, KeyPair signingKey) throws XKMSIllegalArgumentException, XKMSException {
        this.oldSigningKey = signingKey;
        this.request = this.internalValidate(null, publicKey, responses);
    }

    public XKMSValidate(X509Certificate cert, String[] responses, KeyPair signingKey) throws XKMSIllegalArgumentException, XKMSException {
        this.oldSigningKey = signingKey;
        this.request = this.internalValidate(CertificateToKeyName.certToKeyName(cert), null, responses);
    }

    public XKMSValidate(X509Certificate cert, String[] responses) throws XKMSIllegalArgumentException, XKMSException {
        this.request = this.internalValidate(CertificateToKeyName.certToKeyName(cert), null, responses);
    }

    public XKMSValidate(XKeyInfo kinfo, String[] responses) throws XKMSIllegalArgumentException, XKMSException {
        PublicKey publicKey;
        try {
            publicKey = kinfo.getKeyValue().getAsPublicKey();
        }
        catch (Exception e) {
            throw new XKMSIllegalArgumentException(e);
        }
        this.request = this.internalValidate(null, publicKey, responses);
    }

    public Document getXML() {
        return this.request;
    }

    public XmlResponse makeResponse(Document response) throws XKMSMalformedResponseException, XKMSSignatureVerificationException, XKMSServiceFailureException, XKMSException {
        return this.processValidateResult(this, response);
    }

    public XKMSValidateResponse send(XmlTransport transport) throws IOException, XKMSMalformedResponseException, XKMSSignatureVerificationException, XKMSServiceFailureException, XKMSIllegalArgumentException, InsecureTransportException, XKMSException, Exception {
        return (XKMSValidateResponse)transport.sendRequest(this);
    }

    public XKMSValidateResponse sendRequest(XmlTransport transport) throws IOException, XKMSMalformedResponseException, XKMSSignatureVerificationException, XKMSServiceFailureException, XKMSIllegalArgumentException, InsecureTransportException, XKMSException, XmlMessageException {
        return (XKMSValidateResponse)transport.sendRequest(this);
    }

    private Document internalValidate(String keyName, PublicKey publicKey, String[] responses) throws XKMSIllegalArgumentException {
        Document validateMsg = XKMSCommon.xml.createDocument();
        validateMsg.createProcessingInstruction("xml", "version=\"1.0\" encoding=\"UTF-8\"");
        this.responses = responses;
        this.requestKeyName = keyName;
        this.requestKeyValue = publicKey;
        Element top = XKMSCommon.addXKMSElement(validateMsg, "Validate");
        Element query = XKMSCommon.addXKMSElement(top, "Query");
        Element transID = XKMSCommon.addXKMSElement(query, "TransactionID");
        Element status = XKMSCommon.addXKMSElement(query, "Status");
        status.appendChild(validateMsg.createTextNode("Indeterminate"));
        this.requestUUID = UUID.generate().toString();
        transID.appendChild(validateMsg.createTextNode(this.requestUUID));
        XKeyInfo xki = new XKeyInfo(validateMsg);
        if (publicKey != null) {
            if (!publicKey.getAlgorithm().equals("RSA")) {
                throw new XKMSIllegalArgumentException("Cannot handle keys of '" + publicKey.getAlgorithm() + "' algorithm");
            }
            XRSAKeyValue kval = new XRSAKeyValue(validateMsg, (RSAKey)((Object)publicKey));
            xki.setKeyValue(kval);
        }
        if (keyName != null) {
            xki.setKeyName(keyName);
        }
        query.appendChild(xki.getElement());
        XKMSCommon.addRespondStrings(top, responses);
        if (this.oldSigningKey != null) {
            validateMsg = XKMSCommon.signRequest(validateMsg, this.oldSigningKey);
        }
        return validateMsg;
    }

    KeyPair getOldSigningKey() {
        return this.oldSigningKey;
    }

    private XmlResponse processValidateResult(XmlRequest req, Document result) throws XKMSMalformedResponseException, XKMSSignatureVerificationException, XKMSServiceFailureException {
        XKMSCommon.verifyTransactionID(result, this.requestUUID, "/xkms:ValidateResult/xkms:Answer/xkms:KeyBinding/xkms:TransactionID");
        int numResponses = this.responses.length;
        if (result == null) {
            return new XKMSValidateResponse(req, false, result);
        }
        String ill = "Ill-formed response from the validation server";
        String illVal = "Ill-formed validity interval in response from validation server";
        Element resulti = result.getDocumentElement();
        if (!"ValidateResult".equals(ops.getLocalName(resulti))) {
            throw new XKMSMalformedResponseException(ill + ": no ValidateResult", result);
        }
        String resultCode = XPathAPI.evaluateToString("xkms:Result/text()", resulti, XKMSCommon.xpathScope);
        if (resultCode == null) {
            throw new XKMSMalformedResponseException(ill + ": no Result tag", result);
        }
        if (!"Success".equals(resultCode)) {
            return new XKMSValidateResponse(req, false, result);
        }
        Hashtable ht = new Hashtable();
        XKMSValidateResponse resp = new XKMSValidateResponse(req, true, result);
        NodeList answer = (NodeList)XPathAPI.evaluate("xkms:Answer/xkms:KeyBinding", resulti, XKMSCommon.xpathScope);
        if (answer == null) {
            throw new XKMSMalformedResponseException(ill + ": no KeyBinding tags", result);
        }
        int i = 0;
        while (i < answer.getLength()) {
            Element ans = (Element)answer.item(i);
            Element returnElement = ops.firstElementChild(ans);
            while (returnElement != null) {
                String text;
                String nodeName = ops.getLocalName(returnElement);
                if (nodeName.equals("Status")) {
                    text = ops.stringValueOfNode(returnElement);
                    if (text == null || text.length() == 0) {
                        throw new XKMSMalformedResponseException(ill, result);
                    }
                    resp.setAssertionStatus(text);
                } else if (nodeName.equals("KeyID")) {
                    text = ops.stringValueOfNode(returnElement);
                    if (text == null || text.length() == 0) {
                        throw new XKMSMalformedResponseException(ill, result);
                    }
                } else if (nodeName.equals("KeyInfo")) {
                    XKeyInfo kinfo = new XKeyInfo(returnElement);
                    resp.setKeyInfo(new XKMSKeyInfoImpl(kinfo));
                } else if (nodeName.equals("ValidityInterval")) {
                    Date notBefore = new Date(0L);
                    Date notAfter = new Date(0L);
                    Element child = ops.firstElementChild(returnElement);
                    if ("NotBefore".equals(ops.getLocalName(child))) {
                        text = ops.stringValueOfNode(child);
                        if (text == null || text.length() == 0) {
                            throw new XKMSMalformedResponseException(illVal, result);
                        }
                        try {
                            notBefore = XKMSValidate.parseIsoDate(text);
                        }
                        catch (ParseException pe) {
                            throw new XKMSMalformedResponseException(pe, result);
                        }
                        child = ops.nextElementSibling(child);
                    }
                    if ("NotAfter".equals(ops.getLocalName(child))) {
                        text = ops.stringValueOfNode(child);
                        if (text == null || text.length() == 0) {
                            throw new XKMSMalformedResponseException(illVal, result);
                        }
                        try {
                            notAfter = XKMSValidate.parseIsoDate(text);
                        }
                        catch (ParseException pe) {
                            throw new XKMSMalformedResponseException(pe, result);
                        }
                    }
                    if (notBefore.getTime() != 0L) {
                        resp.setNotBefore(notBefore);
                    }
                    if (notAfter.getTime() != 0L) {
                        resp.setNotAfter(notAfter);
                    }
                } else if (nodeName.equals("KeyUsage")) {
                    text = ops.stringValueOfNode(returnElement);
                    if (text == null || text.length() == 0) {
                        throw new XKMSMalformedResponseException(ill, result);
                    }
                    resp.addKeyUsage(text);
                }
                returnElement = ops.nextElementSibling(returnElement);
            }
            ++i;
        }
        if (this.requestKeyName != null && !XKMSCommon.compareKeyNames(this.requestKeyName, resp.getKeyName())) {
            throw new XKMSMalformedResponseException("request key name (" + this.requestKeyName + ") response key name (" + resp.getKeyName() + ')', result);
        }
        if (!(this.requestKeyValue == null || resp.getPublicKey() != null && Arrays.equals(this.requestKeyValue.getEncoded(), resp.getPublicKey().getEncoded()))) {
            throw new XKMSMalformedResponseException("request key value (" + this.requestKeyValue + ") response key value (" + resp.getPublicKey() + ')', result);
        }
        if (resp.getStatus() && "Valid".equals(resp.getAssertionStatus())) {
            Date now = new Date();
            Date notBefore = resp.getNotBefore();
            Date notAfter = resp.getNotAfter();
            if (notBefore != null && now.before(notBefore) || notAfter != null && now.after(notAfter)) {
                throw new XKMSMalformedResponseException("The validity interval does not contain the current time (now=" + now + " NotBefore=" + notBefore + " NotAfter=" + notAfter + ") - possible replay attack", result);
            }
        }
        return resp;
    }

    private static Date parseIsoDate(String text) throws ParseException {
        int lenMinusOne;
        if (isoDateFormat == null) {
            isoDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            isoDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        if ((lenMinusOne = text.length() - 1) > 0 && text.charAt(lenMinusOne) == 'Z') {
            text = text.substring(0, lenMinusOne);
        }
        return isoDateFormat.parse(text);
    }
}

