/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xkms.client;

import com.verisign.crl.CRLTrustVerifier;
import com.verisign.messaging.XmlTransportSOAP;
import com.verisign.util.CertInfo;
import com.verisign.xkms.client.XKMSException;
import com.verisign.xkms.client.XKMSProvider;
import com.verisign.xkms.client.XKMSValidate;
import com.verisign.xkms.client.XKMSValidateResponse;
import java.io.PrintStream;
import java.net.URL;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.xmltrustcenter.verifier.TrustVerificationException;
import org.xmltrustcenter.verifier.TrustVerifier;

public class XKMSTrustVerifier
implements TrustVerifier {
    public static final URL XKMS_PRODUCTION_URL = CertInfo.XKMS_PRODUCTION_URL;
    public static final URL XKMS_PILOT_URL = CertInfo.XKMS_PILOT_URL;
    private static String[] RESPONSES = new String[]{"KeyName", "KeyValue", "Status"};
    private URL pilotUrl;
    private URL productionUrl;
    private TrustVerifier serviceVerifier;
    private TrustVerifier defaultTrustVerifier;
    private PrintStream logOutput;
    private boolean useDefaultVerifierWhenXKMSFails;

    public XKMSTrustVerifier(boolean productionOnly) throws XKMSException {
        this.productionUrl = CertInfo.XKMS_PRODUCTION_URL;
        if (!productionOnly) {
            this.pilotUrl = CertInfo.XKMS_PILOT_URL;
        }
        this.serviceVerifier = XKMSProvider.createTrustVerifier(productionOnly);
        try {
            this.defaultTrustVerifier = new CRLTrustVerifier();
        }
        catch (TrustVerificationException tve) {
            throw new XKMSException("Couldn't create CRLTrustVerifier()", tve);
        }
    }

    public XKMSTrustVerifier(URL pilotUrl, URL productionUrl) throws XKMSException {
        this.pilotUrl = pilotUrl;
        this.productionUrl = productionUrl;
        this.serviceVerifier = XKMSProvider.createTrustVerifier(pilotUrl == null);
        try {
            this.defaultTrustVerifier = new CRLTrustVerifier();
        }
        catch (TrustVerificationException tve) {
            throw new XKMSException("Couldn't create CRLTrustVerifier()", tve);
        }
    }

    public void setLogOutput(PrintStream logOutput) {
        this.logOutput = logOutput;
    }

    public void setDefaultTrustVerifier(TrustVerifier defaultVerifier) {
        this.defaultTrustVerifier = defaultVerifier;
    }

    public TrustVerifier getDefaultTrustVerifier() {
        return this.defaultTrustVerifier;
    }

    public void verifyTrust() throws TrustVerificationException {
        throw new TrustVerificationException();
    }

    public void verifyTrust(PublicKey key) throws TrustVerificationException {
        XKMSValidate request;
        String identifier = "Public Key";
        try {
            request = new XKMSValidate(key, RESPONSES);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.toString());
        }
        try {
            this.validate(request, identifier);
        }
        catch (TrustVerificationException e) {
            throw e;
        }
        catch (Exception e) {
            if (this.useDefaultVerifierWhenXKMSFails && this.defaultTrustVerifier != null) {
                try {
                    this.defaultTrustVerifier.verifyTrust(key);
                }
                catch (Exception e2) {
                    throw this.newSecondaryVerificationException(e, e2, identifier);
                }
            }
            throw this.newXKMSErrorException(e, identifier);
        }
    }

    public void verifyTrust(PublicKey key, String keyName) throws TrustVerificationException {
        XKMSValidate request;
        try {
            request = new XKMSValidate(keyName, RESPONSES);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.toString());
        }
        try {
            XKMSValidateResponse response = this.validate(request, keyName);
            if (!Arrays.equals(key.getEncoded(), response.getPublicKey().getEncoded())) {
                throw new TrustVerificationException("key name [" + keyName + "] validates but public key does not match");
            }
        }
        catch (TrustVerificationException e) {
            throw e;
        }
        catch (Exception e) {
            if (this.useDefaultVerifierWhenXKMSFails && this.defaultTrustVerifier != null) {
                try {
                    this.defaultTrustVerifier.verifyTrust(key, keyName);
                }
                catch (Exception e2) {
                    throw this.newSecondaryVerificationException(e, e2, keyName);
                }
            }
            throw this.newXKMSErrorException(e, keyName);
        }
    }

    public void verifyTrust(X509Certificate[] chain) throws TrustVerificationException {
        XKMSValidate request;
        X509Certificate cert = chain[0];
        try {
            request = new XKMSValidate(cert, RESPONSES);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.toString());
        }
        String certName = cert.getSubjectDN().getName();
        URL serviceUrl = XKMSTrustVerifier.getServiceForCertificate(cert);
        if (serviceUrl != null) {
            try {
                if (serviceUrl == XKMS_PRODUCTION_URL) {
                    serviceUrl = this.productionUrl;
                } else if (serviceUrl == XKMS_PILOT_URL) {
                    serviceUrl = this.pilotUrl;
                } else {
                    throw new IllegalStateException();
                }
                if (serviceUrl == null) {
                    throw new IllegalStateException("Cert cannot be validated because pilot or production XKMS is not enabled: " + certName);
                }
                this.validate(request, certName, serviceUrl);
            }
            catch (TrustVerificationException e) {
                throw e;
            }
            catch (Exception e) {
                if (this.useDefaultVerifierWhenXKMSFails && this.defaultTrustVerifier != null) {
                    try {
                        this.defaultTrustVerifier.verifyTrust(chain);
                    }
                    catch (Exception e2) {
                        throw this.newSecondaryVerificationException(e, e2, certName);
                    }
                }
                throw this.newXKMSErrorException(e, certName);
            }
        } else if (this.defaultTrustVerifier != null) {
            this.defaultTrustVerifier.verifyTrust(chain);
        } else {
            throw new TrustVerificationException("Cannot validate non-VeriSign cert with XKMS and no CRL/default trust verifier is available: " + certName);
        }
    }

    private XKMSValidateResponse validate(XKMSValidate request, String identifier) throws TrustVerificationException, Exception {
        if (this.pilotUrl != null) {
            if (this.productionUrl != null) {
                try {
                    return this.validate(request, identifier, this.pilotUrl);
                }
                catch (Exception e) {
                    return this.validate(request, identifier, this.productionUrl);
                }
            }
            return this.validate(request, identifier, this.pilotUrl);
        }
        if (this.productionUrl != null) {
            return this.validate(request, identifier, this.productionUrl);
        }
        throw new IllegalStateException("Cannot be validated because both pilot and production XKMS are disabled: " + identifier);
    }

    private XKMSValidateResponse validate(XKMSValidate request, String identifier, URL serviceUrl) throws TrustVerificationException, Exception {
        XKMSValidateResponse response;
        String status;
        XmlTransportSOAP transport = new XmlTransportSOAP(serviceUrl);
        transport.setTrustVerifier(this.serviceVerifier);
        if (this.logOutput != null) {
            transport.setLogOutput(this.logOutput);
        }
        if (!"Valid".equals(status = (response = request.sendRequest(transport)).getAssertionStatus())) {
            throw new TrustVerificationException("XKMS validation failed [" + status + "] for: " + identifier);
        }
        return response;
    }

    public static URL getServiceForCertificate(X509Certificate cert) {
        CertInfo certinfo = new CertInfo(cert);
        URL xkmsUrl = certinfo.getXkmsUrl();
        return xkmsUrl;
    }

    private TrustVerificationException newSecondaryVerificationException(Exception e, Exception e2, String identifier) {
        return new TrustVerificationException("XKMS validation error [" + e + "] for: " + identifier + " Default verifier also failed [" + e2 + ']', e);
    }

    private TrustVerificationException newXKMSErrorException(Exception e, String identifier) {
        return new TrustVerificationException("XKMS validation error [" + e + "] for: " + identifier);
    }
}

