/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xkms.client;

import com.verisign.digsig.keys.XKeyInfo;
import com.verisign.messaging.AbstractResponse;
import com.verisign.messaging.XmlRequest;
import com.verisign.xkms.client.XKMSKeyInfo;
import com.verisign.xkms.client.XKMSKeyInfoImpl;
import com.verisign.xkms.client.XKMSMalformedResponseException;
import com.verisign.xkms.client.XKMSServiceFailureException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import org.w3c.dom.Document;

public class XKMSRegisterResponse
extends AbstractResponse
implements XKMSKeyInfo {
    PrivateKey privKey;
    X509Certificate[] chain;
    XKeyInfo kinfo;

    XKMSRegisterResponse(XmlRequest req, boolean ok, Document resultDoc, PrivateKey privK, XKeyInfo kinfo) throws XKMSMalformedResponseException, XKMSServiceFailureException {
        super(req, resultDoc);
        if (!ok) {
            throw new XKMSServiceFailureException(resultDoc);
        }
        this.privKey = privK;
        this.kinfo = kinfo;
    }

    public String getKeyName() {
        return this.kinfo != null ? this.kinfo.getKeyName() : null;
    }

    public PublicKey getPublicKey() {
        try {
            return this.kinfo != null ? this.kinfo.getAsPublicKey() : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public X509Certificate getCert() {
        if (this.chain == null) {
            this.chain = XKMSKeyInfoImpl.getCertChainFromKeyInfo(this.kinfo);
        }
        return this.chain.length > 0 ? this.chain[0] : null;
    }

    public X509Certificate[] getChain() {
        if (this.chain == null) {
            this.chain = XKMSKeyInfoImpl.getCertChainFromKeyInfo(this.kinfo);
        }
        return this.chain;
    }

    public PrivateKey getPrivateKey() {
        return null;
    }
}

