/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xkms.client;

import com.verisign.domutil.DOMCursor;
import com.verisign.messaging.MessageProvider;
import com.verisign.messaging.XmlMessageException;
import com.verisign.messaging.XmlRequest;
import com.verisign.messaging.XmlTransport;
import com.verisign.messaging.XmlTransportSecurity;
import com.verisign.resource.ResourceFactory;
import com.verisign.xkms.client.XKMSCommon;
import com.verisign.xkms.client.XKMSException;
import com.verisign.xkms.client.XKMSIllegalArgumentException;
import com.verisign.xkms.client.XKMSLocate;
import com.verisign.xkms.client.XKMSValidate;
import com.verisign.xmlsig.util.XMLSigSchema;
import com.verisign.xpath.XPath;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.xmltrustcenter.verifier.SimpleTrustVerifier;
import org.xmltrustcenter.verifier.TrustVerifier;

public class XKMSProvider
extends MessageProvider {
    private static final String[] SCHEMA_FILES = new String[]{"xkms-2001-01-20.xsd"};
    private static Document[] schemaDocuments;
    private static MessageProvider defaultProvider;
    private TrustVerifier verifier = XKMSProvider.createTrustVerifier(false);
    static /* synthetic */ Class class$com$verisign$xkms$client$XKMSProvider;

    public static MessageProvider getDefaultProvider() throws XKMSException {
        if (defaultProvider == null) {
            defaultProvider = new XKMSProvider();
        }
        return defaultProvider;
    }

    public static void setDefaultProvider(MessageProvider provider) {
        defaultProvider = provider;
    }

    public XKMSProvider() throws XKMSException {
        if (this.verifier == null) {
            throw XKMSProvider.noTrustPointsException();
        }
    }

    public void checkTransport(XmlTransport transport, XmlRequest request) throws XmlMessageException {
        XKMSLocate loc;
        XKMSValidate val;
        XmlTransportSecurity sec;
        boolean oldSigning = false;
        boolean transportSigning = false;
        if (transport instanceof XmlTransportSecurity && (sec = (XmlTransportSecurity)((Object)transport)).getSigningPrivateKey() != null) {
            transportSigning = true;
        }
        if (request instanceof XKMSValidate && (val = (XKMSValidate)request).getOldSigningKey() != null) {
            oldSigning = true;
        }
        if (request instanceof XKMSLocate && (loc = (XKMSLocate)request).getOldSigningKey() != null) {
            oldSigning = true;
        }
        if (oldSigning && transportSigning) {
            throw new XKMSIllegalArgumentException("Both a transport signing key and message signing key may not be used -- please use the XKMSLocate or XKMSValidate constructor without a signing key");
        }
    }

    public TrustVerifier getDefaultTrustVerifier() {
        return this.verifier;
    }

    public XPath getRequestSignatureLocation(Document request) {
        DOMCursor c = new DOMCursor(request);
        if (c.atElement("http://www.xkms.org/schema/xkms-2001-01-20", "Validate") || c.atElement("http://www.xkms.org/schema/xkms-2001-01-20", "Locate")) {
            return MessageProvider.ROOT_ELEMENT_XPATH;
        }
        return null;
    }

    public XPath getResponseSignatureLocation(Document response) {
        return MessageProvider.LAST_CHILD_XPATH;
    }

    public Document[] getSchemaDocuments() throws XmlMessageException {
        if (schemaDocuments != null) {
            return schemaDocuments;
        }
        schemaDocuments = new Document[SCHEMA_FILES.length + 1];
        try {
            int i = 0;
            while (i < SCHEMA_FILES.length) {
                InputStream is = (class$com$verisign$xkms$client$XKMSProvider == null ? XKMSProvider.class$("com.verisign.xkms.client.XKMSProvider") : class$com$verisign$xkms$client$XKMSProvider).getResourceAsStream(SCHEMA_FILES[i]);
                InputStreamReader reader = new InputStreamReader(is);
                XKMSProvider.schemaDocuments[i] = ResourceFactory.getXMLResource().parseXML(reader);
                reader.close();
                ++i;
            }
            XKMSProvider.schemaDocuments[XKMSProvider.SCHEMA_FILES.length] = XMLSigSchema.getSchemaDocument();
        }
        catch (IOException e) {
            throw new XmlMessageException("Error loading schema documents", e);
        }
        return schemaDocuments;
    }

    public static TrustVerifier createTrustVerifier(boolean productionOnly) throws XKMSException {
        try {
            ArrayList<PublicKey> list = new ArrayList<PublicKey>();
            PublicKey key = XKMSCommon.getResponseVerifyingKey(true);
            if (key != null) {
                list.add(key);
            }
            if (!productionOnly && (key = XKMSCommon.getResponseVerifyingKey(false)) != null) {
                list.add(key);
            }
            if (list.size() != 0) {
                return new SimpleTrustVerifier(list);
            }
            throw XKMSProvider.noTrustPointsException();
        }
        catch (IOException e) {
            throw new XKMSException(e);
        }
        catch (GeneralSecurityException e) {
            throw new XKMSException(e);
        }
    }

    private static XKMSException noTrustPointsException() {
        return new XKMSException("No XKMS trustpoints available, you may need to put xml_pilot_key.jar or xml_prod_key.jar in your classpath");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

