/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xkms.client;

import com.nanobiz.xpath.XPathAPI;
import com.verisign.digsig.keys.XKeyInfo;
import com.verisign.digsig.keys.XRSAKeyValue;
import com.verisign.digsig.keys.XRetrievalMethod;
import com.verisign.messaging.InsecureTransportException;
import com.verisign.messaging.XmlMessageException;
import com.verisign.messaging.XmlResponse;
import com.verisign.messaging.XmlTransport;
import com.verisign.resource.DOMOperations;
import com.verisign.uuid.UUID;
import com.verisign.xkms.client.CertificateToKeyName;
import com.verisign.xkms.client.XKMSCommon;
import com.verisign.xkms.client.XKMSException;
import com.verisign.xkms.client.XKMSIllegalArgumentException;
import com.verisign.xkms.client.XKMSKeyInfo;
import com.verisign.xkms.client.XKMSLocateResponse;
import com.verisign.xkms.client.XKMSMalformedResponseException;
import com.verisign.xkms.client.XKMSRequest;
import com.verisign.xkms.client.XKMSRetrievalMethod;
import com.verisign.xkms.client.XKMSServiceFailureException;
import com.verisign.xkms.client.XKMSSignatureVerificationException;
import java.io.IOException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAKey;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class XKMSLocate
extends XKMSRequest {
    static final DOMOperations ops = DOMOperations.getInstance();
    public static final String KeyName = "KeyName";
    public static final String KeyValue = "KeyValue";
    public static final String MgmtData = "MgmtData";
    public static final String OCSP = "OCSP";
    public static final String PGP = "PGP";
    public static final String PGPWeb = "PGPWeb";
    public static final String Multiple = "Multiple";
    public static final String Private = "Private";
    public static final String RetrievalMethod = "RetrievalMethod";
    public static final String SPKI = "SPKI";
    public static final String X509Chain = "X509Chain";
    public static final String X509CRL = "X509CRL";
    public static final String X509Cert = "X509Cert";
    private String requestUUID;
    Document request = null;
    String[] responses = null;
    private String requestKeyName;
    private PublicKey requestKeyValue;
    private KeyPair oldSigningKey;

    private XKMSLocate(XKMSRetrievalMethod retrievalMethod, String[] responses) throws XKMSIllegalArgumentException, XKMSException {
        this.request = XKMSCommon.xml.createDocument();
        this.responses = responses;
        this.request.createProcessingInstruction("xml", "version=\"1.0\" encoding=\"UTF-8\"");
        Element top = XKMSCommon.addXKMSElement(this.request, "Locate");
        Element query = XKMSCommon.addXKMSElement(top, "Query");
        XKeyInfo xki = new XKeyInfo(this.request);
        XRetrievalMethod rm = new XRetrievalMethod(this.request, retrievalMethod.getURL(), retrievalMethod.getType());
        xki.setRetrievalMethod(rm);
        query.appendChild(xki.getElement());
        XKMSCommon.addRespondStrings(top, responses);
    }

    public XKMSLocate(String keyName, String[] responses) throws XKMSIllegalArgumentException, XKMSException {
        this.request = this.internalLocate(null, keyName, responses);
    }

    public XKMSLocate(String keyName, String[] responses, KeyPair signingKey) throws XKMSIllegalArgumentException, XKMSException {
        this.oldSigningKey = signingKey;
        this.request = this.internalLocate(null, keyName, responses);
    }

    public XKMSLocate(PublicKey key, String[] responses) throws XKMSIllegalArgumentException, XKMSException {
        this.request = this.internalLocate(key, null, responses);
    }

    public XKMSLocate(PublicKey key, String[] responses, KeyPair signingKey) throws XKMSIllegalArgumentException, XKMSException {
        this.oldSigningKey = signingKey;
        this.request = this.internalLocate(key, null, responses);
    }

    public XKMSLocate(X509Certificate cert, String[] responses) throws XKMSIllegalArgumentException, XKMSException {
        this.request = this.internalLocate(null, CertificateToKeyName.certToKeyName(cert), responses);
    }

    public XKMSLocate(X509Certificate cert, String[] responses, KeyPair signingKey) throws XKMSIllegalArgumentException, XKMSException {
        this.oldSigningKey = signingKey;
        this.request = this.internalLocate(null, CertificateToKeyName.certToKeyName(cert), responses);
    }

    public XKMSLocateResponse send(XmlTransport transport) throws IOException, XKMSMalformedResponseException, XKMSServiceFailureException, XKMSIllegalArgumentException, XKMSSignatureVerificationException, InsecureTransportException, XKMSException, Exception {
        return (XKMSLocateResponse)transport.sendRequest(this);
    }

    public XKMSLocateResponse sendRequest(XmlTransport transport) throws IOException, XKMSMalformedResponseException, XKMSServiceFailureException, XKMSIllegalArgumentException, XKMSSignatureVerificationException, InsecureTransportException, XKMSException, XmlMessageException {
        return (XKMSLocateResponse)transport.sendRequest(this);
    }

    public Document getXML() {
        return this.request;
    }

    public XmlResponse makeResponse(Document response) throws XKMSMalformedResponseException, XKMSServiceFailureException, XKMSIllegalArgumentException, XKMSSignatureVerificationException, XKMSException {
        return this.processLocateResult(this, response);
    }

    private Document internalLocate(PublicKey publicKey, String Keyname, String[] responses) throws XKMSIllegalArgumentException {
        Document locateMsg = XKMSCommon.xml.createDocument();
        this.responses = responses;
        this.requestKeyName = Keyname;
        this.requestKeyValue = publicKey;
        locateMsg.createProcessingInstruction("xml", "version=\"1.0\" encoding=\"UTF-8\"");
        Element top = XKMSCommon.addXKMSElement(locateMsg, "Locate");
        Element transID = XKMSCommon.addXKMSElement(top, "TransactionID");
        Element query = XKMSCommon.addXKMSElement(top, "Query");
        this.requestUUID = UUID.generate().toString();
        transID.appendChild(locateMsg.createTextNode(this.requestUUID));
        XKeyInfo xki = new XKeyInfo(locateMsg);
        if (publicKey != null) {
            if (!publicKey.getAlgorithm().equals("RSA")) {
                throw new XKMSIllegalArgumentException("Cannot handle keys of '" + publicKey.getAlgorithm() + "' algorithm");
            }
            XRSAKeyValue kval = new XRSAKeyValue(locateMsg, (RSAKey)((Object)publicKey));
            xki.setKeyValue(kval);
        }
        if (Keyname != null) {
            xki.setKeyName(Keyname);
        }
        query.appendChild(xki.getElement());
        XKMSCommon.addRespondStrings(top, responses);
        if (this.oldSigningKey != null) {
            locateMsg = XKMSCommon.signRequest(locateMsg, this.oldSigningKey);
        }
        return locateMsg;
    }

    KeyPair getOldSigningKey() {
        return this.oldSigningKey;
    }

    private XmlResponse processLocateResult(XKMSLocate req, Document result) throws XKMSMalformedResponseException, XKMSServiceFailureException, XKMSIllegalArgumentException, XKMSSignatureVerificationException {
        XKMSCommon.verifyTransactionID(result, this.requestUUID, "/xkms:LocateResult/xkms:TransactionID");
        boolean success = true;
        String mal = "Malformed response from server: ";
        if (result == null) {
            return new XKMSLocateResponse(req, false, result);
        }
        Element resulti = result.getDocumentElement();
        if (!"LocateResult".equals(ops.getLocalName(resulti))) {
            throw new XKMSMalformedResponseException(mal + "no LocateResult", result);
        }
        String resultCode = XPathAPI.evaluateToString("xkms:Result/text()", resulti, XKMSCommon.xpathScope);
        if (resultCode == null) {
            throw new XKMSMalformedResponseException(mal + "no Result tag", result);
        }
        if (!"Success".equals(resultCode)) {
            return new XKMSLocateResponse(req, false, result);
        }
        Element answer = (Element)XPathAPI.evaluateToNode("xkms:Answer", resulti, XKMSCommon.xpathScope);
        if (answer == null) {
            throw new XKMSMalformedResponseException(mal + "no Answer tag", result);
        }
        XKMSLocateResponse resp = new XKMSLocateResponse(req, success, result);
        Element ans = ops.firstElementChild(answer);
        while (ans != null) {
            if (!"KeyInfo".equals(ops.getLocalName(ans))) {
                throw new XKMSMalformedResponseException("Unknown response " + ans.getNodeName() + " returned.", result);
            }
            XKeyInfo kinfo = new XKeyInfo(ans);
            resp.appendKeyInfo(kinfo);
            ans = ops.nextElementSibling(ans);
        }
        List respKeyInfos = resp.getXKMSKeyInfos();
        int i = 0;
        while (i < respKeyInfos.size()) {
            XKMSKeyInfo respKeyInfo = (XKMSKeyInfo)respKeyInfos.get(i);
            if (this.requestKeyName != null && !XKMSCommon.compareKeyNames(this.requestKeyName, respKeyInfo.getKeyName())) {
                throw new XKMSMalformedResponseException("request key name (" + this.requestKeyName + ") response key name (" + respKeyInfo.getKeyName() + ')', result);
            }
            if (!(this.requestKeyValue == null || respKeyInfo.getPublicKey() != null && Arrays.equals(this.requestKeyValue.getEncoded(), respKeyInfo.getPublicKey().getEncoded()))) {
                throw new XKMSMalformedResponseException("request key value (" + this.requestKeyValue + ") response key value (" + respKeyInfo.getPublicKey() + ')', result);
            }
            ++i;
        }
        return resp;
    }

    static {
        KeyName = KeyName;
        KeyValue = KeyValue;
        MgmtData = MgmtData;
        OCSP = OCSP;
        PGP = PGP;
        PGPWeb = PGPWeb;
        Multiple = Multiple;
        Private = Private;
        RetrievalMethod = RetrievalMethod;
        SPKI = SPKI;
        X509Chain = X509Chain;
        X509CRL = X509CRL;
        X509Cert = X509Cert;
    }
}

