/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xkms.client;

import com.verisign.digsig.keys.X509Data;
import com.verisign.digsig.keys.XKeyInfo;
import com.verisign.digsig.keys.XRSAKeyValue;
import com.verisign.xkms.client.XKMSIllegalArgumentException;
import com.verisign.xkms.client.XKMSKeyInfo;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAKey;
import java.util.Enumeration;
import java.util.LinkedList;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Document;

class XKMSKeyInfoImpl
implements XKMSKeyInfo {
    XKeyInfo xKeyInfo = null;
    X509Certificate[] chain = null;

    XKMSKeyInfoImpl(XKeyInfo xKeyInfo) {
        this.xKeyInfo = xKeyInfo;
    }

    XKeyInfo getAsXKeyInfo() {
        return this.xKeyInfo;
    }

    XKMSKeyInfoImpl(PublicKey publicKey) {
        RSAKey rsaKey;
        try {
            rsaKey = (RSAKey)((Object)publicKey);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Only RSA keys are supported");
        }
        DocumentImpl doc = new DocumentImpl();
        this.xKeyInfo = new XKeyInfo((Document)doc);
        XRSAKeyValue rkval = new XRSAKeyValue((Document)doc, rsaKey);
        this.xKeyInfo.setKeyValue(rkval);
    }

    public PublicKey getPublicKey() throws XKMSIllegalArgumentException {
        try {
            return this.xKeyInfo.getAsPublicKey();
        }
        catch (Exception e) {
            throw new XKMSIllegalArgumentException(e);
        }
    }

    public String getKeyName() {
        return this.xKeyInfo.getKeyName();
    }

    public X509Certificate getCert() {
        if (this.chain == null) {
            this.chain = XKMSKeyInfoImpl.getCertChainFromKeyInfo(this.xKeyInfo);
        }
        return this.chain.length > 0 ? this.chain[0] : null;
    }

    public X509Certificate[] getChain() {
        if (this.chain == null) {
            this.chain = XKMSKeyInfoImpl.getCertChainFromKeyInfo(this.xKeyInfo);
        }
        return this.chain;
    }

    static X509Certificate[] getCertChainFromKeyInfo(XKeyInfo keyInfo) {
        Enumeration certEnum = keyInfo.enumX509Data();
        LinkedList<X509Certificate> certList = new LinkedList<X509Certificate>();
        while (certEnum.hasMoreElements()) {
            X509Data data = (X509Data)certEnum.nextElement();
            X509Certificate cert = data.getCertificate();
            X509Certificate[] subChain = data.getCertChain();
            if (subChain != null) {
                int j = 0;
                while (j < subChain.length) {
                    certList.add(subChain[j]);
                    ++j;
                }
                continue;
            }
            certList.add(cert);
        }
        X509Certificate[] chain = new X509Certificate[certList.size()];
        int i = 0;
        while (i < chain.length) {
            chain[i] = (X509Certificate)certList.get(i);
            ++i;
        }
        return chain;
    }
}

