/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xkms.client;

import com.verisign.digsig.keys.XKeyInfo;
import com.verisign.digsig.keys.XRSAKeyValue;
import com.verisign.xkms.client.XKMSIllegalArgumentException;
import com.verisign.xkms.client.XKMSKeyInfoImpl;
import com.verisign.xkms.client.XKMSKeyName;
import com.verisign.xmlsig.RSASigningKey;
import com.verisign.xmlsig.SigningKey;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAKey;
import org.w3c.dom.Document;

public class XKMSKeyData {
    byte[] spkidata;
    XKMSKeyName kname;
    PublicKey publicKey;
    PrivateKey privateKey;
    SigningKey signingKey;

    public XKMSKeyData(KeyPair keyPair, XKMSKeyName keyName) {
        if (keyPair != null) {
            this.publicKey = keyPair.getPublic();
            this.privateKey = keyPair.getPrivate();
            try {
                this.signingKey = new RSASigningKey(this.privateKey);
            }
            catch (InvalidKeyException invalidKeyException) {
                // empty catch block
            }
        }
        this.kname = keyName;
    }

    public XKMSKeyData(SigningKey signingKey, PublicKey publicKey, XKMSKeyName keyName) {
        this.kname = keyName;
        this.publicKey = publicKey;
        this.signingKey = signingKey;
    }

    XKMSKeyData(PublicKey pk) {
        this.publicKey = pk;
    }

    public XKMSKeyData(KeyPair keyPair, XKMSKeyName keyName, byte[] spkidata) {
        if (keyPair != null) {
            this.publicKey = keyPair.getPublic();
            this.privateKey = keyPair.getPrivate();
            try {
                this.signingKey = new RSASigningKey(this.privateKey);
            }
            catch (InvalidKeyException e) {
                // empty catch block
            }
        }
        this.kname = keyName;
        this.spkidata = spkidata;
    }

    public XKMSKeyData(XKMSKeyName keyName) {
        this.kname = keyName;
    }

    public boolean returningPrivateKey() {
        return this.signingKey == null;
    }

    public String getKeyName() {
        return this.kname != null ? this.kname.getKeyName() : null;
    }

    PublicKey getPublicKey() {
        return this.publicKey;
    }

    PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    SigningKey getSigningKey() {
        return this.signingKey;
    }

    public KeyPair getKeyPair() {
        if (this.publicKey != null && this.privateKey != null) {
            return new KeyPair(this.publicKey, this.privateKey);
        }
        return null;
    }

    public XKeyInfo getKeyInfo(Document doc) throws XKMSIllegalArgumentException {
        XKMSKeyInfoImpl xkmsKeyInfo = this.getXKMSKeyInfo(doc);
        return xkmsKeyInfo.getAsXKeyInfo();
    }

    private XKMSKeyInfoImpl getXKMSKeyInfo(Document doc) throws XKMSIllegalArgumentException {
        XKeyInfo xki = new XKeyInfo(doc);
        if (this.publicKey != null) {
            if (!this.publicKey.getAlgorithm().equals("RSA")) {
                throw new XKMSIllegalArgumentException("Cannot handle keys of '" + this.publicKey.getAlgorithm() + "' algorithm");
            }
            XRSAKeyValue kval = new XRSAKeyValue(doc, (RSAKey)((Object)this.publicKey));
            xki.setKeyValue(kval);
        }
        if (this.kname != null) {
            xki.setKeyName(this.kname.getKeyName());
        }
        return new XKMSKeyInfoImpl(xki);
    }

    public byte[] getSpkiData() {
        return this.spkidata;
    }
}

