/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xkms.client;

import com.nanobiz.xpath.XPathAPI;
import com.verisign.messaging.XmlMessageException;
import com.verisign.xkms.client.XKMSCommon;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XKMSException
extends XmlMessageException {
    private String resultCode = null;
    private String errorCode = null;
    private String errorDescription = null;

    XKMSException(Document response) {
        super(response);
        this.parse();
    }

    XKMSException(Exception cause, Document response) {
        super(cause, response);
        this.parse();
    }

    XKMSException(Exception cause) {
        super(cause);
    }

    XKMSException(String s, Document response, Exception cause) {
        super(s, cause, response);
        this.parse();
    }

    XKMSException(String s, Exception cause) {
        super(s, cause);
    }

    XKMSException(String s, Document response) {
        super(s, response);
        this.parse();
    }

    XKMSException(String s) {
        super(s);
    }

    public String getResultCode() {
        return this.resultCode;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorDescription() {
        return this.errorDescription != null ? this.errorDescription : super.getMessage();
    }

    public String getMessage() {
        return super.getMessage() != null ? super.getMessage() : this.errorDescription;
    }

    public Exception detail() {
        Throwable e = this.getCause();
        if (e instanceof Exception) {
            return (Exception)e;
        }
        return null;
    }

    private void parse() {
        Document response = this.getXML();
        if (response != null) {
            this.parseResultCode(response);
            this.parseErrorCode(response);
            this.parseErrorDescription(response);
            if ("NoSuchJurisdiction".equals(this.errorCode) && "Failure".equals(this.resultCode)) {
                this.resultCode = "NoMatch";
            }
        }
    }

    private void parseResultCode(Document response) {
        Node node;
        Node n = XPathAPI.evaluateToNode(".//xkms:Result", response, XKMSCommon.xpathScope);
        if (n != null && (node = n.getFirstChild()) != null && node.getNodeType() == 3) {
            this.resultCode = node.getNodeValue();
        }
    }

    private void parseErrorCode(Document response) {
        Node n = XPathAPI.evaluateToNode(".//xkms:ErrorInfo", response, XKMSCommon.xpathScope);
        if (n != null) {
            this.errorCode = ((Element)n).getAttributeNS(null, "errorCode");
        }
    }

    private void parseErrorDescription(Document response) {
        Node node;
        Node n = XPathAPI.evaluateToNode(".//xkms:ErrorDescription", response, XKMSCommon.xpathScope);
        if (n != null && (node = n.getFirstChild()) != null && node.getNodeType() == 3) {
            this.errorDescription = node.getNodeValue();
        }
    }
}

