/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xkms.client;

import com.nanobiz.xpath.XPathAPI;
import com.verisign.digsig.keys.XKeyInfo;
import com.verisign.digsig.keys.XRSAKeyValue;
import com.verisign.messaging.AbstractResponse;
import com.verisign.messaging.AbstractTransport;
import com.verisign.messaging.MessageProvider;
import com.verisign.messaging.XmlMessageException;
import com.verisign.messaging.XmlRequest;
import com.verisign.messaging.XmlResponse;
import com.verisign.resource.DOMOperations;
import com.verisign.resource.ResourceFactory;
import com.verisign.resource.XMLResource;
import com.verisign.uuid.UUID;
import com.verisign.xenc.EncryptedKey;
import com.verisign.xenc.InitializationException;
import com.verisign.xkms.client.XKMSAuthInfo;
import com.verisign.xkms.client.XKMSException;
import com.verisign.xkms.client.XKMSIllegalArgumentException;
import com.verisign.xkms.client.XKMSKeyData;
import com.verisign.xkms.client.XKMSMalformedResponseException;
import com.verisign.xkms.client.XKMSProcessInfo;
import com.verisign.xkms.client.XKMSProvider;
import com.verisign.xkms.client.XKMSRecoverResponse;
import com.verisign.xkms.client.XKMSRegisterResponse;
import com.verisign.xkms.client.XKMSRequest;
import com.verisign.xkms.client.XKMSRevokeResponse;
import com.verisign.xkms.client.XKMSServiceFailureException;
import com.verisign.xkms.client.XKMSSignatureVerificationException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class XKMSCommon
extends XKMSRequest {
    static final int UNKNOWN = -1;
    static final int REGISTER = 0;
    static final int REVOKE = 1;
    static final int RECOVER = 2;
    private static final SigningTransport signingTransport;
    static XMLResource xml;
    static final DOMOperations ops;
    static final Element xpathScope;
    private String requestUUID;
    Document request = null;
    XKMSAuthInfo ai = null;
    boolean returnPrivateKey = false;
    int request_type = -1;
    private String requestKeyName;
    private PublicKey requestKeyValue;
    static /* synthetic */ Class class$com$verisign$xkms$client$XKMSCommon;

    static Element addXKMSElement(Node parent, String localName) {
        return ops.appendElementByExpandedName(parent, "http://www.xkms.org/schema/xkms-2001-01-20", "k", localName);
    }

    static void setXKMSAttribute(Element parent, String localName, String value) {
        ops.setAttributeByExpandedName(parent, null, null, localName, value);
    }

    static PublicKey getResponseVerifyingKey(boolean productionKey) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, MissingResourceException {
        InputStream is;
        Class cls;
        Class clazz = cls = class$com$verisign$xkms$client$XKMSCommon == null ? (class$com$verisign$xkms$client$XKMSCommon = XKMSCommon.class$("com.verisign.xkms.client.XKMSCommon")) : class$com$verisign$xkms$client$XKMSCommon;
        if (productionKey) {
            is = cls.getResourceAsStream("trustpoint.prod");
        } else {
            is = cls.getResourceAsStream("trustpoint.pilot");
            if (is == null) {
                is = cls.getResourceAsStream("XKMSVerifyingKey.dat");
            }
        }
        if (is == null) {
            return null;
        }
        int pubkeySize = is.available();
        byte[] pubkeydata = new byte[pubkeySize];
        is.read(pubkeydata);
        is.close();
        X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(pubkeydata);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(pubKeySpec);
    }

    static void addRespondString(Document reqMsg, String stringVal) {
        Element respond = (Element)XPathAPI.evaluateToNode("//xkms:Respond", reqMsg, xpathScope);
        if (respond != null) {
            Element stringE = XKMSCommon.addXKMSElement(respond, "string");
            stringE.appendChild(reqMsg.createTextNode(stringVal));
        }
    }

    static void addRespondStrings(Node parent, String[] responses) {
        Element respond = XKMSCommon.addXKMSElement(parent, "Respond");
        int i = 0;
        while (i < responses.length) {
            Element string = XKMSCommon.addXKMSElement(respond, "string");
            string.appendChild(parent.getOwnerDocument().createTextNode(responses[i]));
            ++i;
        }
    }

    static Document signRequest(Document doc, KeyPair signingKey) throws XKMSIllegalArgumentException {
        return XKMSCommon.signingTransport.signRequest(doc, signingKey);
    }

    static void verifyTransactionID(Document verDoc, String requestUUID, String xpathToTransactionID) throws XKMSMalformedResponseException {
        String responseUUID = null;
        Element tidElem = (Element)XPathAPI.evaluateToNode(xpathToTransactionID, verDoc, xpathScope);
        if (tidElem != null) {
            responseUUID = ops.stringValueOfNode(tidElem);
        } else {
            String label;
            String text;
            int index;
            tidElem = (Element)XPathAPI.evaluateToNode("//xkms:ErrorDescription", verDoc, xpathScope);
            if (tidElem != null && (index = (text = ops.stringValueOfNode(tidElem)).indexOf(label = "TransactionID:")) >= 0) {
                if ((index = (text = text.substring(index + label.length()).trim()).indexOf(32)) > 0) {
                    text = text.substring(0, index);
                }
                responseUUID = text;
            }
        }
        if (responseUUID != null) {
            if (!responseUUID.equals(requestUUID)) {
                throw new XKMSMalformedResponseException("TransactionID of request (" + requestUUID + ") does not match response (" + responseUUID + ')', verDoc);
            }
        } else {
            throw new XKMSMalformedResponseException("TransactionID of request (" + requestUUID + ") is missing in response", verDoc);
        }
    }

    static String getStackTrace(Throwable e) {
        ByteArrayOutputStream buf = new ByteArrayOutputStream(500);
        PrintStream print = new PrintStream(buf, true);
        e.printStackTrace(print);
        print.flush();
        return buf.toString();
    }

    static boolean compareKeyNames(String keyName1, String keyName2) {
        try {
            if (keyName2 == null) {
                return false;
            }
            URL url1 = new URL(keyName1);
            URL url2 = new URL(keyName2);
            if (!(XKMSCommon.equals(url1.getProtocol(), url2.getProtocol()) && XKMSCommon.equals(url1.getHost(), url2.getHost()) && url1.getPort() == url2.getPort() && XKMSCommon.equals(url1.getPath(), url2.getPath()))) {
                return false;
            }
            HashMap map1 = XKMSCommon.getKeyNameFieldMap(url1);
            HashMap map2 = XKMSCommon.getKeyNameFieldMap(url2);
            Iterator i = map1.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                String val1 = (String)map1.get(key);
                String val2 = (String)map2.get(key);
                if (val1 == null || val2 == null || val1.equals(val2)) continue;
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    static boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    static HashMap getKeyNameFieldMap(URL url) {
        String str = url.getQuery();
        StringTokenizer tokens = new StringTokenizer(str, "&=");
        HashMap<String, String> map = new HashMap<String, String>();
        while (tokens.hasMoreTokens()) {
            String name = tokens.nextToken();
            if (!tokens.hasMoreTokens()) continue;
            String value = tokens.nextToken();
            if (name.equals("company")) {
                name = "corp_company";
            } else if (name.equals("department")) {
                name = "org_unit";
            }
            map.put(name, value);
        }
        return map;
    }

    XKMSCommon(int opcode, XKMSKeyData kdata, XKMSAuthInfo auth, XKMSProcessInfo procinfo, boolean storeKey) throws XKMSIllegalArgumentException, XKMSException {
        Document registerMsg = xml.createDocument();
        registerMsg.createProcessingInstruction("xml", "version=\"1.0\" encoding=\"UTF-8\"");
        this.ai = auth;
        this.request_type = opcode;
        this.requestKeyName = kdata.getKeyName();
        this.requestKeyValue = kdata.getPublicKey();
        Element top = XKMSCommon.addXKMSElement(registerMsg, "Register");
        Element keybinding = XKMSCommon.addXKMSElement(top, "Prototype");
        Element transID = XKMSCommon.addXKMSElement(keybinding, "TransactionID");
        Element status = XKMSCommon.addXKMSElement(keybinding, "Status");
        this.requestUUID = UUID.generate().toString();
        transID.appendChild(registerMsg.createTextNode(this.requestUUID));
        switch (opcode) {
            case 0: {
                this.returnPrivateKey = kdata.returningPrivateKey();
                status.appendChild(registerMsg.createTextNode("Valid"));
                break;
            }
            case 1: {
                status.appendChild(registerMsg.createTextNode("Invalid"));
                break;
            }
            case 2: {
                this.returnPrivateKey = true;
                status.appendChild(registerMsg.createTextNode("Indeterminate"));
                break;
            }
            default: {
                throw new IllegalArgumentException("internal error");
            }
        }
        String id = keybinding.getAttributeNS(null, "Id");
        if (id == null || id.length() == 0) {
            ops.setAttributeByExpandedName(keybinding, null, null, "Id", "refId_1");
        }
        XKeyInfo xki = kdata.getKeyInfo(registerMsg);
        keybinding.appendChild(xki.getElement());
        auth.setPassPhraseXML(registerMsg, keybinding, opcode == 0);
        if (storeKey) {
            EncryptedKey encryptedKey = new EncryptedKey(kdata.getPrivateKey());
            encryptedKey.setAuth(this.ai.getSharedSecret());
            try {
                encryptedKey.encrypt();
            }
            catch (InitializationException ie) {
                throw new XKMSIllegalArgumentException("Could not encrypt private key", ie.getXML(), ie);
            }
            Document toAdd = encryptedKey.getXML();
            XMLResource xml = ResourceFactory.getXMLResource();
            Node n = xml.cloneWithOwner(registerMsg, toAdd.getDocumentElement(), true);
            Element prvate = XKMSCommon.addXKMSElement(keybinding, "Private");
            String VERSION_TAG = "version";
            String VERSION = "1";
            prvate.setAttributeNS(null, VERSION_TAG, VERSION);
            prvate.appendChild(n);
        }
        Element auth1 = XKMSCommon.addXKMSElement(top, "AuthInfo");
        Element rsaauth = null;
        if (kdata.returningPrivateKey()) {
            rsaauth = XKMSCommon.addXKMSElement(auth1, opcode == 0 ? "AuthServerInfo" : "AuthUserInfo");
        } else {
            rsaauth = XKMSCommon.addXKMSElement(auth1, "AuthUserInfo");
            auth.setProofOfPossession(xml, registerMsg, rsaauth, keybinding, procinfo, kdata.getSpkiData(), kdata);
        }
        if (auth != null) {
            auth.setSharedSecretXML(xml, registerMsg, rsaauth, keybinding);
        }
        Element respond = XKMSCommon.addXKMSElement(top, "Respond");
        Element str1 = XKMSCommon.addXKMSElement(respond, "string");
        str1.appendChild(registerMsg.createTextNode("KeyName"));
        Element str2 = XKMSCommon.addXKMSElement(respond, "string");
        str2.appendChild(registerMsg.createTextNode("KeyValue"));
        if (this.returnPrivateKey) {
            Element str3 = XKMSCommon.addXKMSElement(respond, "string");
            str3.appendChild(registerMsg.createTextNode("Private"));
        }
        this.request = registerMsg;
    }

    XmlResponse parseResults(XmlRequest req, Document regresult) throws XKMSMalformedResponseException, XKMSIllegalArgumentException, XKMSServiceFailureException, XKMSSignatureVerificationException {
        XKMSCommon.verifyTransactionID(regresult, this.requestUUID, "/xkms:RegisterResult/xkms:Answer/xkms:KeyBinding/xkms:TransactionID");
        String mal = "Malformed response: ";
        String auth = this.ai.getSharedSecret();
        boolean ok = true;
        Element result = null;
        String text = null;
        if (regresult == null) {
            ok = false;
        } else {
            Element xgateresult = regresult.getDocumentElement();
            result = ops.firstElementChild(xgateresult);
            if (result == null || !"Result".equals(ops.getLocalName(result))) {
                throw new XKMSMalformedResponseException(mal + "No Result element from registration server", regresult);
            }
            text = ops.stringValueOfNode(result);
        }
        if (!ok || !"Success".equalsIgnoreCase(text)) {
            AbstractResponse resp = null;
            switch (this.request_type) {
                case 0: {
                    resp = new XKMSRegisterResponse(req, false, regresult, null, null);
                    break;
                }
                case 1: {
                    resp = new XKMSRevokeResponse(req, false, regresult);
                    break;
                }
                case 2: {
                    resp = new XKMSRecoverResponse(req, false, regresult, null, null);
                    break;
                }
            }
            return resp;
        }
        String keyName = null;
        PrivateKey privateKey = null;
        RSAPublicKey publicKey = null;
        XKeyInfo kinfo = null;
        result = (Element)XPathAPI.evaluateToNode("//dsig:KeyInfo", regresult, xpathScope);
        if (result == null) {
            throw new XKMSMalformedResponseException(mal + "not exactly one KeyInfo element", regresult);
        }
        try {
            kinfo = new XKeyInfo(result);
            keyName = kinfo.getKeyName();
            XRSAKeyValue rsa = (XRSAKeyValue)kinfo.getKeyValue();
            if (keyName == null || rsa == null) {
                throw new XKMSMalformedResponseException(mal + "missing KeyName or KeyValue element", regresult);
            }
            publicKey = rsa.getAsRSAPublicKey();
            if (this.requestKeyName != null && !XKMSCommon.compareKeyNames(this.requestKeyName, keyName) && this.request_type != 0) {
                throw new XKMSMalformedResponseException("request key name (" + this.requestKeyName + ") response key name (" + keyName + ')', regresult);
            }
            if (!(this.requestKeyValue == null || publicKey != null && Arrays.equals(this.requestKeyValue.getEncoded(), publicKey.getEncoded()))) {
                throw new XKMSMalformedResponseException("request key value (" + this.requestKeyValue + ") response key value (" + publicKey + ')', regresult);
            }
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new XKMSIllegalArgumentException(nsae);
        }
        catch (InvalidKeySpecException ikse) {
            throw new XKMSIllegalArgumentException(ikse);
        }
        Object nl = null;
        if (this.returnPrivateKey) {
            try {
                EncryptedKey encryptedKey = EncryptedKey.fromDOM(regresult);
                if (encryptedKey == null) {
                    throw new XKMSMalformedResponseException(mal + "not exactly one EncryptedKey element", regresult);
                }
                encryptedKey.setAuth(auth);
                encryptedKey.decrypt();
                privateKey = encryptedKey.getPrivateKey();
            }
            catch (Exception e) {
                throw new XKMSMalformedResponseException(e, regresult);
            }
        }
        AbstractResponse resp = null;
        switch (this.request_type) {
            case 0: {
                resp = new XKMSRegisterResponse(req, ok, regresult, privateKey, kinfo);
                break;
            }
            case 1: {
                resp = new XKMSRevokeResponse(req, ok, regresult);
                break;
            }
            case 2: {
                resp = new XKMSRecoverResponse(req, ok, regresult, privateKey, keyName);
                break;
            }
        }
        return resp;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        UNKNOWN = -1;
        REGISTER = 0;
        REVOKE = 1;
        RECOVER = 2;
        signingTransport = new SigningTransport();
        xml = ResourceFactory.getXMLResource();
        ops = DOMOperations.getInstance();
        xpathScope = ops.appendElementByExpandedName(xml.createDocument(), null, null, "x");
        ops.setNamespace(xpathScope, "xkms", "http://www.xkms.org/schema/xkms-2001-01-20");
        ops.setNamespace(xpathScope, "dsig", "http://www.w3.org/2000/09/xmldsig#");
    }

    private static class SigningTransport
    extends AbstractTransport {
        private SigningTransport() {
            super(null);
        }

        private Document signRequest(Document doc, KeyPair signingKey) throws XKMSIllegalArgumentException {
            try {
                MessageProvider provider = XKMSProvider.getDefaultProvider();
                return this.signRequestBody(doc, signingKey.getPrivate(), signingKey.getPublic(), null, provider.getRequestSignatureLocation(doc), provider.getRequestSignatureInsertBefore(doc));
            }
            catch (XmlMessageException e) {
                Throwable cause = e.getCause();
                if (cause == null) {
                    cause = e;
                }
                throw new XKMSIllegalArgumentException(e);
            }
        }
    }
}

