/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xkms.client;

import com.verisign.datatypes.Base64;
import com.verisign.definitions.XKMSDefinitions;
import com.verisign.domutil.DOMCursor;
import com.verisign.domutil.DOMWriteCursor;
import com.verisign.resource.XMLResource;
import com.verisign.xkms.client.XKMSCommon;
import com.verisign.xkms.client.XKMSIllegalArgumentException;
import com.verisign.xkms.client.XKMSKeyData;
import com.verisign.xkms.client.XKMSProcessInfo;
import com.verisign.xmlsig.HMACKey;
import com.verisign.xmlsig.RSAVerifyingKey;
import com.verisign.xmlsig.Signer;
import com.verisign.xpath.XPath;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.text.StringCharacterIterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XKMSAuthInfo {
    public static final int KEYPAIR_SIGNATURE = 1;
    public static final int PASSPHRASE_SIGNATURE = 2;
    public static final int CLEARTEXT_PASSPHRASE = 3;
    int type;
    PublicKey pubKey;
    PrivateKey privKey;
    X509Certificate cert;
    String secret = null;
    String phrase = null;

    public XKMSAuthInfo(String revocationPassPhrase, String sharedSecret, int type, KeyPair kp) {
        this.secret = sharedSecret;
        this.phrase = revocationPassPhrase;
        if (kp != null) {
            this.pubKey = kp.getPublic();
            this.privKey = kp.getPrivate();
        }
        this.type = type;
        this.processSharedSecret();
    }

    public XKMSAuthInfo(String revocationPassPhrase, String sharedSecret) {
        this.secret = sharedSecret;
        this.phrase = revocationPassPhrase;
        this.type = 2;
        this.processSharedSecret();
    }

    public XKMSAuthInfo(String revocationPassPhrase, X509Certificate cert, PrivateKey privateKey) {
        this.pubKey = cert.getPublicKey();
        this.privKey = privateKey;
        this.cert = cert;
        this.phrase = revocationPassPhrase;
        this.type = 1;
    }

    XKMSAuthInfo(String revocationPassPhrase) {
        this.phrase = revocationPassPhrase;
    }

    public String getSharedSecret() {
        return this.secret;
    }

    private void processSharedSecret() {
        StringBuffer sb = new StringBuffer();
        StringCharacterIterator si = new StringCharacterIterator(this.secret.trim().toLowerCase());
        char c = si.first();
        while (c != '\uffff') {
            if (!Character.isWhitespace(c) && !Character.isISOControl(c)) {
                sb.append(c);
            }
            c = si.next();
        }
        this.secret = sb.toString();
    }

    private byte[] getUTF(String val) throws XKMSIllegalArgumentException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeUTF(val);
        }
        catch (IOException shouldNeverHappen) {
            // empty catch block
        }
        byte[] val1 = baos.toByteArray();
        byte[] val2 = new byte[val1.length - 2];
        System.arraycopy(val1, 2, val2, 0, val2.length);
        return val2;
    }

    void setPassPhraseXML(Document doc, Element el, boolean doRegister) throws XKMSIllegalArgumentException {
        if (this.phrase != null) {
            byte[] macresults;
            Element passphrase = XKMSCommon.addXKMSElement(el, "PassPhrase");
            HMACKey hmacKey = new HMACKey(XKMSDefinitions.PASS_NORMALIZE_HMAC_KEY);
            try {
                macresults = hmacKey.signData(this.getUTF(this.phrase));
            }
            catch (Exception e) {
                throw new XKMSIllegalArgumentException(e);
            }
            if (doRegister) {
                hmacKey = new HMACKey(XKMSDefinitions.PASS_REGISTER_HMAC_KEY);
                try {
                    macresults = hmacKey.signData(macresults);
                }
                catch (Exception e) {
                    throw new XKMSIllegalArgumentException(e);
                }
            }
            passphrase.appendChild(doc.createTextNode(Base64.encode(macresults)));
        }
    }

    void setSharedSecretXML(XMLResource xml, Document doc, Element el, Element keybinding) throws XKMSIllegalArgumentException {
        switch (this.type) {
            case 1: {
                try {
                    Element kbauth = XKMSCommon.addXKMSElement(el, "KeyBindingAuth");
                    Signer signer = this.cert != null ? new Signer(doc, this.privKey, this.cert) : new Signer(doc, this.privKey, this.pubKey);
                    this.signKeyBinding(kbauth, keybinding, signer);
                    break;
                }
                catch (Exception e) {
                    throw new XKMSIllegalArgumentException(e);
                }
            }
            case 2: {
                try {
                    HMACKey hmacKey = new HMACKey(XKMSDefinitions.AUTH_HMAC_KEY);
                    hmacKey = new HMACKey(hmacKey.signData(this.getUTF(this.secret)));
                    Element kbauth = XKMSCommon.addXKMSElement(el, "KeyBindingAuth");
                    Signer signer = new Signer(doc, hmacKey);
                    this.signKeyBinding(kbauth, keybinding, signer);
                    break;
                }
                catch (Exception e) {
                    throw new XKMSIllegalArgumentException(e);
                }
            }
            case 3: {
                Element pass = XKMSCommon.addXKMSElement(el, "PassPhraseAuth");
                pass.appendChild(doc.createTextNode(this.phrase));
                break;
            }
        }
    }

    private void signKeyBinding(Element kbauth, Element keybinding, Signer signer) throws Exception {
        signer.addReference(new XPath("//*[@Id='" + keybinding.getAttribute("Id") + "']"));
        DOMWriteCursor kbauthCursor = new DOMWriteCursor(kbauth);
        XPath kbauthXPath = kbauthCursor.createXPath();
        DOMCursor signedDoc = new DOMCursor(signer.sign(kbauthXPath));
        signedDoc.moveToXPath(kbauthXPath);
        kbauthCursor.copyOver(signedDoc);
    }

    void setProofOfPossession(XMLResource xml, Document doc, Element el, Element keybinding, XKMSProcessInfo pi, byte[] spkidata, XKMSKeyData xkd) throws XKMSIllegalArgumentException {
        try {
            Element proof = XKMSCommon.addXKMSElement(el, "ProofOfPossession");
            Signer signer = new Signer(doc, xkd.getSigningKey(), new RSAVerifyingKey(xkd.getPublicKey()));
            signer.addReference(new XPath("//*[@Id='" + keybinding.getAttribute("Id") + "']"));
            DOMWriteCursor proofCursor = new DOMWriteCursor(proof);
            XPath proofXPath = proofCursor.createXPath();
            DOMCursor signedDoc = new DOMCursor(signer.sign(proofXPath));
            signedDoc.moveToXPath(proofXPath);
            proofCursor.copyOver(signedDoc);
        }
        catch (Exception e) {
            throw new XKMSIllegalArgumentException(e);
        }
    }

    static {
        KEYPAIR_SIGNATURE = 1;
        PASSPHRASE_SIGNATURE = 2;
        CLEARTEXT_PASSPHRASE = 3;
    }
}

