/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xkms.client;

import com.verisign.xkms.client.XKMSIllegalArgumentException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import sun.security.util.DerOutputStream;
import sun.security.x509.X500Name;

public class CertificateToKeyName {
    static String certToKeyName(X509Certificate cert) throws XKMSIllegalArgumentException {
        StringBuffer buf = new StringBuffer("http://xkms.verisign.com/key");
        String issuerSerial = CertificateToKeyName.getIssuerSerial(cert);
        if (issuerSerial != null) {
            buf.append("?issuer_serial=");
            buf.append(issuerSerial);
        } else {
            BigInteger serialNumber = cert.getSerialNumber();
            if (serialNumber == null) {
                throw new XKMSIllegalArgumentException("Cert has no serial number");
            }
            Principal subjectDN = cert.getSubjectDN();
            if (subjectDN == null || subjectDN.getName() == null) {
                throw new XKMSIllegalArgumentException("Cert has no subject DN");
            }
            String[] dn = CertificateToKeyName.parseDN(subjectDN.getName());
            String o = CertificateToKeyName.getDNValue(dn, "O");
            if (o == null) {
                throw new XKMSIllegalArgumentException("Cert DN has no org (O)");
            }
            String cn = CertificateToKeyName.getDNValue(dn, "CN");
            String email = CertificateToKeyName.getDNValue(dn, "EmailAddress");
            buf.append("?cert_serial=");
            buf.append(serialNumber.toString(16));
            buf.append("&corp_company=");
            buf.append(o);
            if (cn != null) {
                cn = cn.toUpperCase();
                buf.append("&CN=");
                buf.append(cn);
            }
            if (email != null) {
                buf.append("&mail_email=");
                buf.append(email);
            }
        }
        return buf.toString();
    }

    static String getIssuerSerial(X509Certificate cert) {
        BigInteger serialNumber = cert.getSerialNumber();
        Principal issuerDN = cert.getIssuerDN();
        if (serialNumber == null || issuerDN == null) {
            return null;
        }
        if (!issuerDN.getClass().getName().equals("sun.security.x509.X500Name")) {
            return null;
        }
        try {
            X500Name issuerDNImpl = (X500Name)issuerDN;
            DerOutputStream issuerDNDer = new DerOutputStream();
            issuerDNImpl.emit(issuerDNDer);
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(issuerDNDer.toByteArray());
            byte[] byteResult = md5.digest(serialNumber.toByteArray());
            String strResult = new BigInteger(1, byteResult).toString(16);
            if (strResult.length() < 32) {
                StringBuffer buf = new StringBuffer(32);
                int paddingLen = 32 - strResult.length();
                int i = 0;
                while (i < paddingLen) {
                    buf.append('0');
                    ++i;
                }
                buf.append(strResult);
                strResult = buf.toString();
            }
            return strResult;
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static String getDNValue(String[] dn, String name) {
        int i = 0;
        while (i < dn.length) {
            if (dn[i].equals(name)) {
                return dn[i + 1];
            }
            i += 2;
        }
        return null;
    }

    private static String[] parseDN(String dn) throws XKMSIllegalArgumentException {
        StringBuffer name = new StringBuffer();
        StringBuffer value = new StringBuffer();
        ArrayList<String> list = new ArrayList<String>();
        char[] chars = dn.toCharArray();
        int i = 0;
        while (i < chars.length) {
            i = CertificateToKeyName.parseDNName(chars, i, name);
            i = CertificateToKeyName.parseDNValue(chars, i, value);
            list.add(name.toString());
            list.add(value.toString());
        }
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }

    private static int parseDNName(char[] chars, int i, StringBuffer buf) throws XKMSIllegalArgumentException {
        buf.setLength(0);
        while (i < chars.length && chars[i] != '=') {
            buf.append(chars[i]);
            ++i;
        }
        if (i >= chars.length) {
            throw new XKMSIllegalArgumentException("No = following DN name DN=" + new String(chars) + " offset=" + i);
        }
        if (buf.length() == 0) {
            throw new XKMSIllegalArgumentException("Empty DN name DN=" + new String(chars) + " offset=" + i);
        }
        return i + 1;
    }

    /*
     * Unable to fully structure code
     */
    private static int parseDNValue(char[] chars, int i, StringBuffer buf) throws XKMSIllegalArgumentException {
        buf.setLength(0);
        quoted = false;
        if (i < chars.length && chars[i] == '\"') {
            quoted = true;
            ++i;
        }
        while (i < chars.length && (quoted == false ? chars[i] != ',' : chars[i] != '\"')) {
            buf.append(chars[i]);
            ++i;
        }
        if (quoted) {
            if (i >= chars.length || chars[i] != '\"') {
                throw new XKMSIllegalArgumentException("DN missing end quote DN=" + new String(chars) + " offset=" + i);
            }
            ++i;
        }
        if (buf.length() != 0) ** GOTO lbl18
        throw new XKMSIllegalArgumentException("Empty DN name DN=" + new String(chars) + " offset=" + i);
lbl-1000:
        // 1 sources

        {
            ++i;
lbl18:
            // 2 sources

            ** while (i < chars.length && (chars[i] == ',' || chars[i] == ' '))
        }
lbl19:
        // 1 sources

        return i;
    }
}

