/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.xenc;

import com.nanobiz.xpath.XPathAPI;
import com.verisign.digsig.encode.EncodingHelper;
import com.verisign.digsig.encode.UtfDataOutputStream;
import com.verisign.digsig.keys.XKeyInfo;
import com.verisign.digsig.keys.XRSAKeyValue;
import com.verisign.digsig.ops.X3DES;
import com.verisign.digsig.ops.XHMAC_SHA1;
import com.verisign.digsig.ops.XMac;
import com.verisign.digsig.ops.XSymmetric;
import com.verisign.resource.DOMOperations;
import com.verisign.resource.ResourceFactory;
import com.verisign.resource.XMLResource;
import com.verisign.xenc.Definitions;
import com.verisign.xenc.InitializationException;
import com.verisign.xenc.MalformedElementException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.interfaces.RSAKey;
import java.security.spec.InvalidKeySpecException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class EncryptedKey {
    static XMLResource xml = ResourceFactory.getXMLResource();
    static final DOMOperations ops = DOMOperations.getInstance();
    static final Element xpathScope = ops.appendElementByExpandedName(xml.createDocument(), null, null, "x");
    private PrivateKey privateKey = null;
    private String keyInfoBase64 = null;
    private XKeyInfo keyInfo = null;
    private String auth = null;

    static Element addElement(Node parent, String localName) {
        return ops.appendElementByExpandedName(parent, "http://www.w3.org/2001/04/xmlenc#", "xenc", localName);
    }

    private EncryptedKey() {
    }

    public EncryptedKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    private void setCipherText(String cipherText) {
        this.keyInfoBase64 = cipherText;
    }

    public static EncryptedKey fromDOM(Document doc) throws MalformedElementException {
        NodeList nl = (NodeList)XPathAPI.evaluate(".//xenc:EncryptedKey", doc, xpathScope);
        if (nl.getLength() != 1) {
            throw new MalformedElementException("Missing <EncryptedKey> element", doc);
        }
        Element result = (Element)nl.item(0);
        if ((nl = (NodeList)XPathAPI.evaluate(".//xenc:CipherData", result, xpathScope)).getLength() != 1) {
            throw new MalformedElementException("Missing <EncryptedKey:CipherData> element", doc);
        }
        result = (Element)nl.item(0);
        Node text = result.getFirstChild();
        if (text.getNodeType() != 3) {
            throw new MalformedElementException("<EncryptedKey:CipherData> does not contain text", doc);
        }
        EncryptedKey key = new EncryptedKey();
        key.setCipherText(text.getNodeValue());
        return key;
    }

    public void setAuth(String auth) {
        this.auth = auth;
    }

    public void encrypt() throws InitializationException {
        if (this.auth == null) {
            throw new InitializationException("No authentication key set");
        }
        XMLResource xml = ResourceFactory.getXMLResource();
        Document document = xml.createDocument();
        XRSAKeyValue xki = new XRSAKeyValue(document);
        xki.setRSAKey((RSAKey)((Object)this.privateKey));
        XKeyInfo kinfo = new XKeyInfo(document);
        kinfo.setKeyName("No keyname here");
        kinfo.setKeyValue(xki);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.publishXMLDocument(kinfo.getElement(), baos);
        }
        catch (IOException e) {
            throw new InitializationException("Failed unrolling XKeyInfo");
        }
        String plainText = baos.toString();
        XHMAC_SHA1 macAlg = new XHMAC_SHA1();
        byte[] utf = this.getUTF(this.auth);
        if (utf == null) {
            throw new InitializationException("Bad authentication key");
        }
        byte[] desKey = ((XMac)macAlg).getMac(utf, Definitions.PRIVATE_HMAC_KEY);
        X3DES desAlg = new X3DES();
        byte[] encrypted = ((XSymmetric)desAlg).encrypt(plainText.getBytes(), desKey);
        this.keyInfoBase64 = EncodingHelper.encode(encrypted, 1);
    }

    private void publishXMLDocument(Element element, OutputStream out) throws IOException {
        XMLResource xml = ResourceFactory.getXMLResource();
        xml.publish((Node)element, out, 1);
    }

    public Document getXML() {
        XMLResource xml = ResourceFactory.getXMLResource();
        Document document = xml.createDocument();
        Element encKeyElem = EncryptedKey.addElement(document, "EncryptedKey");
        Element cipherTextElem = EncryptedKey.addElement(encKeyElem, "CipherData");
        Text b64 = document.createTextNode(this.keyInfoBase64);
        cipherTextElem.appendChild(b64);
        return document;
    }

    public void decrypt() throws InitializationException {
        if (this.keyInfoBase64 == null) {
            throw new InitializationException("Nothing to decrypt");
        }
        if (this.auth == null) {
            throw new InitializationException("No authentication key set");
        }
        byte[] decoded = EncodingHelper.decode(this.keyInfoBase64, 1);
        XHMAC_SHA1 macAlg = new XHMAC_SHA1();
        byte[] utf = this.getUTF(this.auth);
        if (utf == null) {
            throw new InitializationException("Bad authentication key");
        }
        byte[] desKey = ((XMac)macAlg).getMac(utf, Definitions.PRIVATE_HMAC_KEY);
        X3DES desAlg = new X3DES();
        byte[] decrypted = ((XSymmetric)desAlg).decrypt(decoded, desKey);
        String keyInfoAsString = new String(decrypted);
        XMLResource xml = ResourceFactory.getXMLResource();
        try {
            Document keyDoc = xml.parseXML(new StringReader(keyInfoAsString.trim()));
            this.keyInfo = new XKeyInfo(keyDoc.getDocumentElement());
        }
        catch (IOException e) {
            throw new InitializationException("Could not parse");
        }
    }

    public PrivateKey getPrivateKey() throws InitializationException {
        if (this.keyInfo == null) {
            throw new InitializationException("No private key decrypted", null);
        }
        XRSAKeyValue rsa = (XRSAKeyValue)this.keyInfo.getKeyValue();
        try {
            return rsa.getAsRSAPrivateKey();
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new InitializationException(nsae.toString());
        }
        catch (InvalidKeySpecException ikse) {
            throw new InitializationException(ikse.toString());
        }
    }

    private byte[] getUTF(String val) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        UtfDataOutputStream dos = new UtfDataOutputStream(baos);
        try {
            dos.writeUTFOnly(val);
        }
        catch (IOException ioe) {
            return null;
        }
        return baos.toByteArray();
    }

    static {
        ops.setNamespace(xpathScope, "xenc", "http://www.w3.org/2001/04/xmlenc#");
        ops.setNamespace(xpathScope, "xkms", "http://www.xkms.org/schema/xkms-2001-01-20");
        ops.setNamespace(xpathScope, "dsig", "http://www.w3.org/2000/09/xmldsig#");
    }
}

