/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.uuid;

import com.verisign.uuid.UUID;
import com.verisign.uuid.UUIDGenerator;
import com.verisign.uuid.UUIDRandomness;

public class UnsynchronizedTimestampUUIDGenerator
implements UUIDGenerator {
    public static final long EPOCH_OFFSET = 12219292800000L;
    public static final long CLOCK_RES = 10000L;
    protected long last_time;
    protected long clock_adj;
    protected int clock_sequence;
    protected byte[] node;

    public UnsynchronizedTimestampUUIDGenerator(int clock_sequence, byte[] node) {
        if (clock_sequence < 0 || clock_sequence >= 16384) {
            throw new IllegalArgumentException();
        }
        if (node == null) {
            throw new NullPointerException();
        }
        if (node.length != 6) {
            throw new IllegalArgumentException();
        }
        this.clock_sequence = clock_sequence;
        this.node = (byte[])node.clone();
        this.checkSystemTime();
    }

    protected void checkSystemTime() {
        long sys_time = System.currentTimeMillis();
        if (sys_time < this.last_time) {
            this.clock_sequence = UUIDRandomness.nextRandomClockSequence(this.clock_sequence);
        }
        if (sys_time != this.last_time) {
            this.last_time = sys_time;
            this.clock_adj = 0L;
        }
    }

    protected void adjustmentOverflow() throws IllegalStateException {
        this.checkSystemTime();
        if (this.clock_adj >= 10000L) {
            throw new IllegalStateException();
        }
    }

    public UUID nextUUID() {
        long unique_time = (this.last_time + 12219292800000L) * 10000L + this.clock_adj;
        if (++this.clock_adj > 10000L) {
            this.adjustmentOverflow();
        }
        return new UUID((int)(unique_time & 0xFFFFFFFFFFFFFFFFL), (short)(unique_time >> 32 & 0xFFFFL), (short)(unique_time >> 48 & 0xFFFL | 0x1000L), (byte)(this.clock_sequence & 0xFF), (byte)(this.clock_sequence >> 8 & 0x3F | 0x80), this.node);
    }

    static {
        EPOCH_OFFSET = 12219292800000L;
        CLOCK_RES = 10000L;
    }
}

