/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.util.failover;

import com.verisign.util.failover.FailoverCapable;
import com.verisign.util.failover.FailoverException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Observable;
import java.util.TreeMap;
import java.util.Vector;

public class FailoverManager
extends Observable {
    private Vector failoverlist = new Vector();
    private long retry = 0L;
    private TreeMap outofrotation = new TreeMap();
    private long nextcheck = 0L;
    private long active = 0L;
    private Vector nonReentrant;
    private String title;

    public FailoverManager(String title, long retryInterval) {
        this.retry = retryInterval;
        this.nextcheck = 0L;
        this.nonReentrant = new Vector();
        this.title = title;
    }

    public void setRetryInterval(long retry) {
        this.retry = retry;
    }

    public long getRetryInterval() {
        return this.retry;
    }

    public String getTitle() {
        return this.title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(FailoverCapable fc) {
        boolean rval = false;
        FailoverManager failoverManager = this;
        synchronized (failoverManager) {
            if (!(this.failoverlist.contains(fc) || this.outofrotation.containsValue(fc) || this.nonReentrant.contains(fc))) {
                this.failoverlist.add(fc);
                ++this.active;
                rval = true;
            }
        }
        if (rval) {
            fc.notifyFailure(this, 3);
        }
        return rval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean remove(FailoverCapable fc) {
        boolean rval = false;
        FailoverManager failoverManager = this;
        // MONITORENTER : failoverManager
        if (this.failoverlist.contains(fc)) {
            this.failoverlist.remove(fc);
            --this.active;
            rval = true;
            // MONITOREXIT : failoverManager
        } else {
            Iterator i = this.outofrotation.keySet().iterator();
            while (i.hasNext()) {
                Long key = (Long)i.next();
                if (this.outofrotation.get(key) != fc) continue;
                if (this.nextcheck == 0L) {
                    this.nextcheck = key;
                } else if (key == this.nextcheck) {
                    this.nextcheck = 0L;
                }
                i.remove();
                rval = false;
                break;
            }
            if (this.nonReentrant.contains(fc)) {
                this.nonReentrant.remove(fc);
                --this.active;
                rval = true;
                // MONITOREXIT : failoverManager
            }
        }
        if (!rval) return rval;
        fc.notifyFailure(this, 4);
        return rval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void failed(FailoverCapable fc) {
        Long l = new Long(System.currentTimeMillis() + this.retry);
        fc.notifyFailure(this, 2);
        FailoverManager failoverManager = this;
        synchronized (failoverManager) {
            this.failoverlist.remove(fc);
            this.outofrotation.put(l, fc);
            if (this.nextcheck == 0L) {
                this.nextcheck = l;
            }
            --this.active;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkRotation() {
        if (this.nextcheck != 0L) {
            FailoverManager failoverManager = this;
            synchronized (failoverManager) {
                if (this.nextcheck != 0L && System.currentTimeMillis() >= this.nextcheck) {
                    Long lval;
                    try {
                        lval = (Long)this.outofrotation.firstKey();
                    }
                    catch (NoSuchElementException nsee) {
                        lval = null;
                    }
                    FailoverCapable fc = (FailoverCapable)this.outofrotation.get(lval);
                    fc.notifyFailure(this, 1);
                    this.failoverlist.add(fc);
                    ++this.active;
                    this.outofrotation.remove(lval);
                    try {
                        lval = (Long)this.outofrotation.firstKey();
                    }
                    catch (NoSuchElementException nsee) {
                        lval = null;
                    }
                    this.nextcheck = lval != null ? lval : 0L;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FailoverCapable getNext(List triedList) throws Exception {
        FailoverCapable fc = null;
        this.checkRotation();
        while (true) {
            FailoverManager failoverManager = this;
            synchronized (failoverManager) {
                if (this.failoverlist.size() == 0) {
                    if (this.active == 0L) {
                        throw new FailoverException("No FailoverCapable objects being managed");
                    }
                } else {
                    fc = (FailoverCapable)this.failoverlist.get(0);
                    if (fc != null) {
                        if (triedList.contains(fc)) {
                            throw new FailoverException("All FailoverCapable Objects Failed");
                        }
                        triedList.add(fc);
                        this.failoverlist.remove(0);
                        if (!fc.isReentrant()) {
                            this.nonReentrant.add(fc);
                        } else {
                            this.failoverlist.add(fc);
                        }
                    }
                }
            }
            if (fc != null) break;
            this.setChanged();
            this.notifyObservers("Active list empty");
            Vector vector = this.failoverlist;
            synchronized (vector) {
                try {
                    this.failoverlist.wait();
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
        }
        return fc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object perform(Object arg) throws Exception {
        Object rval = null;
        Exception ex = null;
        ArrayList triedList = new ArrayList();
        while (rval == null && ex == null) {
            FailoverCapable fc = this.getNext(triedList);
            try {
                rval = fc.perform(arg);
            }
            catch (Exception e) {
                rval = null;
                ex = e;
            }
            if (rval == null) {
                this.failed(fc);
                continue;
            }
            if (fc.isReentrant()) continue;
            FailoverManager failoverManager = this;
            synchronized (failoverManager) {
                if (this.nonReentrant.contains(fc)) {
                    this.nonReentrant.remove(fc);
                    this.failoverlist.add(fc);
                    Vector vector = this.failoverlist;
                    synchronized (vector) {
                        this.failoverlist.notifyAll();
                    }
                }
            }
        }
        if (ex != null) {
            throw ex;
        }
        return rval;
    }

    public String toString() {
        return "Failover Manager '" + this.title + "' [Retry " + this.retry / 1000L + " seconds]";
    }
}

