/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MaxLengthInputStream
extends FilterInputStream {
    private int maxLen;
    private boolean allowExplicitClose;

    public MaxLengthInputStream(InputStream stream, int maxLen, boolean allowExplicitClose) {
        super(stream);
        this.maxLen = maxLen;
        this.allowExplicitClose = allowExplicitClose;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.maxLen <= 0) {
            return -1;
        }
        int n = this.in.read(b, off, len = Math.min(len, this.maxLen));
        if (n < 0) {
            throw this.unexpectedEOF();
        }
        this.maxLen -= n;
        return n;
    }

    public int read() throws IOException {
        if (this.maxLen <= 0) {
            return -1;
        }
        int val = this.in.read();
        if (val < 0) {
            throw this.unexpectedEOF();
        }
        --this.maxLen;
        return val;
    }

    public long skip(long count) throws IOException {
        if ((count = Math.min(count, (long)this.maxLen)) > 0L) {
            int n = (int)this.in.skip(count);
            if (n < 0) {
                throw this.unexpectedEOF();
            }
            this.maxLen -= n;
            return n;
        }
        return 0L;
    }

    public void close() throws IOException {
        if (this.allowExplicitClose) {
            super.close();
        }
    }

    private IOException unexpectedEOF() {
        return new IOException("MaxLengthInputStream should have " + this.maxLen + " bytes remaining but underlying stream returned EOF");
    }
}

