/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class BufferStream {
    private static int DEFAULT_INIT_COUNT = 512;
    private byte[] singleBuffer;
    private int singleBufferOffset;
    private int totalLength;
    private List buffers;
    private DataOutputStream dataOutput;
    private ByteArrayOutputStream dataOutputBuffer;
    private boolean closed;

    public BufferStream() {
        this(DEFAULT_INIT_COUNT);
    }

    public BufferStream(int initCount) {
        this.buffers = new ArrayList(initCount);
    }

    public BufferStream(byte[] buffer) {
        this(buffer, 0, buffer.length);
    }

    public BufferStream(byte[] buffer, int offset, int length) {
        this();
        if (length > 0) {
            this.singleBuffer = buffer;
            this.singleBufferOffset = offset;
            this.totalLength = length;
        }
    }

    public void add(byte[] buffer) throws IllegalStateException {
        this.add(buffer, 0, buffer.length);
    }

    public void add(byte[] buffer, int offset, int length) throws IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("Content is closed");
        }
        if (length == 0) {
            return;
        }
        this.flushSingleBuffer();
        this.buffers.add(new Buffer(buffer, offset, length));
        this.totalLength += length;
    }

    public void add(String string) throws IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("Content is closed");
        }
        int length = string.length();
        if (length == 0) {
            return;
        }
        this.flushSingleBuffer();
        if (this.dataOutput == null) {
            this.dataOutputBuffer = new ByteArrayOutputStream(length * 3);
            this.dataOutput = new DataOutputStream(this.dataOutputBuffer);
        } else {
            this.dataOutputBuffer.reset();
        }
        try {
            this.dataOutput.writeUTF(string);
        }
        catch (IOException ignored) {
            // empty catch block
        }
        byte[] buffer = this.dataOutputBuffer.toByteArray();
        length = buffer.length - 2;
        this.buffers.add(new Buffer(buffer, 2, length));
        this.totalLength += length;
    }

    public void add(char[] chars, int offset, int length) throws IllegalStateException {
        this.add(new String(chars, offset, length));
    }

    private void flushSingleBuffer() {
        if (this.singleBuffer != null) {
            this.buffers.add(new Buffer(this.singleBuffer, this.singleBufferOffset, this.totalLength));
            this.singleBuffer = null;
        }
    }

    public void close() throws IllegalStateException {
        this.closed = true;
    }

    public int getLength() {
        if (!this.closed) {
            throw new IllegalStateException("Content is incomplete");
        }
        return this.totalLength;
    }

    public InputStream getStream() throws IllegalStateException {
        if (!this.closed) {
            throw new IllegalStateException("Content is incomplete");
        }
        if (this.singleBuffer != null) {
            return new ByteArrayInputStream(this.singleBuffer, this.singleBufferOffset, this.totalLength);
        }
        return new BufferInputStream(this.buffers);
    }

    public byte[] getByteArray() {
        if (!this.closed) {
            throw new IllegalStateException("Content is incomplete");
        }
        if (this.singleBuffer != null) {
            if (this.singleBufferOffset == 0 && this.singleBuffer.length == this.totalLength) {
                return this.singleBuffer;
            }
        } else {
            this.singleBuffer = new byte[this.totalLength];
            int off = 0;
            int buffersSize = this.buffers.size();
            int i = 0;
            while (i < buffersSize) {
                Buffer buffer = (Buffer)this.buffers.get(i);
                System.arraycopy(buffer.buffer, buffer.offset, this.singleBuffer, off, buffer.length);
                off += buffer.length;
                ++i;
            }
            this.buffers.clear();
            return this.singleBuffer;
        }
        byte[] tmp = new byte[this.totalLength];
        System.arraycopy(this.singleBuffer, this.singleBufferOffset, tmp, 0, this.totalLength);
        this.singleBuffer = tmp;
        this.singleBufferOffset = 0;
        return this.singleBuffer;
    }

    public void writeTo(OutputStream out) throws IOException {
        if (!this.closed) {
            throw new IllegalStateException("Content is incomplete");
        }
        if (this.singleBuffer != null) {
            out.write(this.singleBuffer, this.singleBufferOffset, this.totalLength);
        } else {
            int buffersSize = this.buffers.size();
            int i = 0;
            while (i < buffersSize) {
                Buffer buffer = (Buffer)this.buffers.get(i);
                out.write(buffer.buffer, buffer.offset, buffer.length);
                ++i;
            }
        }
    }

    private static class Buffer {
        byte[] buffer;
        int offset;
        int length;

        private Buffer(byte[] buffer, int offset, int length) {
            this.buffer = buffer;
            this.offset = offset;
            this.length = length;
        }
    }

    private static class BufferInputStream
    extends InputStream {
        private List buffers;
        private Buffer buffer;
        private int bufferIndex;
        private int offset;

        private BufferInputStream(List buffers) {
            this.buffers = buffers;
            if (buffers.size() > 0) {
                this.buffer = (Buffer)buffers.get(0);
                this.offset = this.buffer.offset;
            }
        }

        public int read() throws IOException {
            if (this.buffer == null) {
                return -1;
            }
            int val = this.buffer.buffer[this.offset] & 0xFF;
            ++this.offset;
            if (this.offset >= this.buffer.length) {
                ++this.bufferIndex;
                if (this.bufferIndex >= this.buffers.size()) {
                    this.buffer = null;
                    return -1;
                }
                this.buffer = (Buffer)this.buffers.get(this.bufferIndex);
                this.offset = this.buffer.offset;
            }
            return val;
        }

        public int read(byte[] userBuf, int userOff, int userLen) throws IOException {
            int totalRead = 0;
            while (userLen > 0 && this.bufferIndex < this.buffers.size()) {
                int len = this.buffer.length - this.offset;
                if (len > userLen) {
                    len = userLen;
                }
                System.arraycopy(this.buffer.buffer, this.offset, userBuf, userOff, len);
                userLen -= len;
                userOff += len;
                totalRead += len;
                this.offset += len;
                if (this.offset < this.buffer.length) continue;
                ++this.bufferIndex;
                if (this.bufferIndex >= this.buffers.size()) continue;
                this.buffer = (Buffer)this.buffers.get(this.bufferIndex);
                this.offset = this.buffer.offset;
            }
            return totalRead > 0 ? totalRead : -1;
        }
    }
}

