/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.schema;

import com.nanobiz.xml.schema.Schema;
import com.nanobiz.xml.schema.SchemaErrorListener;
import com.nanobiz.xml.schema.SchemaException;
import com.nanobiz.xml.schema.loader.SchemaDocumentLoader;
import com.nanobiz.xml.schema.loader.SchemaDocumentLoaderFactory;
import com.nanobiz.xml.schema.loader.SchemaLoader;
import com.nanobiz.xml.schema.loader.SchemaLoaderFactory;
import com.nanobiz.xml.schema.validator.Validator;
import com.nanobiz.xml.schema.validator.ValidatorFactory;
import com.verisign.resource.ResourceFactory;
import com.verisign.schema.SchemaLoaderException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.w3c.dom.Document;

public class SchemaValidator {
    private static final String NEWLINE = System.getProperty("line.separator");
    private Validator validator;
    private StringBuffer errors = new StringBuffer();
    static /* synthetic */ Class class$com$verisign$schema$SchemaValidator;

    public SchemaValidator(Document[] schemata) throws SchemaLoaderException {
        this.load(schemata);
    }

    public SchemaValidator(File[] schemata) throws SchemaLoaderException, IOException {
        this.load(this.parseFiles(schemata));
    }

    private void load(Document[] schemata) throws SchemaLoaderException {
        this.errors = new StringBuffer();
        MyListener listener = new MyListener(this.errors);
        SchemaLoader loader = SchemaLoaderFactory.newLoader(listener);
        SchemaDocumentLoader docLoader = SchemaDocumentLoaderFactory.newDocumentArrayLoader(schemata);
        Schema schema = loader.loadSchema(docLoader);
        if (this.errors.length() > 0) {
            throw new SchemaLoaderException(this.errors.toString());
        }
        this.validator = ValidatorFactory.getValidator(schema, listener);
    }

    public String validate(Document instance) {
        this.errors.setLength(0);
        this.validator.validateDocument(instance);
        return this.errors.length() > 0 ? this.errors.toString() : null;
    }

    public String validate(File instance) throws IOException {
        return this.validate(this.parseFile(instance));
    }

    private Document[] parseFiles(File[] files) throws IOException {
        Document[] docs = new Document[files.length];
        int i = 0;
        while (i < docs.length) {
            docs[i] = this.parseFile(files[i]);
            ++i;
        }
        return docs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document parseFile(File file) throws IOException {
        Document document;
        FileReader reader = new FileReader(file);
        try {
            document = ResourceFactory.getXMLResource().parseXML(new BufferedReader(reader));
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            reader.close();
            throw throwable;
        }
        reader.close();
        return document;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("Usage: java " + (class$com$verisign$schema$SchemaValidator == null ? (class$com$verisign$schema$SchemaValidator = SchemaValidator.class$("com.verisign.schema.SchemaValidator")) : class$com$verisign$schema$SchemaValidator));
            System.out.println("  <instanceFile> <schemaFile>...");
            System.exit(2);
        }
        File[] schemaFiles = new File[args.length - 1];
        int i = 1;
        while (i < args.length) {
            schemaFiles[i - 1] = new File(args[i]);
            ++i;
        }
        SchemaValidator validator = new SchemaValidator(schemaFiles);
        String err = validator.validate(new File(args[0]));
        if (err != null) {
            System.out.println(err);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MyListener
    implements SchemaErrorListener {
        private StringBuffer errors;

        private MyListener(StringBuffer errors) {
            this.errors = errors;
        }

        public void schemaError(SchemaException ex) {
            if (this.errors.length() > 0) {
                this.errors.append(NEWLINE);
            }
            this.errors.append(ex.getMessage());
        }
    }
}

