/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.saml.protocol;

import com.verisign.datatypes.QName;

public class StatusCode {
    private static final String PROTOCOL_PREFIX = "samlp";
    private static final String PROTOCOL_NAMESPACE = "urn:oasis:names:tc:SAML:1.0:protocol";
    public static final StatusCode Success;
    public static final StatusCode VersionMismatch;
    public static final StatusCode Requester;
    public static final StatusCode Responder;
    public static final StatusCode RequestVersionTooHigh;
    public static final StatusCode RequestVersionTooLow;
    public static final StatusCode RequestVersionDeprecated;
    public static final StatusCode TooManyResponses;
    public static final StatusCode RequestDenied;
    public static final StatusCode ResourceNotRecognized;
    private QName statusCodeValue;
    private StatusCode nestedStatusCode;

    static StatusCode newStatusCode(String val) {
        return new StatusCode(new QName(PROTOCOL_NAMESPACE, PROTOCOL_PREFIX, val));
    }

    public StatusCode(QName value) {
        this.statusCodeValue = value;
    }

    public StatusCode(QName value, StatusCode nsc) {
        this.statusCodeValue = value;
        this.nestedStatusCode = nsc;
    }

    public QName getValue() {
        return this.statusCodeValue;
    }

    public StatusCode getNestedStatusCode() {
        return this.nestedStatusCode;
    }

    static {
        PROTOCOL_PREFIX = PROTOCOL_PREFIX;
        PROTOCOL_NAMESPACE = PROTOCOL_NAMESPACE;
        Success = StatusCode.newStatusCode("Success");
        VersionMismatch = StatusCode.newStatusCode("VersionMismatch");
        Requester = StatusCode.newStatusCode("Requester");
        Responder = StatusCode.newStatusCode("Responder");
        RequestVersionTooHigh = StatusCode.newStatusCode("RequestVersionTooHigh");
        RequestVersionTooLow = StatusCode.newStatusCode("RequestVersionTooLow");
        RequestVersionDeprecated = StatusCode.newStatusCode("RequestVersionDeprecated");
        TooManyResponses = StatusCode.newStatusCode("TooManyResponses");
        RequestDenied = StatusCode.newStatusCode("RequestDenied");
        ResourceNotRecognized = StatusCode.newStatusCode("ResourceNotRecognized");
    }
}

