/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.saml.assertions;

import com.verisign.saml.assertions.AudienceRestrictionCondition;
import com.verisign.saml.assertions.Condition;
import com.verisign.saml.assertions.ConditionValue;
import java.util.Date;

public class Conditions {
    private Date notBeforeDate;
    private Date notOnOrAfterDate;
    private Condition[] conditions;
    private AudienceRestrictionCondition[] audienceRestrictionConditions;

    public Conditions(Date notBeforeDate, Date notOnOrAfterDate, Condition[] conditions, AudienceRestrictionCondition[] audienceRestrictionConditions) {
        this.notBeforeDate = notBeforeDate;
        this.notOnOrAfterDate = notOnOrAfterDate;
        this.conditions = conditions;
        this.audienceRestrictionConditions = audienceRestrictionConditions;
    }

    public Date getNotBefore() {
        return this.notBeforeDate;
    }

    public Date getNotOnOrAfter() {
        return this.notOnOrAfterDate;
    }

    public Condition[] getConditions() {
        return this.conditions;
    }

    public AudienceRestrictionCondition[] getAudienceRestrictionConditions() {
        return this.audienceRestrictionConditions;
    }

    public ConditionValue validateConditions() {
        ConditionValue result;
        Date now = new Date();
        if (this.notBeforeDate != null && now.before(this.notBeforeDate)) {
            result = ConditionValue.Invalid;
        } else if (this.notOnOrAfterDate != null && (now.equals(this.notOnOrAfterDate) || now.after(this.notOnOrAfterDate))) {
            result = ConditionValue.Invalid;
        } else {
            result = ConditionValue.Valid;
            if (this.conditions != null) {
                int i = 0;
                while (i < this.conditions.length) {
                    ConditionValue val = this.conditions[i].evaluate(null);
                    if (val == ConditionValue.Invalid) {
                        result = val;
                        break;
                    }
                    if (val == ConditionValue.Indeterminate) {
                        result = val;
                    }
                    ++i;
                }
            }
        }
        return result;
    }
}

