/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.saml;

import com.verisign.datatypes.DateTime;
import com.verisign.datatypes.QName;
import com.verisign.domutil.DOMCursor;
import com.verisign.domutil.DOMWriteCursor;
import com.verisign.saml.ResponseImpl;
import com.verisign.saml.StatusDetailImpl;
import com.verisign.saml.XMLAssertionGenerator;
import com.verisign.saml.assertions.Assertion;
import com.verisign.saml.assertions.Authenticity;
import com.verisign.saml.assertions.IDReferenceType;
import com.verisign.saml.assertions.IDType;
import com.verisign.saml.authorities.ResponseGenerator;
import com.verisign.saml.protocol.Response;
import com.verisign.saml.protocol.Status;
import com.verisign.saml.protocol.StatusCode;
import com.verisign.saml.protocol.StatusDetail;
import com.verisign.xmlsig.SigningKey;
import com.verisign.xmlsig.VerifyingKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xmltrustcenter.verifier.TrustVerifier;

class XMLResponseGenerator
extends XMLAssertionGenerator
implements ResponseGenerator {
    XMLResponseGenerator(SigningKey signingKey, VerifyingKey verifyingKey, TrustVerifier trustVerifier, Authenticity defaultAuthenticity, boolean isTopSignatureVerified, boolean schemaValidation) {
        super(signingKey, verifyingKey, trustVerifier, defaultAuthenticity, isTopSignatureVerified, schemaValidation);
    }

    public Response createResponse(byte[] responseDocument) throws Exception {
        return this.createResponse(XMLAssertionGenerator.xmlres.parseXML(new ByteArrayInputStream(responseDocument), false));
    }

    public Response createResponse(String responseDocument) throws Exception {
        return this.createResponse(XMLAssertionGenerator.xmlres.parseXML(new StringReader(responseDocument), false));
    }

    public Response createResponse(InputStream responseDocument) throws Exception {
        return this.createResponse(XMLAssertionGenerator.xmlres.parseXML(responseDocument, false));
    }

    public Response createResponse(Status status, Assertion[] assertions) {
        return this.createResponse(null, null, status, assertions);
    }

    public Response createResponse(IDReferenceType inResponseTo, Status status, Assertion[] assertions) {
        return this.createResponse(inResponseTo, null, status, assertions);
    }

    public Response createResponse(String recipient, Status status, Assertion[] assertions) {
        return this.createResponse(null, recipient, status, assertions);
    }

    public Response createResponse(IDReferenceType inResponseTo, String recipient, Status status, Assertion[] assertions) {
        return new ResponseImpl(inResponseTo, recipient, status, assertions, XMLAssertionGenerator.NOT_AUTHENTIC, this.signingKey, this.verifyingKey);
    }

    public Response createResponse(Node responseDocument) throws Exception {
        return this.responseFromXml(responseDocument, this.defaultAuthenticity, this.isTopSignatureVerified);
    }

    public byte[] responseToByteArray(Response response) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        XMLAssertionGenerator.xmlres.publish(this.responseToXML(response), (OutputStream)out);
        return out.toByteArray();
    }

    public String responseToString(Response response) throws Exception {
        StringWriter out = new StringWriter(1024);
        XMLAssertionGenerator.xmlres.publish(this.responseToXML(response), (Writer)out);
        return out.toString();
    }

    public void responseToOutputStream(Response response, OutputStream out) throws Exception {
        XMLAssertionGenerator.xmlres.publish(this.responseToXML(response), out);
    }

    public Document responseToXML(Response response) throws Exception {
        DOMWriteCursor c = new DOMWriteCursor();
        this.responseToXml(c, response);
        return c.getDocument();
    }

    private Response responseFromXml(Node node, Authenticity authenticity, boolean topSignaturePreverified) throws Exception {
        DOMCursor c = this.cursorFromNode(node);
        this.checkElem(c, "urn:oasis:names:tc:SAML:1.0:protocol", "samlp", "Response");
        this.performSchemaValidation(c.getDocument());
        int majorVersion = this.getIntAttr(c, "MajorVersion");
        int minorVersion = this.getIntAttr(c, "MinorVersion");
        Date issueInstant = this.getISODateTimeAttr(c, "IssueInstant");
        IDType responseID = new IDType(this.getAttr(c, "ResponseID"));
        IDReferenceType inResponseTo = null;
        String val = this.getAttr(c, "InResponseTo", null);
        if (val != null) {
            inResponseTo = new IDReferenceType(val);
        }
        String recipient = this.getURIAttr(c, "Recipient", null);
        this.moveToRequiredFirstChild(c);
        if (c.atElement("http://www.w3.org/2000/09/xmldsig#", "Signature")) {
            authenticity = this.verify(c, topSignaturePreverified);
            this.moveToRequiredNextSibling(c);
        }
        this.checkElem(c, "urn:oasis:names:tc:SAML:1.0:protocol", "samlp", "Status");
        Status status = this.statusFromXml(c);
        Assertion[] assertions = null;
        ArrayList<Assertion> list = new ArrayList<Assertion>();
        boolean more = c.moveToSibling(1);
        while (more && c.atElement("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion")) {
            list.add(this.assertionFromXml(c, authenticity, false));
            more = c.moveToSibling(1);
        }
        if (list.size() > 0) {
            assertions = new Assertion[list.size()];
            list.toArray(assertions);
        }
        return new ResponseImpl(majorVersion, minorVersion, issueInstant, responseID, inResponseTo, recipient, status, assertions, authenticity, null, null);
    }

    private DOMWriteCursor responseToXml(DOMWriteCursor c, Response obj) throws Exception {
        String recipient;
        c = c.addUnder("urn:oasis:names:tc:SAML:1.0:protocol", "samlp", "Response");
        c.setAttribute("MajorVersion", String.valueOf(obj.getMajorVersion()));
        c.setAttribute("MinorVersion", String.valueOf(obj.getMinorVersion()));
        c.setAttribute("IssueInstant", DateTime.formatISODateTime(obj.getIssueInstant()));
        c.setAttribute("ResponseID", obj.getResponseID().toString());
        IDReferenceType inResponseTo = obj.getInResponseTo();
        if (inResponseTo != null) {
            c.setAttribute("InResponseTo", inResponseTo.toString());
        }
        if ((recipient = obj.getRecipient()) != null) {
            c.setAttribute("Recipient", recipient.toString());
        }
        DOMWriteCursor sigSibling = this.statusToXml(c, obj.getStatus());
        Assertion[] assertions = obj.getAssertions();
        if (assertions != null) {
            int i = 0;
            while (i < assertions.length) {
                this.assertionToXml(c, assertions[i]);
                ++i;
            }
        }
        this.sign(c, obj, sigSibling.createXPath(), true);
        return c;
    }

    private Status statusFromXml(DOMCursor c) throws Exception {
        c = c.cloneCursor();
        this.moveToRequiredFirstChild(c);
        this.checkElem(c, "urn:oasis:names:tc:SAML:1.0:protocol", "samlp", "StatusCode");
        StatusCode code = this.statusCodeFromXml(c);
        String msg = null;
        boolean more = c.moveToSibling(1);
        if (more && c.atElement("urn:oasis:names:tc:SAML:1.0:protocol", "StatusMessage")) {
            msg = this.getText(c);
            more = c.moveToSibling(1);
        }
        StatusDetailImpl detail = null;
        if (more && c.atElement("urn:oasis:names:tc:SAML:1.0:protocol", "StatusDetail")) {
            detail = new StatusDetailImpl(c.getElement());
            more = c.moveToSibling(1);
        }
        return new Status(code, msg, detail);
    }

    private DOMWriteCursor statusToXml(DOMWriteCursor c, Status obj) throws Exception {
        StatusDetail detail;
        c = c.addUnder("urn:oasis:names:tc:SAML:1.0:protocol", "samlp", "Status");
        this.statusCodeToXml(c, obj.getStatusCode());
        String msg = obj.getStatusMessage();
        if (msg != null) {
            DOMWriteCursor c2 = c.addUnder("urn:oasis:names:tc:SAML:1.0:protocol", "samlp", "StatusMessage");
            c2.setText(msg);
        }
        if ((detail = obj.getStatusDetail()) instanceof StatusDetailImpl) {
            DOMCursor c2 = new DOMCursor(((StatusDetailImpl)detail).getElement());
            c.copyUnder(c2);
        } else if (detail != null) {
            // empty if block
        }
        return c;
    }

    private StatusCode statusCodeFromXml(DOMCursor c) throws Exception {
        c = c.cloneCursor();
        QName val = this.getQNameAttr(c, "Value");
        StatusCode nested = null;
        if (c.moveToChild(1) && c.atElement("urn:oasis:names:tc:SAML:1.0:protocol", "StatusCode")) {
            nested = this.statusCodeFromXml(c);
        }
        return new StatusCode(val, nested);
    }

    private DOMWriteCursor statusCodeToXml(DOMWriteCursor c, StatusCode obj) throws Exception {
        c = c.addUnder("urn:oasis:names:tc:SAML:1.0:protocol", "samlp", "StatusCode");
        this.setQNameAttr(c, "Value", obj.getValue());
        StatusCode nested = obj.getNestedStatusCode();
        if (nested != null) {
            this.statusCodeToXml(c, nested);
        }
        return c;
    }
}

