/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.saml;

import com.verisign.datatypes.DateTime;
import com.verisign.datatypes.QName;
import com.verisign.domutil.DOMCursor;
import com.verisign.domutil.DOMWriteCursor;
import com.verisign.saml.IllegalXMLException;
import com.verisign.saml.RequestImpl;
import com.verisign.saml.XMLAssertionGenerator;
import com.verisign.saml.assertions.Action;
import com.verisign.saml.assertions.AttributeDesignator;
import com.verisign.saml.assertions.Authenticity;
import com.verisign.saml.assertions.Evidence;
import com.verisign.saml.assertions.IDReferenceType;
import com.verisign.saml.assertions.IDType;
import com.verisign.saml.assertions.Subject;
import com.verisign.saml.authorities.RequestGenerator;
import com.verisign.saml.protocol.AttributeQuery;
import com.verisign.saml.protocol.AuthNQuery;
import com.verisign.saml.protocol.AuthZDecisionQuery;
import com.verisign.saml.protocol.Query;
import com.verisign.saml.protocol.Request;
import com.verisign.xmlsig.SigningKey;
import com.verisign.xmlsig.VerifyingKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xmltrustcenter.verifier.TrustVerifier;

class XMLRequestGenerator
extends XMLAssertionGenerator
implements RequestGenerator {
    XMLRequestGenerator(SigningKey signingKey, VerifyingKey verifyingKey, TrustVerifier trustVerifier, Authenticity defaultAuthenticity, boolean isTopSignatureVerified, boolean schemaValidation) {
        super(signingKey, verifyingKey, trustVerifier, defaultAuthenticity, isTopSignatureVerified, schemaValidation);
    }

    public Request createRequest(byte[] requestDocument) throws Exception {
        return this.createRequest(XMLAssertionGenerator.xmlres.parseXML(new ByteArrayInputStream(requestDocument), false));
    }

    public Request createRequest(String requestDocument) throws Exception {
        return this.createRequest(XMLAssertionGenerator.xmlres.parseXML(new StringReader(requestDocument), false));
    }

    public Request createRequest(InputStream requestDocument) throws Exception {
        return this.createRequest(XMLAssertionGenerator.xmlres.parseXML(requestDocument, false));
    }

    public Request createRequest(Query query) {
        return this.createRequest(null, query);
    }

    public Request createRequest(String[] artifacts) {
        return this.createRequest(null, artifacts);
    }

    public Request createRequest(IDReferenceType[] idRefs) {
        return this.createRequest(null, idRefs);
    }

    public Request createRequest(QName[] respondWith, Query query) {
        return new RequestImpl(respondWith, query, null, null, XMLAssertionGenerator.NOT_AUTHENTIC, this.signingKey, this.verifyingKey);
    }

    public Request createRequest(QName[] respondWith, String[] artifacts) {
        return new RequestImpl(respondWith, null, artifacts, null, XMLAssertionGenerator.NOT_AUTHENTIC, this.signingKey, this.verifyingKey);
    }

    public Request createRequest(QName[] respondWith, IDReferenceType[] idRefs) {
        return new RequestImpl(respondWith, null, null, idRefs, XMLAssertionGenerator.NOT_AUTHENTIC, this.signingKey, this.verifyingKey);
    }

    public Request createRequest(Node requestDocument) throws Exception {
        return this.requestFromXml(requestDocument, this.defaultAuthenticity, this.isTopSignatureVerified);
    }

    public byte[] requestToByteArray(Request request) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        XMLAssertionGenerator.xmlres.publish(this.requestToXML(request), (OutputStream)out);
        return out.toByteArray();
    }

    public String requestToString(Request request) throws Exception {
        StringWriter out = new StringWriter(1024);
        XMLAssertionGenerator.xmlres.publish(this.requestToXML(request), (Writer)out);
        return out.toString();
    }

    public void requestToOutputStream(Request request, OutputStream out) throws Exception {
        XMLAssertionGenerator.xmlres.publish(this.requestToXML(request), out);
    }

    public Document requestToXML(Request request) throws Exception {
        DOMWriteCursor c = new DOMWriteCursor();
        this.requestToXml(c, request);
        return c.getDocument();
    }

    private Request requestFromXml(Node node, Authenticity authenticity, boolean topSignaturePreverified) throws Exception {
        DOMCursor c = this.cursorFromNode(node);
        this.checkElem(c, "urn:oasis:names:tc:SAML:1.0:protocol", "samlp", "Request");
        this.performSchemaValidation(c.getDocument());
        int majorVersion = this.getIntAttr(c, "MajorVersion");
        int minorVersion = this.getIntAttr(c, "MinorVersion");
        Date issueInstant = this.getISODateTimeAttr(c, "IssueInstant");
        IDType requestID = new IDType(this.getAttr(c, "RequestID"));
        QName[] respondWith = null;
        ArrayList<Object> list = new ArrayList<Object>();
        this.moveToRequiredFirstChild(c);
        boolean more = true;
        while (more && c.atElement("urn:oasis:names:tc:SAML:1.0:protocol", "RespondWith")) {
            list.add(this.getQNameText(c));
            more = c.moveToSibling(1);
        }
        if (list.size() > 0) {
            respondWith = new QName[list.size()];
            list.toArray(respondWith);
        }
        if (more && c.atElement("http://www.w3.org/2000/09/xmldsig#", "Signature")) {
            authenticity = this.verify(c, topSignaturePreverified);
            this.moveToRequiredNextSibling(c);
        }
        Query query = null;
        String[] artifacts = null;
        IDReferenceType[] idRefs = null;
        list.clear();
        more = true;
        while (more && c.atElement("urn:oasis:names:tc:SAML:1.0:assertion", "AssertionIDReference")) {
            list.add(new IDReferenceType(this.getText(c)));
            more = c.moveToSibling(1);
        }
        if (list.size() > 0) {
            idRefs = new IDReferenceType[list.size()];
            list.toArray(idRefs);
        } else {
            more = true;
            while (more && c.atElement("urn:oasis:names:tc:SAML:1.0:protocol", "AssertionArtifact")) {
                list.add(this.getText(c));
                more = c.moveToSibling(1);
            }
            if (list.size() > 0) {
                artifacts = new String[list.size()];
                list.toArray(artifacts);
            } else {
                query = this.queryFromXml(c, authenticity);
                if (query == null) {
                    throw new IllegalXMLException("Request must contain a Query");
                }
            }
        }
        return new RequestImpl(majorVersion, minorVersion, issueInstant, requestID, respondWith, query, artifacts, idRefs, authenticity, null, null);
    }

    private DOMWriteCursor requestToXml(DOMWriteCursor c, Request obj) throws Exception {
        c = c.addUnder("urn:oasis:names:tc:SAML:1.0:protocol", "samlp", "Request");
        c.setAttribute("MajorVersion", String.valueOf(obj.getMajorVersion()));
        c.setAttribute("MinorVersion", String.valueOf(obj.getMinorVersion()));
        c.setAttribute("IssueInstant", DateTime.formatISODateTime(obj.getIssueInstant()));
        c.setAttribute("RequestID", obj.getRequestID().toString());
        QName[] respondWith = obj.getRespondWith();
        if (respondWith != null) {
            int i = 0;
            while (i < respondWith.length) {
                DOMWriteCursor c2 = c.addUnder("urn:oasis:names:tc:SAML:1.0:protocol", "samlp", "RespondWith");
                this.setQNameText(c2, respondWith[i]);
                ++i;
            }
        }
        Query query = obj.getQuery();
        String[] artifacts = obj.getAssertionArtifacts();
        IDReferenceType[] idRefs = obj.getAssertionIDReferences();
        DOMWriteCursor sigSibling = null;
        if (idRefs != null && idRefs.length > 0) {
            int i = 0;
            while (i < idRefs.length) {
                DOMWriteCursor c2 = c.addUnder("urn:oasis:names:tc:SAML:1.0:assertion", "saml", "AssertionIDReference");
                c2.setText(idRefs[i].toString());
                if (sigSibling == null) {
                    sigSibling = c2;
                }
                ++i;
            }
        } else if (artifacts != null && artifacts.length > 0) {
            int i = 0;
            while (i < artifacts.length) {
                DOMWriteCursor c2 = c.addUnder("urn:oasis:names:tc:SAML:1.0:protocol", "samlp", "AssertionArtifact");
                c2.setText(artifacts[i]);
                if (sigSibling == null) {
                    sigSibling = c2;
                }
                ++i;
            }
        } else if (query != null) {
            sigSibling = this.queryToXml(c, query);
        }
        if (sigSibling != null) {
            this.sign(c, obj, sigSibling.createXPath(), true);
        } else {
            this.sign(c, obj, c.createXPath(), false);
        }
        return c;
    }

    private AttributeDesignator attributeDesignatorFromXml(DOMCursor c) throws Exception {
        String name = this.getAttr(c, "AttributeName");
        String uri = this.getURIAttr(c, "AttributeNamespace");
        return new AttributeDesignator(uri, name);
    }

    private DOMWriteCursor attributeDesignatorToXml(DOMWriteCursor c, AttributeDesignator obj) throws Exception {
        c = c.addUnder("urn:oasis:names:tc:SAML:1.0:assertion", "saml", "AttributeDesignator");
        c.setAttribute("AttributeName", obj.getAttributeName());
        c.setAttribute("AttributeNamespace", obj.getAttributeNamespace().toString());
        return c;
    }

    private Query queryFromXml(DOMCursor c, Authenticity authenticity) throws Exception {
        if (c.atElement("urn:oasis:names:tc:SAML:1.0:protocol", "AuthenticationQuery")) {
            return this.authNQueryFromXml(c);
        }
        if (c.atElement("urn:oasis:names:tc:SAML:1.0:protocol", "AuthorizationDecisionQuery")) {
            return this.authZQueryFromXml(c, authenticity);
        }
        if (c.atElement("urn:oasis:names:tc:SAML:1.0:protocol", "AttributeQuery")) {
            return this.attrQueryFromXml(c);
        }
        return null;
    }

    private DOMWriteCursor queryToXml(DOMWriteCursor c, Query obj) throws Exception {
        if (obj instanceof AuthNQuery) {
            return this.authNQueryToXml(c, (AuthNQuery)obj);
        }
        if (obj instanceof AuthZDecisionQuery) {
            return this.authZQueryToXml(c, (AuthZDecisionQuery)obj);
        }
        if (obj instanceof AttributeQuery) {
            return this.attrQueryToXml(c, (AttributeQuery)obj);
        }
        throw new Exception("unknown query: " + obj.getClass());
    }

    private AuthNQuery authNQueryFromXml(DOMCursor c) throws Exception {
        c = c.cloneCursor();
        String method = this.getURIAttr(c, "AuthenticationMethod", null);
        Subject subject = this.getFirstChildSubject(c);
        return new AuthNQuery(subject, method);
    }

    private DOMWriteCursor authNQueryToXml(DOMWriteCursor c, AuthNQuery obj) throws Exception {
        c = c.addUnder("urn:oasis:names:tc:SAML:1.0:protocol", "samlp", "AuthenticationQuery");
        String method = obj.getAuthenticationMethod();
        if (method != null) {
            c.setAttribute("AuthenticationMethod", method.toString());
        }
        this.subjectToXml(c, obj.getSubject());
        return c;
    }

    private AuthZDecisionQuery authZQueryFromXml(DOMCursor c, Authenticity authenticity) throws Exception {
        c = c.cloneCursor();
        String resource = this.getURIAttr(c, "Resource");
        Subject subject = this.getFirstChildSubject(c);
        Action[] actions = this.actionsFromXml(c);
        Evidence evidence = null;
        if (c.atElement("urn:oasis:names:tc:SAML:1.0:assertion", "Evidence")) {
            evidence = this.evidenceFromXml(c, authenticity);
        }
        return new AuthZDecisionQuery(subject, resource, actions, evidence);
    }

    private DOMWriteCursor authZQueryToXml(DOMWriteCursor c, AuthZDecisionQuery obj) throws Exception {
        c = c.addUnder("urn:oasis:names:tc:SAML:1.0:protocol", "samlp", "AuthorizationDecisionQuery");
        c.setAttribute("Resource", obj.getResource().toString());
        this.subjectToXml(c, obj.getSubject());
        this.actionsToXml(c, obj.getActions());
        Evidence evidence = obj.getEvidence();
        if (evidence != null) {
            this.evidenceToXml(c, evidence);
        }
        return c;
    }

    private AttributeQuery attrQueryFromXml(DOMCursor c) throws Exception {
        c = c.cloneCursor();
        String resource = this.getURIAttr(c, "Resource", null);
        Subject subject = this.getFirstChildSubject(c);
        ArrayList<AttributeDesignator> list = new ArrayList<AttributeDesignator>();
        boolean more = c.moveToSibling(1);
        while (more && c.atElement("urn:oasis:names:tc:SAML:1.0:assertion", "AttributeDesignator")) {
            list.add(this.attributeDesignatorFromXml(c));
            more = c.moveToSibling(1);
        }
        AttributeDesignator[] designators = null;
        if (list.size() > 0) {
            designators = new AttributeDesignator[list.size()];
            list.toArray(designators);
        }
        return new AttributeQuery(subject, designators, resource);
    }

    private DOMWriteCursor attrQueryToXml(DOMWriteCursor c, AttributeQuery obj) throws Exception {
        c = c.addUnder("urn:oasis:names:tc:SAML:1.0:protocol", "samlp", "AttributeQuery");
        String resource = obj.getResource();
        if (resource != null) {
            c.setAttribute("Resource", resource.toString());
        }
        this.subjectToXml(c, obj.getSubject());
        AttributeDesignator[] designators = obj.getAttributeDesignators();
        if (designators != null) {
            int i = 0;
            while (i < designators.length) {
                this.attributeDesignatorToXml(c, designators[i]);
                ++i;
            }
        }
        return c;
    }
}

