/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.saml;

import com.verisign.datatypes.DateTime;
import com.verisign.datatypes.QName;
import com.verisign.domutil.DOMCursor;
import com.verisign.domutil.DOMWriteCursor;
import com.verisign.resource.ResourceFactory;
import com.verisign.resource.XMLResource;
import com.verisign.saml.AssertionImpl;
import com.verisign.saml.ConditionImpl;
import com.verisign.saml.IllegalXMLException;
import com.verisign.saml.ToBeSigned;
import com.verisign.saml.assertions.Action;
import com.verisign.saml.assertions.Advice;
import com.verisign.saml.assertions.Assertion;
import com.verisign.saml.assertions.Attribute;
import com.verisign.saml.assertions.AttributeStatement;
import com.verisign.saml.assertions.AudienceRestrictionCondition;
import com.verisign.saml.assertions.AuthNStatement;
import com.verisign.saml.assertions.AuthZDecisionStatement;
import com.verisign.saml.assertions.Authenticity;
import com.verisign.saml.assertions.AuthorityBinding;
import com.verisign.saml.assertions.Condition;
import com.verisign.saml.assertions.Conditions;
import com.verisign.saml.assertions.DecisionType;
import com.verisign.saml.assertions.Evidence;
import com.verisign.saml.assertions.IDReferenceType;
import com.verisign.saml.assertions.IDType;
import com.verisign.saml.assertions.NameIdentifier;
import com.verisign.saml.assertions.Statement;
import com.verisign.saml.assertions.Subject;
import com.verisign.saml.assertions.SubjectConfirmation;
import com.verisign.saml.assertions.SubjectLocality;
import com.verisign.saml.authorities.AssertionGenerator;
import com.verisign.schema.SchemaLoaderException;
import com.verisign.schema.SchemaValidator;
import com.verisign.xmlsig.KeyInfo;
import com.verisign.xmlsig.Signer;
import com.verisign.xmlsig.SigningKey;
import com.verisign.xmlsig.Verifier;
import com.verisign.xmlsig.VerifyingKey;
import com.verisign.xmlsig.util.XMLSigSchema;
import com.verisign.xpath.XPath;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmltrustcenter.verifier.TrustVerifier;

class XMLAssertionGenerator
implements AssertionGenerator {
    static final Authenticity NOT_AUTHENTIC = new Authenticity();
    static XMLResource xmlres = ResourceFactory.getXMLResource();
    static SchemaValidator schemaValidator;
    static final int SAML_MAJOR_VERSION = 1;
    static final int SAML_MINOR_VERSION = 0;
    static final String ASSERTION_PREFIX = "saml";
    static final String ASSERTION_NAMESPACE = "urn:oasis:names:tc:SAML:1.0:assertion";
    static final String PROTOCOL_PREFIX = "samlp";
    static final String PROTOCOL_NAMESPACE = "urn:oasis:names:tc:SAML:1.0:protocol";
    static final String XMLSIG_PREFIX = "ds";
    static final String XMLSIG_NAMESPACE = "http://www.w3.org/2000/09/xmldsig#";
    static final String TAG_Advice = "Advice";
    static final String TAG_Action = "Action";
    static final String TAG_Assertion = "Assertion";
    static final String TAG_AssertionID = "AssertionID";
    static final String TAG_AssertionArtifact = "AssertionArtifact";
    static final String TAG_AssertionIDReference = "AssertionIDReference";
    static final String TAG_Attribute = "Attribute";
    static final String TAG_AttributeDesignator = "AttributeDesignator";
    static final String TAG_AttributeName = "AttributeName";
    static final String TAG_AttributeNamespace = "AttributeNamespace";
    static final String TAG_AttributeQuery = "AttributeQuery";
    static final String TAG_AttributeStatement = "AttributeStatement";
    static final String TAG_AttributeValue = "AttributeValue";
    static final String TAG_Audience = "Audience";
    static final String TAG_AudienceRestrictionCondition = "AudienceRestrictionCondition";
    static final String TAG_AuthenticationInstant = "AuthenticationInstant";
    static final String TAG_AuthenticationMethod = "AuthenticationMethod";
    static final String TAG_AuthenticationQuery = "AuthenticationQuery";
    static final String TAG_AuthenticationStatement = "AuthenticationStatement";
    static final String TAG_AuthorityBinding = "AuthorityBinding";
    static final String TAG_AuthorityKind = "AuthorityKind";
    static final String TAG_AuthorizationDecisionQuery = "AuthorizationDecisionQuery";
    static final String TAG_AuthorizationDecisionStatement = "AuthorizationDecisionStatement";
    static final String TAG_Binding = "Binding";
    static final String TAG_Condition = "Condition";
    static final String TAG_Conditions = "Conditions";
    static final String TAG_ConfirmationMethod = "ConfirmationMethod";
    static final String TAG_Decision = "Decision";
    static final String TAG_DNSAddress = "DNSAddress";
    static final String TAG_Evidence = "Evidence";
    static final String TAG_Format = "Format";
    static final String TAG_InResponseTo = "InResponseTo";
    static final String TAG_IPAddress = "IPAddress";
    static final String TAG_IssueInstant = "IssueInstant";
    static final String TAG_Issuer = "Issuer";
    static final String TAG_Location = "Location";
    static final String TAG_MajorVersion = "MajorVersion";
    static final String TAG_MinorVersion = "MinorVersion";
    static final String TAG_NameIdentifier = "NameIdentifier";
    static final String TAG_NameQualifier = "NameQualifier";
    static final String TAG_Namespace = "Namespace";
    static final String TAG_NotBefore = "NotBefore";
    static final String TAG_NotOnOrAfter = "NotOnOrAfter";
    static final String TAG_Recipient = "Recipient";
    static final String TAG_Request = "Request";
    static final String TAG_RequestID = "RequestID";
    static final String TAG_Resource = "Resource";
    static final String TAG_RespondWith = "RespondWith";
    static final String TAG_Response = "Response";
    static final String TAG_ResponseID = "ResponseID";
    static final String TAG_Signature = "Signature";
    static final String TAG_Status = "Status";
    static final String TAG_StatusCode = "StatusCode";
    static final String TAG_StatusDetail = "StatusDetail";
    static final String TAG_StatusMessage = "StatusMessage";
    static final String TAG_Subject = "Subject";
    static final String TAG_SubjectConfirmation = "SubjectConfirmation";
    static final String TAG_SubjectConfirmationData = "SubjectConfirmationData";
    static final String TAG_SubjectLocality = "SubjectLocality";
    static final String TAG_SubjectStatement = "SubjectStatement";
    static final String TAG_Value = "Value";
    static final QName[] ATTR_STATEMENT_QNAME;
    static final QName[] AUTHN_STATEMENT_QNAME;
    static final QName[] AUTHZ_STATEMENT_QNAME;
    private static final String[] SCHEMA_FILES;
    SigningKey signingKey;
    VerifyingKey verifyingKey;
    TrustVerifier trustVerifier;
    Authenticity defaultAuthenticity;
    boolean isTopSignatureVerified;
    boolean schemaValidation;
    static /* synthetic */ Class class$com$verisign$saml$XMLAssertionGenerator;

    static String formatSAMLVersion(int majorVersion, int minorVersion) {
        return String.valueOf(majorVersion) + '.' + minorVersion;
    }

    XMLAssertionGenerator(SigningKey signingKey, VerifyingKey verifyingKey, TrustVerifier trustVerifier, Authenticity defaultAuthenticity, boolean isTopSignatureVerified, boolean schemaValidation) {
        if (defaultAuthenticity == null) {
            defaultAuthenticity = NOT_AUTHENTIC;
        }
        this.signingKey = signingKey;
        this.verifyingKey = verifyingKey;
        this.trustVerifier = trustVerifier;
        this.defaultAuthenticity = defaultAuthenticity;
        this.isTopSignatureVerified = isTopSignatureVerified;
        this.schemaValidation = schemaValidation;
    }

    public Assertion createAssertion(byte[] requestDocument) throws Exception {
        return this.createAssertion(xmlres.parseXML(new ByteArrayInputStream(requestDocument), false));
    }

    public Assertion createAssertion(String requestDocument) throws Exception {
        return this.createAssertion(xmlres.parseXML(new StringReader(requestDocument), false));
    }

    public Assertion createAssertion(InputStream requestDocument) throws Exception {
        return this.createAssertion(xmlres.parseXML(requestDocument, false));
    }

    public Assertion createAssertion(Date issueInstant, IDType assertionID, String issuer, Statement statement) {
        return this.createAssertion(issueInstant, assertionID, issuer, new Statement[]{statement}, null, null);
    }

    public Assertion createAssertion(Date issueInstant, IDType assertionID, String issuer, Statement[] statements, Conditions conditions, Advice advice) {
        return new AssertionImpl(issueInstant, assertionID, issuer, advice, conditions, statements, NOT_AUTHENTIC, this.signingKey, this.verifyingKey);
    }

    public Assertion createAssertion(String issuer, Statement statement) {
        return this.createAssertion(issuer, new Statement[]{statement}, null, null);
    }

    public Assertion createAssertion(String issuer, Statement[] statements, Conditions conditions, Advice advice) {
        return new AssertionImpl(issuer, advice, conditions, statements, NOT_AUTHENTIC, this.signingKey, this.verifyingKey);
    }

    public Assertion createAssertion(Node requestDocument) throws Exception {
        DOMCursor c = this.cursorFromNode(requestDocument);
        this.checkElem(c, ASSERTION_NAMESPACE, ASSERTION_PREFIX, TAG_Assertion);
        this.performSchemaValidation(c.getDocument());
        return this.assertionFromXml(c, this.defaultAuthenticity, this.isTopSignatureVerified);
    }

    public byte[] assertionToByteArray(Assertion request) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        xmlres.publish(this.assertionToXML(request), (OutputStream)out);
        return out.toByteArray();
    }

    public String assertionToString(Assertion request) throws Exception {
        StringWriter out = new StringWriter(1024);
        xmlres.publish(this.assertionToXML(request), (Writer)out);
        return out.toString();
    }

    public void assertionToOutputStream(Assertion request, OutputStream out) throws Exception {
        xmlres.publish(this.assertionToXML(request), out);
    }

    public Document assertionToXML(Assertion obj) throws Exception {
        DOMWriteCursor c = new DOMWriteCursor();
        this.assertionToXml(c, obj);
        return c.getDocument();
    }

    Assertion assertionFromXml(DOMCursor c, Authenticity authenticity, boolean topSignaturePreverified) throws Exception {
        if ((c = c.cloneCursor()).moveToChild(XMLSIG_NAMESPACE, TAG_Signature)) {
            authenticity = this.verify(c, topSignaturePreverified);
            c.moveToParent();
        }
        int majorVersion = this.getIntAttr(c, TAG_MajorVersion);
        int minorVersion = this.getIntAttr(c, TAG_MinorVersion);
        Date issueInstant = this.getISODateTimeAttr(c, TAG_IssueInstant);
        IDType assertionID = new IDType(this.getAttr(c, TAG_AssertionID));
        String issuer = this.getAttr(c, TAG_Issuer);
        Conditions conditions = null;
        this.moveToRequiredFirstChild(c);
        if (c.atElement(ASSERTION_NAMESPACE, TAG_Conditions)) {
            conditions = this.conditionsFromXml(c);
            this.moveToRequiredNextSibling(c);
        }
        Advice advice = null;
        if (c.atElement(ASSERTION_NAMESPACE, TAG_Advice)) {
            advice = this.adviceFromXml(c, authenticity);
            this.moveToRequiredNextSibling(c);
        }
        ArrayList<Statement> list = new ArrayList<Statement>();
        boolean more = true;
        while (more) {
            Statement statement = this.statementFromXml(c, authenticity);
            if (statement != null) {
                list.add(statement);
                more = c.moveToSibling(1);
                continue;
            }
            more = false;
        }
        if (list.size() == 0) {
            throw new IllegalXMLException("At least one Statement is required at " + c);
        }
        Statement[] statements = new Statement[list.size()];
        list.toArray(statements);
        return new AssertionImpl(majorVersion, minorVersion, issueInstant, assertionID, issuer, advice, conditions, statements, authenticity, null, null);
    }

    DOMWriteCursor assertionToXml(DOMWriteCursor c, Assertion obj) throws Exception {
        Advice advice;
        c = c.addUnder(ASSERTION_NAMESPACE, ASSERTION_PREFIX, TAG_Assertion);
        c.setAttribute(TAG_MajorVersion, String.valueOf(obj.getMajorVersion()));
        c.setAttribute(TAG_MinorVersion, String.valueOf(obj.getMinorVersion()));
        c.setAttribute(TAG_IssueInstant, DateTime.formatISODateTime(obj.getIssueInstant()));
        c.setAttribute(TAG_AssertionID, obj.getAssertionID().toString());
        c.setAttribute(TAG_Issuer, obj.getIssuer());
        Conditions conditions = obj.getConditions();
        if (conditions != null) {
            this.conditionsToXml(c, conditions);
        }
        if ((advice = obj.getAdvice()) != null) {
            this.adviceToXml(c, advice);
        }
        Statement[] statements = obj.getStatements();
        int i = 0;
        while (i < statements.length) {
            this.statementToXml(c, statements[i]);
            ++i;
        }
        this.sign(c, obj, c.createXPath(), false);
        return c;
    }

    private Conditions conditionsFromXml(DOMCursor c) throws Exception {
        c = c.cloneCursor();
        Date notBeforeDate = this.getISODateTimeAttr(c, TAG_NotBefore, null);
        Date notOnOrAfterDate = this.getISODateTimeAttr(c, TAG_NotOnOrAfter, null);
        AudienceRestrictionCondition[] arConditions = null;
        Condition[] conditions = null;
        ArrayList<Condition> cList = new ArrayList<Condition>();
        ArrayList<AudienceRestrictionCondition> arcList = new ArrayList<AudienceRestrictionCondition>();
        boolean more = c.moveToChild(1);
        while (more) {
            if (c.atElement(ASSERTION_NAMESPACE, TAG_Condition)) {
                cList.add(this.conditionFromXml(c));
                more = c.moveToSibling(1);
                continue;
            }
            if (c.atElement(ASSERTION_NAMESPACE, TAG_AudienceRestrictionCondition)) {
                arcList.add(this.arConditionFromXml(c));
                more = c.moveToSibling(1);
                continue;
            }
            more = false;
        }
        if (cList.size() > 0) {
            conditions = new Condition[cList.size()];
            cList.toArray(conditions);
        }
        if (arcList.size() > 0) {
            arConditions = new AudienceRestrictionCondition[arcList.size()];
            arcList.toArray(arConditions);
        }
        return new Conditions(notBeforeDate, notOnOrAfterDate, conditions, arConditions);
    }

    private DOMWriteCursor conditionsToXml(DOMWriteCursor c, Conditions obj) throws Exception {
        Condition[] conditions;
        AudienceRestrictionCondition[] arConditions;
        c = c.addUnder(ASSERTION_NAMESPACE, ASSERTION_PREFIX, TAG_Conditions);
        Date date = obj.getNotBefore();
        if (date != null) {
            c.setAttribute(TAG_NotBefore, DateTime.formatISODateTime(date));
        }
        if ((date = obj.getNotOnOrAfter()) != null) {
            c.setAttribute(TAG_NotOnOrAfter, DateTime.formatISODateTime(date));
        }
        if ((arConditions = obj.getAudienceRestrictionConditions()) != null) {
            int i = 0;
            while (i < arConditions.length) {
                this.arConditionToXml(c, arConditions[i]);
                ++i;
            }
        }
        if ((conditions = obj.getConditions()) != null) {
            int i = 0;
            while (i < conditions.length) {
                this.conditionToXml(c, conditions[i]);
                ++i;
            }
        }
        return c;
    }

    private AudienceRestrictionCondition arConditionFromXml(DOMCursor c) throws Exception {
        c = c.cloneCursor();
        ArrayList<String> list = new ArrayList<String>();
        this.moveToRequiredFirstChild(c);
        boolean more = true;
        while (more) {
            this.checkElem(c, ASSERTION_NAMESPACE, ASSERTION_PREFIX, TAG_Audience);
            list.add(this.getURIText(c));
            more = c.moveToSibling(1);
        }
        String[] audiences = new String[list.size()];
        list.toArray(audiences);
        return new AudienceRestrictionCondition(audiences);
    }

    private DOMWriteCursor arConditionToXml(DOMWriteCursor c, AudienceRestrictionCondition obj) throws Exception {
        c = c.addUnder(ASSERTION_NAMESPACE, ASSERTION_PREFIX, TAG_AudienceRestrictionCondition);
        String[] uris = obj.getAudiences();
        if (uris != null) {
            int i = 0;
            while (i < uris.length) {
                DOMWriteCursor c2 = c.addUnder(ASSERTION_NAMESPACE, ASSERTION_PREFIX, TAG_Audience);
                c2.setText(uris[i].toString());
                ++i;
            }
        }
        return c;
    }

    private Condition conditionFromXml(DOMCursor c) throws Exception {
        return new ConditionImpl(c.getElement());
    }

    private void conditionToXml(DOMWriteCursor c, Condition obj) throws Exception {
        if (obj instanceof ConditionImpl) {
            DOMCursor c2 = new DOMCursor(((ConditionImpl)obj).getElement());
            c.copyUnder(c2);
        }
    }

    private Advice adviceFromXml(DOMCursor c, Authenticity authenticity) throws Exception {
        c = c.cloneCursor();
        ArrayList<Assertion> assertionList = new ArrayList<Assertion>();
        ArrayList<IDReferenceType> refList = new ArrayList<IDReferenceType>();
        ArrayList<Element> otherList = new ArrayList<Element>();
        boolean more = c.moveToChild(1);
        while (more) {
            if (c.atElement(ASSERTION_NAMESPACE, TAG_Assertion)) {
                assertionList.add(this.assertionFromXml(c, authenticity, false));
            } else if (c.atElement(ASSERTION_NAMESPACE, TAG_AssertionIDReference)) {
                refList.add(new IDReferenceType(this.getText(c)));
            } else {
                otherList.add(c.getElement());
            }
            more = c.moveToSibling(1);
        }
        Assertion[] assertions = null;
        if (assertionList.size() > 0) {
            assertions = new Assertion[assertionList.size()];
            assertionList.toArray(assertions);
        }
        IDReferenceType[] refs = null;
        if (refList.size() > 0) {
            refs = new IDReferenceType[refList.size()];
            refList.toArray(assertions);
        }
        Object[] others = null;
        if (otherList.size() > 0) {
            others = otherList.toArray();
        }
        return new Advice(assertions, refs, others);
    }

    private DOMWriteCursor adviceToXml(DOMWriteCursor c, Advice obj) throws Exception {
        Object[] others;
        Assertion[] assertions;
        c = c.addUnder(ASSERTION_NAMESPACE, ASSERTION_PREFIX, TAG_Advice);
        IDReferenceType[] idRefs = obj.getAssertionIDReferences();
        if (idRefs != null) {
            int i = 0;
            while (i < idRefs.length) {
                DOMWriteCursor c2 = c.addUnder(ASSERTION_NAMESPACE, ASSERTION_PREFIX, TAG_AssertionIDReference);
                c2.setText(idRefs[i].toString());
                ++i;
            }
        }
        if ((assertions = obj.getAssertions()) != null) {
            int i = 0;
            while (i < assertions.length) {
                this.assertionToXml(c, assertions[i]);
                ++i;
            }
        }
        if ((others = obj.getOtherAdvice()) != null) {
            int i = 0;
            while (i < others.length) {
                if (others[i] instanceof Element) {
                    c.copyUnder(new DOMCursor((Element)others[i]));
                }
                ++i;
            }
        }
        return c;
    }

    private Statement statementFromXml(DOMCursor c, Authenticity authenticity) throws Exception {
        if (c.atElement(ASSERTION_NAMESPACE, TAG_AttributeStatement)) {
            return this.attrStatementFromXml(c, authenticity);
        }
        if (c.atElement(ASSERTION_NAMESPACE, TAG_AuthenticationStatement)) {
            return this.authNStatementFromXml(c, authenticity);
        }
        if (c.atElement(ASSERTION_NAMESPACE, TAG_AuthorizationDecisionStatement)) {
            return this.authZStatementFromXml(c, authenticity);
        }
        return null;
    }

    private DOMWriteCursor statementToXml(DOMWriteCursor c, Statement obj) throws Exception {
        if (obj instanceof AttributeStatement) {
            return this.attrStatementToXml(c, (AttributeStatement)obj);
        }
        if (obj instanceof AuthNStatement) {
            return this.authNStatementToXml(c, (AuthNStatement)obj);
        }
        if (obj instanceof AuthZDecisionStatement) {
            return this.authZStatementToXml(c, (AuthZDecisionStatement)obj);
        }
        throw new Exception("unknown statement: " + obj.getClass());
    }

    private AttributeStatement attrStatementFromXml(DOMCursor c, Authenticity authenticity) throws Exception {
        c = c.cloneCursor();
        Subject subject = this.getFirstChildSubject(c);
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        this.moveToRequiredNextSibling(c);
        boolean more = true;
        while (more) {
            if (c.atElement(ASSERTION_NAMESPACE, TAG_Attribute)) {
                list.add(this.attributeFromXml(c));
                more = c.moveToSibling(1);
                continue;
            }
            more = false;
        }
        Attribute[] attrs = new Attribute[list.size()];
        list.toArray(attrs);
        return new AttributeStatement(subject, authenticity, attrs);
    }

    private DOMWriteCursor attrStatementToXml(DOMWriteCursor c, AttributeStatement obj) throws Exception {
        c = c.addUnder(ASSERTION_NAMESPACE, ASSERTION_PREFIX, TAG_AttributeStatement);
        this.subjectToXml(c, obj.getSubject());
        Attribute[] attrs = obj.getAttributes();
        int i = 0;
        while (i < attrs.length) {
            this.attributeToXml(c, attrs[i]);
            ++i;
        }
        return c;
    }

    private AuthNStatement authNStatementFromXml(DOMCursor c, Authenticity authenticity) throws Exception {
        c = c.cloneCursor();
        String authNMethod = this.getURIAttr(c, TAG_AuthenticationMethod);
        Date authNInstant = this.getISODateTimeAttr(c, TAG_AuthenticationInstant);
        Subject subject = this.getFirstChildSubject(c);
        SubjectLocality subjectLocality = null;
        boolean more = c.moveToSibling(1);
        if (more && c.atElement(ASSERTION_NAMESPACE, TAG_SubjectLocality)) {
            subjectLocality = this.subjectLocalityFromXml(c);
            more = c.moveToSibling(1);
        }
        ArrayList<AuthorityBinding> list = new ArrayList<AuthorityBinding>();
        AuthorityBinding[] authorityBindings = null;
        while (more && c.atElement(ASSERTION_NAMESPACE, TAG_AuthorityBinding)) {
            list.add(this.authorityBindingFromXml(c));
            more = c.moveToSibling(1);
        }
        if (list.size() > 0) {
            authorityBindings = new AuthorityBinding[list.size()];
            list.toArray(authorityBindings);
        }
        return new AuthNStatement(subject, authenticity, authNMethod, authNInstant, subjectLocality, authorityBindings);
    }

    private DOMWriteCursor authNStatementToXml(DOMWriteCursor c, AuthNStatement obj) throws Exception {
        AuthorityBinding[] authorityBindings;
        c = c.addUnder(ASSERTION_NAMESPACE, ASSERTION_PREFIX, TAG_AuthenticationStatement);
        c.setAttribute(TAG_AuthenticationMethod, obj.getAuthNMethod().toString());
        c.setAttribute(TAG_AuthenticationInstant, DateTime.formatISODateTime(obj.getAuthNInstant()));
        this.subjectToXml(c, obj.getSubject());
        SubjectLocality subjectLocality = obj.getSubjectLocality();
        if (subjectLocality != null) {
            this.subjectLocalityToXml(c, subjectLocality);
        }
        if ((authorityBindings = obj.getAuthorityBindings()) != null) {
            int i = 0;
            while (i < authorityBindings.length) {
                this.authorityBindingToXml(c, authorityBindings[i]);
                ++i;
            }
        }
        return c;
    }

    private AuthZDecisionStatement authZStatementFromXml(DOMCursor c, Authenticity authenticity) throws Exception {
        c = c.cloneCursor();
        DecisionType decision = this.parseDecisionType(this.getAttr(c, TAG_Decision));
        String resourceURI = this.getURIAttr(c, TAG_Resource);
        Subject subject = this.getFirstChildSubject(c);
        Action[] actions = this.actionsFromXml(c);
        Evidence evidence = null;
        if (c.atElement(ASSERTION_NAMESPACE, TAG_Evidence)) {
            evidence = this.evidenceFromXml(c, authenticity);
        }
        return new AuthZDecisionStatement(subject, authenticity, resourceURI, decision, actions, evidence);
    }

    private DOMWriteCursor authZStatementToXml(DOMWriteCursor c, AuthZDecisionStatement obj) throws Exception {
        c = c.addUnder(ASSERTION_NAMESPACE, ASSERTION_PREFIX, TAG_AuthorizationDecisionStatement);
        c.setAttribute(TAG_Decision, obj.getIssuerDecision().toString());
        c.setAttribute(TAG_Resource, obj.getResourceURI().toString());
        this.subjectToXml(c, obj.getSubject());
        this.actionsToXml(c, obj.getActions());
        Evidence evidence = obj.getEvidence();
        if (evidence != null) {
            this.evidenceToXml(c, evidence);
        }
        return c;
    }

    Subject getFirstChildSubject(DOMCursor c) throws Exception {
        this.moveToRequiredFirstChild(c);
        this.checkElem(c, ASSERTION_NAMESPACE, ASSERTION_PREFIX, TAG_Subject);
        return this.subjectFromXml(c);
    }

    private Subject subjectFromXml(DOMCursor c) throws Exception {
        c = c.cloneCursor();
        this.moveToRequiredFirstChild(c);
        NameIdentifier nameIdentifier = null;
        SubjectConfirmation subjectConfirmation = null;
        if (c.atElement(ASSERTION_NAMESPACE, TAG_NameIdentifier)) {
            nameIdentifier = this.nameIdentifierFromXml(c);
            if (c.moveToSibling(1) && c.atElement(ASSERTION_NAMESPACE, TAG_SubjectConfirmation)) {
                subjectConfirmation = this.subjectConfirmationFromXml(c);
            }
        } else {
            this.checkElem(c, ASSERTION_NAMESPACE, ASSERTION_PREFIX, TAG_SubjectConfirmation);
            subjectConfirmation = this.subjectConfirmationFromXml(c);
        }
        return new Subject(nameIdentifier, subjectConfirmation);
    }

    DOMWriteCursor subjectToXml(DOMWriteCursor c, Subject obj) throws Exception {
        SubjectConfirmation subjectConfirmation;
        c = c.addUnder(ASSERTION_NAMESPACE, ASSERTION_PREFIX, TAG_Subject);
        NameIdentifier nameIdentifier = obj.getNameIdentifier();
        if (nameIdentifier != null) {
            this.nameIdentifierToXml(c, nameIdentifier);
        }
        if ((subjectConfirmation = obj.getSubjectConfirmation()) != null) {
            this.subjectConfirmationToXml(c, subjectConfirmation);
        }
        return c;
    }

    private Attribute attributeFromXml(DOMCursor c) throws Exception {
        c = c.cloneCursor();
        String name = this.getAttr(c, TAG_AttributeName);
        String uri = this.getURIAttr(c, TAG_AttributeNamespace);
        ArrayList<Object> values = new ArrayList<Object>();
        this.moveToRequiredFirstChild(c);
        boolean more = true;
        while (more && c.atElement(ASSERTION_NAMESPACE, TAG_AttributeValue)) {
            DOMCursor c2 = c.cloneCursor();
            Object val = c2.moveToChild(1) ? c2.getElement() : this.getText(c);
            values.add(val);
            more = c.moveToSibling(1);
        }
        return new Attribute(uri, name, values.toArray());
    }

    private DOMWriteCursor attributeToXml(DOMWriteCursor c, Attribute obj) throws Exception {
        c = c.addUnder(ASSERTION_NAMESPACE, ASSERTION_PREFIX, TAG_Attribute);
        c.setAttribute(TAG_AttributeName, obj.getAttributeName());
        c.setAttribute(TAG_AttributeNamespace, obj.getAttributeNamespace().toString());
        Object[] values = obj.getAttributeValues();
        int i = 0;
        while (i < values.length) {
            Object val = values[i];
            DOMWriteCursor c2 = c.addUnder(ASSERTION_NAMESPACE, ASSERTION_PREFIX, TAG_AttributeValue);
            if (val instanceof Element) {
                c2.copyUnder(new DOMCursor((Element)val));
            } else {
                c2.setText(val.toString());
            }
            ++i;
        }
        return c;
    }

    private SubjectLocality subjectLocalityFromXml(DOMCursor c) throws Exception {
        String ip = this.getAttr(c, TAG_IPAddress, null);
        String dns = this.getAttr(c, TAG_DNSAddress, null);
        return new SubjectLocality(ip, dns);
    }

    private DOMWriteCursor subjectLocalityToXml(DOMWriteCursor c, SubjectLocality obj) throws Exception {
        c = c.addUnder(ASSERTION_NAMESPACE, ASSERTION_PREFIX, TAG_SubjectLocality);
        c.setAttribute(TAG_IPAddress, obj.getIPAddress());
        c.setAttribute(TAG_DNSAddress, obj.getDNSAddress());
        return c;
    }

    private AuthorityBinding authorityBindingFromXml(DOMCursor c) throws Exception {
        QName authorityKind = this.getQNameAttr(c, TAG_AuthorityKind);
        String binding = this.getURIAttr(c, TAG_Binding);
        String location = this.getURIAttr(c, TAG_Location);
        return new AuthorityBinding(authorityKind, binding, location);
    }

    private DOMWriteCursor authorityBindingToXml(DOMWriteCursor c, AuthorityBinding obj) throws Exception {
        c = c.addUnder(ASSERTION_NAMESPACE, ASSERTION_PREFIX, TAG_AuthorityBinding);
        this.setQNameAttr(c, TAG_AuthorityKind, obj.getAuthorityKind());
        c.setAttribute(TAG_Binding, obj.getBinding().toString());
        c.setAttribute(TAG_Location, obj.getLocation().toString());
        return c;
    }

    private DecisionType parseDecisionType(String val) {
        DecisionType dt = DecisionType.valueOf(val);
        if (dt != null) {
            return dt;
        }
        throw new IllegalXMLException("Unknown decision type: " + val);
    }

    Evidence evidenceFromXml(DOMCursor c, Authenticity authenticity) throws Exception {
        c = c.cloneCursor();
        ArrayList<Assertion> assertionList = new ArrayList<Assertion>();
        ArrayList<IDReferenceType> refList = new ArrayList<IDReferenceType>();
        this.moveToRequiredFirstChild(c);
        boolean more = true;
        boolean any = false;
        while (more) {
            if (c.atElement(ASSERTION_NAMESPACE, TAG_AssertionIDReference)) {
                refList.add(new IDReferenceType(this.getText(c)));
                more = c.moveToSibling(1);
                any = true;
                continue;
            }
            if (c.atElement(ASSERTION_NAMESPACE, TAG_Assertion)) {
                assertionList.add(this.assertionFromXml(c, authenticity, false));
                more = c.moveToSibling(1);
                any = true;
                continue;
            }
            more = false;
        }
        Assertion[] assertions = null;
        if (assertionList.size() > 0) {
            assertions = new Assertion[assertionList.size()];
            assertionList.toArray(assertions);
        }
        IDReferenceType[] refs = null;
        if (refList.size() > 0) {
            refs = new IDReferenceType[refList.size()];
            refList.toArray(assertions);
        }
        if (!any) {
            throw new IllegalXMLException("Evidence must have at least one Assertion or AssertionIDReference");
        }
        return new Evidence(assertions, refs);
    }

    DOMWriteCursor evidenceToXml(DOMWriteCursor c, Evidence obj) throws Exception {
        Assertion[] assertions;
        c = c.addUnder(ASSERTION_NAMESPACE, ASSERTION_PREFIX, TAG_Evidence);
        IDReferenceType[] idRefs = obj.getAssertionIDReferences();
        if (idRefs != null) {
            int i = 0;
            while (i < idRefs.length) {
                DOMWriteCursor c2 = c.addUnder(ASSERTION_NAMESPACE, ASSERTION_PREFIX, TAG_AssertionIDReference);
                c2.setText(idRefs[i].toString());
                ++i;
            }
        }
        if ((assertions = obj.getAssertions()) != null) {
            int i = 0;
            while (i < assertions.length) {
                this.assertionToXml(c, assertions[i]);
                ++i;
            }
        }
        return c;
    }

    private NameIdentifier nameIdentifierFromXml(DOMCursor c) throws Exception {
        String nameQualifier = this.getAttr(c, TAG_NameQualifier, null);
        String format = this.getURIAttr(c, TAG_Format, null);
        String value = this.getText(c);
        return new NameIdentifier(value, nameQualifier, format);
    }

    private DOMWriteCursor nameIdentifierToXml(DOMWriteCursor c, NameIdentifier obj) throws Exception {
        String format;
        c = c.addUnder(ASSERTION_NAMESPACE, ASSERTION_PREFIX, TAG_NameIdentifier);
        String nameQualifier = obj.getNameQualifier();
        if (nameQualifier != null) {
            c.setAttribute(TAG_NameQualifier, nameQualifier);
        }
        if ((format = obj.getFormat()) != null) {
            c.setAttribute(TAG_Format, format.toString());
        }
        c.setText(obj.getValue());
        return c;
    }

    private SubjectConfirmation subjectConfirmationFromXml(DOMCursor c) throws Exception {
        c = c.cloneCursor();
        ArrayList<String> list = new ArrayList<String>();
        this.moveToRequiredFirstChild(c);
        this.checkElem(c, ASSERTION_NAMESPACE, ASSERTION_PREFIX, TAG_ConfirmationMethod);
        boolean more = true;
        while (more && c.atElement(ASSERTION_NAMESPACE, TAG_ConfirmationMethod)) {
            list.add(this.getURIText(c));
            more = c.moveToSibling(1);
        }
        String[] methods = new String[list.size()];
        list.toArray(methods);
        String data = null;
        if (c.atElement(ASSERTION_NAMESPACE, TAG_SubjectConfirmationData)) {
            data = this.getText(c);
            more = c.moveToSibling(1);
        }
        KeyInfo keyInfo = null;
        return new SubjectConfirmation(methods, keyInfo, data);
    }

    private DOMWriteCursor subjectConfirmationToXml(DOMWriteCursor c, SubjectConfirmation obj) throws Exception {
        KeyInfo keyInfo;
        c = c.addUnder(ASSERTION_NAMESPACE, ASSERTION_PREFIX, TAG_SubjectConfirmation);
        String[] methods = obj.getConfirmationMethods();
        int i = 0;
        while (i < methods.length) {
            DOMWriteCursor c2 = c.addUnder(ASSERTION_NAMESPACE, ASSERTION_PREFIX, TAG_ConfirmationMethod);
            c2.setText(methods[i].toString());
            ++i;
        }
        Object data = obj.getSubjectConfirmationData();
        if (data != null) {
            DOMWriteCursor c2 = c.addUnder(ASSERTION_NAMESPACE, ASSERTION_PREFIX, TAG_SubjectConfirmationData);
            c2.setText(data.toString());
        }
        if ((keyInfo = obj.getKeyInfo()) != null) {
            // empty if block
        }
        return c;
    }

    Action[] actionsFromXml(DOMCursor c) throws Exception {
        this.moveToRequiredNextSibling(c);
        this.checkElem(c, ASSERTION_NAMESPACE, ASSERTION_PREFIX, TAG_Action);
        ArrayList<Action> list = new ArrayList<Action>();
        boolean more = true;
        while (more && c.atElement(ASSERTION_NAMESPACE, TAG_Action)) {
            list.add(this.actionFromXml(c));
            more = c.moveToSibling(1);
        }
        Action[] actions = new Action[list.size()];
        list.toArray(actions);
        return actions;
    }

    void actionsToXml(DOMWriteCursor c, Action[] actions) throws Exception {
        int i = 0;
        while (i < actions.length) {
            this.actionToXml(c, actions[i]);
            ++i;
        }
    }

    private Action actionFromXml(DOMCursor c) throws Exception {
        String data = this.getText(c);
        String ns = this.getURIAttr(c, TAG_Namespace, null);
        return new Action(data, ns);
    }

    private DOMWriteCursor actionToXml(DOMWriteCursor c, Action obj) throws Exception {
        c = c.addUnder(ASSERTION_NAMESPACE, ASSERTION_PREFIX, TAG_Action);
        c.setText(obj.getData());
        String ns = obj.getNamespace();
        if (ns != null) {
            c.setAttribute(TAG_Namespace, ns.toString());
        }
        return c;
    }

    void checkElem(DOMCursor c, String namespace, String prefix, String name) {
        if (!c.atElement(namespace, name)) {
            throw new IllegalXMLException("Expected element [" + prefix + ':' + name + "] but found " + c);
        }
    }

    void moveToRequiredFirstChild(DOMCursor c) {
        if (!c.moveToChild(1)) {
            throw new IllegalXMLException("Expected child element under " + c);
        }
    }

    void moveToRequiredNextSibling(DOMCursor c) {
        if (!c.moveToSibling(1)) {
            throw new IllegalXMLException("Expected sibling element after " + c);
        }
    }

    Date getISODateTimeAttr(DOMCursor c, String name) {
        Date val = this.getISODateTimeAttr(c, name, null);
        if (val == null) {
            throw this.missingAttr(c, name);
        }
        return val;
    }

    Date getISODateTimeAttr(DOMCursor c, String name, Date defVal) {
        String val = this.getAttr(c, name, null);
        if (val == null) {
            return defVal;
        }
        try {
            return DateTime.parseISODateTime(val);
        }
        catch (ParseException e) {
            throw this.illegalAttr(c, name, e);
        }
    }

    int getIntAttr(DOMCursor c, String name) {
        String val = this.getAttr(c, name);
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            throw this.illegalAttr(c, name, e);
        }
    }

    IllegalXMLException illegalText(DOMCursor c, Exception e) {
        throw new IllegalXMLException("Illegal text at " + c + ": " + e);
    }

    IllegalXMLException illegalAttr(DOMCursor c, String name, Exception e) {
        throw new IllegalXMLException("Illegal attribute [" + name + "] at " + c + ": " + e);
    }

    IllegalXMLException missingAttr(DOMCursor c, String name) {
        throw new IllegalXMLException("Missing attribute [" + name + "] at " + c);
    }

    String getAttr(DOMCursor c, String name) {
        String val = this.getAttr(c, name, null);
        if (val == null) {
            throw this.missingAttr(c, name);
        }
        return val;
    }

    String getAttr(DOMCursor c, String name, String defVal) {
        String val = c.getAttribute(name);
        if (val == null) {
            return defVal;
        }
        if (val.trim().length() == 0) {
            throw new IllegalXMLException("Empty attribute [" + name + "] at " + c);
        }
        return val;
    }

    String getText(DOMCursor c) {
        String val = this.getText(c, null);
        if (val == null) {
            throw new IllegalXMLException("Missing text at " + c);
        }
        return val;
    }

    String getText(DOMCursor c, String defVal) {
        String val = c.getText();
        if (val.length() == 0) {
            return defVal;
        }
        if (val.trim().length() == 0) {
            throw new IllegalXMLException("Empty text at " + c);
        }
        return val;
    }

    QName getQNameAttr(DOMCursor c, String name) {
        return c.getQNameInContext(this.getAttr(c, name));
    }

    QName getQNameText(DOMCursor c) {
        return c.getQNameInContext(this.getText(c));
    }

    void setQNameAttr(DOMWriteCursor c, String name, QName val) {
        c.setNamespace(val.getNamespacePrefix(), val.getNamespaceURI());
        c.setAttribute(name, val.toString());
    }

    void setQNameText(DOMWriteCursor c, QName val) {
        c.setNamespace(val.getNamespacePrefix(), val.getNamespaceURI());
        c.setText(val.toString());
    }

    String getURIAttr(DOMCursor c, String name) {
        String val = this.getURIAttr(c, name, null);
        if (val == null) {
            throw this.missingAttr(c, name);
        }
        return val;
    }

    String getURIAttr(DOMCursor c, String name, String defVal) {
        String val = c.getAttribute(name);
        if (val != null) {
            return val;
        }
        return defVal;
    }

    String getURIText(DOMCursor c) {
        return this.getText(c);
    }

    DOMCursor cursorFromNode(Node node) {
        if (node.getNodeType() == 9) {
            return new DOMCursor((Document)node);
        }
        if (node.getNodeType() == 1) {
            return new DOMCursor((Element)node);
        }
        throw new IllegalXMLException("must be Document or Element node");
    }

    Authenticity verify(DOMCursor sigCursor, boolean sigPreverified) throws Exception {
        Verifier verifier = new Verifier(sigCursor.getDocument(), sigCursor.createXPath());
        PublicKey key = verifier.getVerifyingKey();
        if (key == null) {
            throw new Exception("signature without a key is not allowed");
        }
        if (!sigPreverified && !verifier.verify(key)) {
            throw new Exception("signature did not verify");
        }
        DOMCursor parentCursor = sigCursor.cloneCursor();
        parentCursor.moveToParent();
        if (!verifier.isReferenced(parentCursor.createXPath())) {
            throw new Exception("signature does not reference the SAML assertion, request or response");
        }
        X509Certificate[] certs = verifier.getCertificateChain();
        if (this.trustVerifier != null) {
            if (certs != null && certs.length > 0) {
                this.trustVerifier.verifyTrust(certs);
            } else {
                this.trustVerifier.verifyTrust(key);
            }
        }
        KeyInfo keyInfo = new KeyInfo();
        if (certs != null && certs.length > 0) {
            keyInfo.setCertificateChain(verifier.getCertificateChain());
        } else {
            keyInfo.setKeyValue(key);
        }
        return new Authenticity(true, keyInfo);
    }

    void sign(DOMCursor parentCursor, Object obj, XPath xpath, boolean insertBefore) throws Exception {
        ToBeSigned toBeSigned;
        SigningKey signingKey;
        if (obj instanceof ToBeSigned && (signingKey = (toBeSigned = (ToBeSigned)obj).getSigningKey()) != null) {
            Signer signer = new Signer(parentCursor.getDocument(), signingKey, toBeSigned.getVerifyingKey());
            DOMCursor topCursor = parentCursor.cloneCursor();
            topCursor.moveToTop();
            if (!parentCursor.equals(topCursor)) {
                signer.addReference(parentCursor.createXPath());
            }
            signer.signInPlace(xpath, insertBefore);
        }
    }

    void performSchemaValidation(Document instance) throws IllegalXMLException, IOException, SchemaLoaderException {
        if (this.schemaValidation) {
            this.loadSchemaValidator();
            String err = schemaValidator.validate(instance);
            if (err != null) {
                throw new IllegalXMLException(err);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSchemaValidator() throws IOException, SchemaLoaderException {
        if (schemaValidator != null) {
            return;
        }
        Class clazz = class$com$verisign$saml$XMLAssertionGenerator == null ? (class$com$verisign$saml$XMLAssertionGenerator = XMLAssertionGenerator.class$("com.verisign.saml.XMLAssertionGenerator")) : class$com$verisign$saml$XMLAssertionGenerator;
        synchronized (clazz) {
            if (schemaValidator != null) {
                return;
            }
            Document[] schemata = new Document[SCHEMA_FILES.length + 1];
            int i = 0;
            while (i < SCHEMA_FILES.length) {
                InputStream is = (class$com$verisign$saml$XMLAssertionGenerator == null ? XMLAssertionGenerator.class$("com.verisign.saml.XMLAssertionGenerator") : class$com$verisign$saml$XMLAssertionGenerator).getResourceAsStream(SCHEMA_FILES[i]);
                InputStreamReader reader = new InputStreamReader(is);
                schemata[i] = xmlres.parseXML(reader);
                reader.close();
                ++i;
            }
            schemata[XMLAssertionGenerator.SCHEMA_FILES.length] = XMLSigSchema.getSchemaDocument();
            schemaValidator = new SchemaValidator(schemata);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        SAML_MAJOR_VERSION = 1;
        SAML_MINOR_VERSION = 0;
        ASSERTION_PREFIX = ASSERTION_PREFIX;
        ASSERTION_NAMESPACE = ASSERTION_NAMESPACE;
        PROTOCOL_PREFIX = PROTOCOL_PREFIX;
        PROTOCOL_NAMESPACE = PROTOCOL_NAMESPACE;
        XMLSIG_PREFIX = XMLSIG_PREFIX;
        XMLSIG_NAMESPACE = XMLSIG_NAMESPACE;
        TAG_Advice = TAG_Advice;
        TAG_Action = TAG_Action;
        TAG_Assertion = TAG_Assertion;
        TAG_AssertionID = TAG_AssertionID;
        TAG_AssertionArtifact = TAG_AssertionArtifact;
        TAG_AssertionIDReference = TAG_AssertionIDReference;
        TAG_Attribute = TAG_Attribute;
        TAG_AttributeDesignator = TAG_AttributeDesignator;
        TAG_AttributeName = TAG_AttributeName;
        TAG_AttributeNamespace = TAG_AttributeNamespace;
        TAG_AttributeQuery = TAG_AttributeQuery;
        TAG_AttributeStatement = TAG_AttributeStatement;
        TAG_AttributeValue = TAG_AttributeValue;
        TAG_Audience = TAG_Audience;
        TAG_AudienceRestrictionCondition = TAG_AudienceRestrictionCondition;
        TAG_AuthenticationInstant = TAG_AuthenticationInstant;
        TAG_AuthenticationMethod = TAG_AuthenticationMethod;
        TAG_AuthenticationQuery = TAG_AuthenticationQuery;
        TAG_AuthenticationStatement = TAG_AuthenticationStatement;
        TAG_AuthorityBinding = TAG_AuthorityBinding;
        TAG_AuthorityKind = TAG_AuthorityKind;
        TAG_AuthorizationDecisionQuery = TAG_AuthorizationDecisionQuery;
        TAG_AuthorizationDecisionStatement = TAG_AuthorizationDecisionStatement;
        TAG_Binding = TAG_Binding;
        TAG_Condition = TAG_Condition;
        TAG_Conditions = TAG_Conditions;
        TAG_ConfirmationMethod = TAG_ConfirmationMethod;
        TAG_Decision = TAG_Decision;
        TAG_DNSAddress = TAG_DNSAddress;
        TAG_Evidence = TAG_Evidence;
        TAG_Format = TAG_Format;
        TAG_InResponseTo = TAG_InResponseTo;
        TAG_IPAddress = TAG_IPAddress;
        TAG_IssueInstant = TAG_IssueInstant;
        TAG_Issuer = TAG_Issuer;
        TAG_Location = TAG_Location;
        TAG_MajorVersion = TAG_MajorVersion;
        TAG_MinorVersion = TAG_MinorVersion;
        TAG_NameIdentifier = TAG_NameIdentifier;
        TAG_NameQualifier = TAG_NameQualifier;
        TAG_Namespace = TAG_Namespace;
        TAG_NotBefore = TAG_NotBefore;
        TAG_NotOnOrAfter = TAG_NotOnOrAfter;
        TAG_Recipient = TAG_Recipient;
        TAG_Request = TAG_Request;
        TAG_RequestID = TAG_RequestID;
        TAG_Resource = TAG_Resource;
        TAG_RespondWith = TAG_RespondWith;
        TAG_Response = TAG_Response;
        TAG_ResponseID = TAG_ResponseID;
        TAG_Signature = TAG_Signature;
        TAG_Status = TAG_Status;
        TAG_StatusCode = TAG_StatusCode;
        TAG_StatusDetail = TAG_StatusDetail;
        TAG_StatusMessage = TAG_StatusMessage;
        TAG_Subject = TAG_Subject;
        TAG_SubjectConfirmation = TAG_SubjectConfirmation;
        TAG_SubjectConfirmationData = TAG_SubjectConfirmationData;
        TAG_SubjectLocality = TAG_SubjectLocality;
        TAG_SubjectStatement = TAG_SubjectStatement;
        TAG_Value = TAG_Value;
        ATTR_STATEMENT_QNAME = new QName[]{new QName(ASSERTION_NAMESPACE, ASSERTION_PREFIX, TAG_AttributeStatement)};
        AUTHN_STATEMENT_QNAME = new QName[]{new QName(ASSERTION_NAMESPACE, ASSERTION_PREFIX, TAG_AuthenticationStatement)};
        AUTHZ_STATEMENT_QNAME = new QName[]{new QName(ASSERTION_NAMESPACE, ASSERTION_PREFIX, TAG_AuthorizationDecisionQuery)};
        SCHEMA_FILES = new String[]{"cs-sstc-schema-assertion-01.xsd", "cs-sstc-schema-protocol-01.xsd"};
    }
}

