/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.saml;

import com.verisign.saml.SOAPAssertionProvider;
import com.verisign.saml.XMLSecurityParameters;
import com.verisign.saml.authorities.AssertionProvider;
import com.verisign.saml.authorities.AssertionProviderFactory;
import com.verisign.saml.authorities.AttributeStatementProvider;
import com.verisign.saml.authorities.AuthNStatementProvider;
import com.verisign.saml.authorities.AuthZDecisionStatementProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import org.xmltrustcenter.verifier.AllPermissiveTrustVerifier;
import org.xmltrustcenter.verifier.TrustVerifier;
import org.xmltrustcenter.verifier.X509TrustVerifier;

public class SOAPAssertionProviderFactory
extends XMLSecurityParameters
implements AssertionProviderFactory {
    private static TrustVerifier defaultTrustVerifier;
    private URL serviceURL;
    private PrintStream messageLog;
    static /* synthetic */ Class class$com$verisign$saml$SOAPAssertionProviderFactory;

    public SOAPAssertionProviderFactory(URL serviceURL) throws Exception {
        this.initDefaultVerifier();
        this.serviceURL = serviceURL;
        this.trustVerifier = defaultTrustVerifier;
    }

    private void initDefaultVerifier() throws KeyStoreException, GeneralSecurityException, IOException {
        if (defaultTrustVerifier == null) {
            if (Boolean.getBoolean("com.verisign.saml.skipTrustCheck")) {
                System.err.println("***************** WARNING ******************");
                System.err.println("SAML message signer trust checking disabled!");
                System.err.println("***************** WARNING ******************");
                defaultTrustVerifier = new AllPermissiveTrustVerifier();
            } else {
                Class cl = class$com$verisign$saml$SOAPAssertionProviderFactory == null ? (class$com$verisign$saml$SOAPAssertionProviderFactory = SOAPAssertionProviderFactory.class$("com.verisign.saml.SOAPAssertionProviderFactory")) : class$com$verisign$saml$SOAPAssertionProviderFactory;
                KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
                InputStream is = cl.getResourceAsStream("trustpoints.pilot");
                if (is == null) {
                    is = cl.getResourceAsStream("trustpoints.prod");
                }
                if (is == null) {
                    throw new IOException("Resource not found: com/verisign/saml/trustpoints.prod");
                }
                ks.load(is, null);
                defaultTrustVerifier = new X509TrustVerifier(ks);
            }
        }
    }

    public URL getURL() {
        return this.serviceURL;
    }

    public PrintStream getMessageLog() {
        return this.messageLog;
    }

    public void setMessageLog(PrintStream messageLog) {
        this.messageLog = messageLog;
    }

    public AssertionProvider newAssertionProvider() throws Exception {
        return this.newProvider();
    }

    public AttributeStatementProvider newAttributeStatementProvider() throws Exception {
        return this.newProvider();
    }

    public AuthNStatementProvider newAuthNStatementProvider() throws Exception {
        return this.newProvider();
    }

    public AuthZDecisionStatementProvider newAuthZDecisionStatementProvider() throws Exception {
        return this.newProvider();
    }

    private SOAPAssertionProvider newProvider() throws Exception {
        return new SOAPAssertionProvider(this.serviceURL, this.signingKey, this.verifyingKey, this.trustVerifier, this.defaultAuthenticity, this.isTopSignatureVerified, this.schemaValidation, this.messageLog);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

