/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.saml;

import com.verisign.messaging.SOAPFault;
import com.verisign.messaging.SimpleRequest;
import com.verisign.messaging.XmlResponse;
import com.verisign.messaging.XmlTransportSOAP;
import com.verisign.saml.XMLAssertionGenerator;
import com.verisign.saml.XMLRequestGenerator;
import com.verisign.saml.XMLResponseGenerator;
import com.verisign.saml.assertions.Assertion;
import com.verisign.saml.assertions.AttributeStatement;
import com.verisign.saml.assertions.AuthNStatement;
import com.verisign.saml.assertions.AuthZDecisionStatement;
import com.verisign.saml.assertions.Authenticity;
import com.verisign.saml.assertions.IDReferenceType;
import com.verisign.saml.assertions.Statement;
import com.verisign.saml.authorities.AssertionProvider;
import com.verisign.saml.authorities.AttributeStatementProvider;
import com.verisign.saml.authorities.AuthNStatementProvider;
import com.verisign.saml.authorities.AuthZDecisionStatementProvider;
import com.verisign.saml.authorities.RequestGenerator;
import com.verisign.saml.authorities.ResponseGenerator;
import com.verisign.saml.protocol.AttributeQuery;
import com.verisign.saml.protocol.AuthNQuery;
import com.verisign.saml.protocol.AuthZDecisionQuery;
import com.verisign.saml.protocol.Query;
import com.verisign.saml.protocol.Request;
import com.verisign.saml.protocol.Response;
import com.verisign.saml.protocol.StatusCode;
import com.verisign.xmlsig.SigningKey;
import com.verisign.xmlsig.VerifyingKey;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.xmltrustcenter.verifier.TrustVerifier;

class SOAPAssertionProvider
implements AssertionProvider,
AttributeStatementProvider,
AuthNStatementProvider,
AuthZDecisionStatementProvider {
    private XmlTransportSOAP transport;
    private RequestGenerator requestGenerator;
    private ResponseGenerator responseGenerator;

    SOAPAssertionProvider(URL url, SigningKey signingKey, VerifyingKey verifyingKey, TrustVerifier trustVerifier, Authenticity defaultAuthenticity, boolean isTopSignatureVerified, boolean schemaValidation, PrintStream messageLog) {
        this.transport = new XmlTransportSOAP(url);
        if (messageLog != null) {
            this.transport.setLogOutput(messageLog);
        }
        this.requestGenerator = new XMLRequestGenerator(signingKey, verifyingKey, trustVerifier, defaultAuthenticity, isTopSignatureVerified, schemaValidation);
        this.responseGenerator = new XMLResponseGenerator(signingKey, verifyingKey, trustVerifier, defaultAuthenticity, isTopSignatureVerified, schemaValidation);
    }

    public Assertion[] provideAssertion(Query query) throws Exception {
        return this.sendRequest(this.requestGenerator.createRequest(query));
    }

    public Assertion[] provideAssertion(IDReferenceType[] idRefs) throws Exception {
        return this.sendRequest(this.requestGenerator.createRequest(idRefs));
    }

    public Assertion[] provideAssertion(String[] artifacts) throws Exception {
        return this.sendRequest(this.requestGenerator.createRequest(artifacts));
    }

    public AttributeStatement[] processAttributeQuery(AttributeQuery query) throws Exception {
        Statement[] statements;
        ArrayList<AttributeStatement> list = new ArrayList<AttributeStatement>();
        Assertion[] assertions = this.sendRequest(this.requestGenerator.createRequest(XMLAssertionGenerator.ATTR_STATEMENT_QNAME, query));
        int i = 0;
        while (i < assertions.length) {
            statements = assertions[i].getStatements();
            int j = 0;
            while (j < statements.length) {
                if (statements[j] instanceof AttributeStatement) {
                    list.add((AttributeStatement)statements[j]);
                }
                ++j;
            }
            ++i;
        }
        statements = new AttributeStatement[list.size()];
        list.toArray(statements);
        return statements;
    }

    public AuthNStatement[] processAuthNQuery(AuthNQuery query) throws Exception {
        Statement[] statements;
        ArrayList<AuthNStatement> list = new ArrayList<AuthNStatement>();
        Assertion[] assertions = this.sendRequest(this.requestGenerator.createRequest(XMLAssertionGenerator.AUTHN_STATEMENT_QNAME, query));
        int i = 0;
        while (i < assertions.length) {
            statements = assertions[i].getStatements();
            int j = 0;
            while (j < statements.length) {
                if (statements[j] instanceof AuthNStatement) {
                    list.add((AuthNStatement)statements[j]);
                }
                ++j;
            }
            ++i;
        }
        statements = new AuthNStatement[list.size()];
        list.toArray(statements);
        return statements;
    }

    public AuthZDecisionStatement[] processAuthZDecisionQuery(AuthZDecisionQuery query) throws Exception {
        Statement[] statements;
        ArrayList<AuthZDecisionStatement> list = new ArrayList<AuthZDecisionStatement>();
        Assertion[] assertions = this.sendRequest(this.requestGenerator.createRequest(XMLAssertionGenerator.AUTHZ_STATEMENT_QNAME, query));
        int i = 0;
        while (i < assertions.length) {
            statements = assertions[i].getStatements();
            int j = 0;
            while (j < statements.length) {
                if (statements[j] instanceof AuthZDecisionStatement) {
                    list.add((AuthZDecisionStatement)statements[j]);
                }
                ++j;
            }
            ++i;
        }
        statements = new AuthZDecisionStatement[list.size()];
        list.toArray(statements);
        return statements;
    }

    private Assertion[] sendRequest(Request request) throws Exception {
        Document requestBody = this.requestGenerator.requestToXML(request);
        SimpleRequest simpleRequest = new SimpleRequest(requestBody);
        XmlResponse xmlResponse = this.transport.sendRequest(simpleRequest);
        Document responseBody = xmlResponse.getXML();
        SOAPFault fault = this.transport.getSOAPResponseFault();
        if (fault != null) {
            throw new Exception("SOAP fault: " + fault);
        }
        Response response = this.responseGenerator.createResponse(responseBody);
        StatusCode statusCode = response.getStatus().getStatusCode();
        if (!StatusCode.Success.getValue().equals(statusCode.getValue())) {
            throw new Exception("Failure: " + statusCode);
        }
        return response.getAssertions();
    }
}

