/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.saml;

import com.verisign.datatypes.QName;
import com.verisign.saml.BaseResponseImpl;
import com.verisign.saml.ToBeSigned;
import com.verisign.saml.assertions.Assertion;
import com.verisign.saml.assertions.Authenticity;
import com.verisign.saml.assertions.IDReferenceType;
import com.verisign.saml.assertions.IDType;
import com.verisign.saml.protocol.Response;
import com.verisign.saml.protocol.Status;
import com.verisign.saml.protocol.StatusCode;
import com.verisign.xmlsig.SigningKey;
import com.verisign.xmlsig.VerifyingKey;
import java.util.Date;

class ResponseImpl
extends BaseResponseImpl
implements Response,
ToBeSigned {
    private Status status;
    private Assertion[] assertions;
    private SigningKey signingKey;
    private VerifyingKey verifyingKey;

    ResponseImpl(int majorVersion, int minorVersion, Date issueInstant, IDType responseID, IDReferenceType inResponseTo, String recipient, Status status, Assertion[] assertions, Authenticity authenticity, SigningKey signingKey, VerifyingKey verifyingKey) {
        super(majorVersion, minorVersion, issueInstant, responseID, inResponseTo, recipient, authenticity);
        this.status = status;
        this.assertions = assertions;
        this.signingKey = signingKey;
        this.verifyingKey = verifyingKey;
        this.checkStatusCode();
    }

    ResponseImpl(IDReferenceType inResponseTo, String recipient, Status status, Assertion[] assertions, Authenticity authenticity, SigningKey signingKey, VerifyingKey verifyingKey) {
        super(inResponseTo, recipient, authenticity);
        this.status = status;
        this.assertions = assertions;
        this.signingKey = signingKey;
        this.verifyingKey = verifyingKey;
        this.checkStatusCode();
    }

    private void checkStatusCode() {
        QName val = this.status.getStatusCode().getValue();
        if (val.equals(StatusCode.Success.getValue()) || val.equals(StatusCode.VersionMismatch.getValue()) || val.equals(StatusCode.Requester.getValue()) || val.equals(StatusCode.Responder.getValue())) {
            return;
        }
        throw new IllegalArgumentException("Top level status must be Success, VersionMismatch, Requester, or Responder");
    }

    public Status getStatus() {
        return this.status;
    }

    public Assertion[] getAssertions() {
        return this.assertions;
    }

    public boolean isVersionHigher(Response otherResponse) {
        return otherResponse.getMajorVersion() > this.getMajorVersion() || otherResponse.getMajorVersion() == this.getMajorVersion() && otherResponse.getMinorVersion() > this.getMinorVersion();
    }

    public SigningKey getSigningKey() {
        return this.signingKey;
    }

    public VerifyingKey getVerifyingKey() {
        return this.verifyingKey;
    }
}

