/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.saml;

import com.verisign.datatypes.QName;
import com.verisign.saml.BaseRequestImpl;
import com.verisign.saml.ToBeSigned;
import com.verisign.saml.assertions.Authenticity;
import com.verisign.saml.assertions.IDReferenceType;
import com.verisign.saml.assertions.IDType;
import com.verisign.saml.protocol.Query;
import com.verisign.saml.protocol.Request;
import com.verisign.xmlsig.SigningKey;
import com.verisign.xmlsig.VerifyingKey;
import java.util.Date;

class RequestImpl
extends BaseRequestImpl
implements Request,
ToBeSigned {
    private Query query;
    private String[] artifacts;
    private IDReferenceType[] idRefs;
    private SigningKey signingKey;
    private VerifyingKey verifyingKey;

    RequestImpl(int majorVersion, int minorVersion, Date issueInstant, IDType requestID, QName[] respondWith, Query query, String[] artifacts, IDReferenceType[] idRefs, Authenticity authenticity, SigningKey signingKey, VerifyingKey verifyingKey) {
        super(majorVersion, minorVersion, issueInstant, requestID, respondWith, authenticity);
        this.query = query;
        this.artifacts = artifacts;
        this.idRefs = idRefs;
        this.signingKey = signingKey;
        this.verifyingKey = verifyingKey;
    }

    RequestImpl(QName[] respondWith, Query query, String[] artifacts, IDReferenceType[] idRefs, Authenticity authenticity, SigningKey signingKey, VerifyingKey verifyingKey) {
        super(respondWith, authenticity);
        this.query = query;
        this.artifacts = artifacts;
        this.idRefs = idRefs;
        this.signingKey = signingKey;
        this.verifyingKey = verifyingKey;
    }

    public String[] getAssertionArtifacts() {
        return this.artifacts;
    }

    public Query getQuery() {
        return this.query;
    }

    public IDReferenceType[] getAssertionIDReferences() {
        return this.idRefs;
    }

    public boolean isVersionHigher(Request otherRequest) {
        return otherRequest.getMajorVersion() > this.getMajorVersion() || otherRequest.getMajorVersion() == this.getMajorVersion() && otherRequest.getMinorVersion() > this.getMinorVersion();
    }

    public SigningKey getSigningKey() {
        return this.signingKey;
    }

    public VerifyingKey getVerifyingKey() {
        return this.verifyingKey;
    }
}

