/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.saml;

import com.verisign.saml.XMLAssertionGenerator;
import com.verisign.saml.assertions.Authenticity;
import com.verisign.saml.assertions.IDReferenceType;
import com.verisign.saml.assertions.IDType;
import com.verisign.saml.authorities.IDGenerator;
import com.verisign.saml.protocol.BaseResponse;
import java.util.Date;

class BaseResponseImpl
implements BaseResponse {
    private int majorVersion;
    private int minorVersion;
    private Date issueInstant;
    private IDType responseID;
    private IDReferenceType inResponseTo;
    private String recipient;
    private Authenticity authenticity;

    BaseResponseImpl(int majorVersion, int minorVersion, Date issueInstant, IDType responseID, IDReferenceType inResponseTo, String recipient, Authenticity authenticity) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.issueInstant = issueInstant;
        this.responseID = responseID;
        this.inResponseTo = inResponseTo;
        this.recipient = recipient;
        this.authenticity = authenticity;
    }

    BaseResponseImpl(IDReferenceType inResponseTo, String recipient, Authenticity authenticity) {
        this.majorVersion = 1;
        this.minorVersion = 0;
        this.issueInstant = new Date();
        this.responseID = IDGenerator.getInstance().getNewResponseID();
        this.inResponseTo = inResponseTo;
        this.recipient = recipient;
        this.authenticity = authenticity;
    }

    public IDType getResponseID() {
        return this.responseID;
    }

    public IDReferenceType getInResponseTo() {
        return this.inResponseTo;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public Date getIssueInstant() {
        return this.issueInstant;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public String getSAMLVersion() {
        return XMLAssertionGenerator.formatSAMLVersion(this.majorVersion, this.minorVersion);
    }

    public Authenticity getAuthenticity() {
        return this.authenticity;
    }
}

