/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.saml;

import com.verisign.datatypes.QName;
import com.verisign.saml.XMLAssertionGenerator;
import com.verisign.saml.assertions.Authenticity;
import com.verisign.saml.assertions.IDType;
import com.verisign.saml.authorities.IDGenerator;
import com.verisign.saml.protocol.BaseRequest;
import java.util.Date;

class BaseRequestImpl
implements BaseRequest {
    private int majorVersion;
    private int minorVersion;
    private Date issueInstant;
    private IDType requestID;
    private QName[] respondWith;
    private Authenticity authenticity;

    BaseRequestImpl(int majorVersion, int minorVersion, Date issueInstant, IDType requestID, QName[] respondWith, Authenticity authenticity) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.issueInstant = issueInstant;
        this.requestID = requestID;
        this.respondWith = respondWith;
        this.authenticity = authenticity;
    }

    BaseRequestImpl(QName[] respondWith, Authenticity authenticity) {
        this.majorVersion = 1;
        this.minorVersion = 0;
        this.issueInstant = new Date();
        this.requestID = IDGenerator.getInstance().getNewRequestID();
        this.respondWith = respondWith;
        this.authenticity = authenticity;
    }

    public IDType getRequestID() {
        return this.requestID;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public Date getIssueInstant() {
        return this.issueInstant;
    }

    public QName[] getRespondWith() {
        return this.respondWith;
    }

    public String getSAMLVersion() {
        return XMLAssertionGenerator.formatSAMLVersion(this.majorVersion, this.minorVersion);
    }

    public Authenticity getAuthenticity() {
        return this.authenticity;
    }
}

