/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.saml;

import com.verisign.saml.ToBeSigned;
import com.verisign.saml.XMLAssertionGenerator;
import com.verisign.saml.assertions.Advice;
import com.verisign.saml.assertions.Assertion;
import com.verisign.saml.assertions.Authenticity;
import com.verisign.saml.assertions.Conditions;
import com.verisign.saml.assertions.IDType;
import com.verisign.saml.assertions.Statement;
import com.verisign.saml.authorities.IDGenerator;
import com.verisign.xmlsig.SigningKey;
import com.verisign.xmlsig.VerifyingKey;
import java.util.Date;

class AssertionImpl
implements Assertion,
ToBeSigned {
    private int majorVersion;
    private int minorVersion;
    private Date issueInstant;
    private IDType assertionID;
    private String issuer;
    private Advice advice;
    private Conditions conditions;
    private Statement[] statements;
    private Authenticity authenticity;
    private SigningKey signingKey;
    private VerifyingKey verifyingKey;

    AssertionImpl(int majorVersion, int minorVersion, Date issueInstant, IDType assertionID, String issuer, Advice advice, Conditions conditions, Statement[] statements, Authenticity authenticity, SigningKey signingKey, VerifyingKey verifyingKey) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.issueInstant = issueInstant;
        this.assertionID = assertionID;
        this.issuer = issuer;
        this.advice = advice;
        this.conditions = conditions;
        this.statements = statements;
        this.authenticity = authenticity;
        this.signingKey = signingKey;
        this.verifyingKey = verifyingKey;
    }

    AssertionImpl(Date issueInstant, IDType assertionID, String issuer, Advice advice, Conditions conditions, Statement[] statements, Authenticity authenticity, SigningKey signingKey, VerifyingKey verifyingKey) {
        this(1, 0, issueInstant, assertionID, issuer, advice, conditions, statements, authenticity, signingKey, verifyingKey);
    }

    AssertionImpl(String issuer, Advice advice, Conditions conditions, Statement[] statements, Authenticity authenticity, SigningKey signingKey, VerifyingKey verifyingKey) {
        this(new Date(), IDGenerator.getInstance().getNewAssertionID(), issuer, advice, conditions, statements, authenticity, signingKey, verifyingKey);
    }

    public IDType getAssertionID() {
        return this.assertionID;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public Date getIssueInstant() {
        return this.issueInstant;
    }

    public String getSAMLVersion() {
        return XMLAssertionGenerator.formatSAMLVersion(this.majorVersion, this.minorVersion);
    }

    public boolean isVersionHigher(Assertion otherAssertion) {
        return otherAssertion.getMajorVersion() > this.getMajorVersion() || otherAssertion.getMajorVersion() == this.getMajorVersion() && otherAssertion.getMinorVersion() > this.getMinorVersion();
    }

    public String getVersion() {
        return XMLAssertionGenerator.formatSAMLVersion(this.majorVersion, this.minorVersion);
    }

    public String getIssuer() {
        return this.issuer;
    }

    public Advice getAdvice() {
        return this.advice;
    }

    public Conditions getConditions() {
        return this.conditions;
    }

    public Statement[] getStatements() {
        return this.statements;
    }

    public Authenticity getAuthenticity() {
        return this.authenticity;
    }

    public SigningKey getSigningKey() {
        return this.signingKey;
    }

    public VerifyingKey getVerifyingKey() {
        return this.verifyingKey;
    }
}

