/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.resource;

import com.verisign.resource.DOMSerialization;
import com.verisign.resource.GenericDOMWriter;
import com.verisign.resource.XMLResource;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.EmptyStackException;
import java.util.Hashtable;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

class JaxpXmlResource
implements XMLResource {
    Stack parsers = new Stack();
    static final Hashtable XML_CONTROL_CHARS = new Hashtable();
    static final String[][] XML_CONTROL_CHARS_PAIRS = new String[][]{{"amp;", "&"}, {"lt;", "<"}, {"gt;", ">"}};

    private DocumentBuilder getBuilder() {
        try {
            return (DocumentBuilder)this.parsers.pop();
        }
        catch (EmptyStackException ese) {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                dbf.setValidating(false);
                dbf.setExpandEntityReferences(true);
                DocumentBuilder db = dbf.newDocumentBuilder();
                if (!db.isNamespaceAware()) {
                    String s = "JAXP XML engine is not namespace aware";
                    throw new UnsupportedOperationException(s);
                }
                db.setEntityResolver(new EntityResolver(){

                    public InputSource resolveEntity(String publicId, String systemId) {
                        return new InputSource(new StringReader(""));
                    }
                });
                return db;
            }
            catch (ParserConfigurationException pce) {
                return null;
            }
        }
    }

    private synchronized void releaseBuilder(DocumentBuilder builder) {
        this.parsers.push(builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document createDocument() {
        DocumentBuilder builder = this.getBuilder();
        try {
            Document document = builder.newDocument();
            Object var4_3 = null;
            if (builder != null) {
                this.releaseBuilder(builder);
            }
            return document;
        }
        catch (Throwable throwable) {
            block3: {
                Object var4_4 = null;
                if (builder == null) break block3;
                this.releaseBuilder(builder);
            }
            throw throwable;
        }
    }

    public Node cloneWithOwner(Document doc, Node copySource, boolean deep) {
        return doc.importNode(copySource, deep);
    }

    public Document parseXML(InputStream is) throws IOException {
        return this.parseXML(is, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document parseXML(InputStream is, boolean normalize) throws IOException {
        DocumentBuilder builder = this.getBuilder();
        try {
            try {
                Document ret = builder.parse(new InputSource(is));
                if (normalize) {
                    ret.getDocumentElement().normalize();
                    this.fixTextNodes(ret);
                }
                Document document = ret;
                Object var7_7 = null;
                if (builder == null) return document;
                this.releaseBuilder(builder);
                return document;
            }
            catch (SAXException sa) {
                throw new IOException(sa.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (builder == null) throw throwable;
            this.releaseBuilder(builder);
            throw throwable;
        }
    }

    public Document parseXML(Reader reader) throws IOException {
        return this.parseXML(reader, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document parseXML(Reader reader, boolean normalize) throws IOException {
        DocumentBuilder builder = this.getBuilder();
        try {
            try {
                Document ret = builder.parse(new InputSource(reader));
                if (normalize) {
                    ret.getDocumentElement().normalize();
                    this.fixTextNodes(ret);
                }
                Document document = ret;
                Object var7_7 = null;
                if (builder == null) return document;
                this.releaseBuilder(builder);
                return document;
            }
            catch (SAXException sa) {
                throw new IOException(sa.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (builder == null) throw throwable;
            this.releaseBuilder(builder);
            throw throwable;
        }
    }

    private void fixTextNodes(Node node) {
        String value;
        if (node.getNodeType() == 3 && (value = node.getNodeValue()).trim().length() == 0) {
            node.getParentNode().removeChild(node);
            return;
        }
        NodeList children = node.getChildNodes();
        if (children != null) {
            int len = children.getLength();
            int i = len - 1;
            while (i >= 0) {
                this.fixTextNodes(children.item(i));
                --i;
            }
        }
    }

    public Parser getSAXParser() throws IOException {
        return null;
    }

    public void publish(Document doc, OutputStream out) throws IOException {
        GenericDOMWriter publisher = new GenericDOMWriter(out, true);
        publisher.print(doc);
    }

    public void publish(Document doc, Writer writer) throws IOException {
        GenericDOMWriter publisher = new GenericDOMWriter(writer, true);
        publisher.print(doc);
    }

    public void publish(Node doc, OutputStream out) throws IOException {
        GenericDOMWriter publisher = new GenericDOMWriter(out, true);
        publisher.print(doc);
    }

    public void publish(Node doc, Writer writer) throws IOException {
        GenericDOMWriter publisher = new GenericDOMWriter(writer, true);
        publisher.print(doc);
    }

    public void publish(Document doc, OutputStream out, int format) throws IOException {
        boolean compact = format == 0 || format == 2;
        GenericDOMWriter publisher = new GenericDOMWriter(out, compact);
        if (format == 2 || format == 3) {
            publisher.setHTML(true);
        }
        publisher.print(doc);
    }

    public void publish(Document doc, Writer writer, int format) throws IOException {
        boolean compact = format == 0 || format == 2;
        GenericDOMWriter publisher = new GenericDOMWriter(writer, compact);
        if (format == 2 || format == 3) {
            publisher.setHTML(true);
        }
        publisher.print(doc);
    }

    public void publish(Node doc, OutputStream out, int format) throws IOException {
        boolean compact = format == 0 || format == 2;
        GenericDOMWriter publisher = new GenericDOMWriter(out, compact);
        if (format == 2 || format == 3) {
            publisher.setHTML(true);
        }
        publisher.print(doc);
    }

    public void publish(Node doc, Writer writer, int format) throws IOException {
        boolean compact = format == 0 || format == 2;
        GenericDOMWriter publisher = new GenericDOMWriter(writer, compact);
        if (format == 2 || format == 3) {
            publisher.setHTML(true);
        }
        publisher.print(doc);
    }

    public void serialize(Node node, OutputStream out) throws IOException {
        new DOMSerialization().serialize(node, out);
    }

    public void serialize(Node node, DataOutput writer) throws IOException {
        new DOMSerialization().serialize(node, writer);
    }

    public Node deSerialize(InputStream in) throws IOException {
        return new DOMSerialization().deSerialize(in);
    }

    public Node deSerialize(DataInput in) throws IOException {
        return new DOMSerialization().deSerialize(in);
    }

    public InputStream getSerializationStream(Node node) throws IOException {
        return new DOMSerialization().getSerializationStream(node);
    }

    static {
        int i = 0;
        while (i < XML_CONTROL_CHARS_PAIRS.length) {
            XML_CONTROL_CHARS.put(XML_CONTROL_CHARS_PAIRS[i][0], XML_CONTROL_CHARS_PAIRS[i][1]);
            ++i;
        }
    }
}

