/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.resource;

import com.verisign.domutil.DOMCursor;
import com.verisign.domutil.DOMWriteCursor;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Comparator;
import org.w3c.dom.Attr;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class GenericDOMWriter {
    private static final int INDENT_PER_LEVEL = 4;
    private static final int RIGHT_MARGIN = 78;
    private static final String WHITESPACE = "                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               ";
    private static final String DEFAULT_PARSER_NAME = "dom.wrappers.DOMParser";
    private static String PRINTWRITER_ENCODING;
    private static String[] MIME2JAVA_ENCODINGS;
    protected PrintWriter out;
    protected boolean canonical;
    protected boolean compact;
    protected boolean isHTML = false;

    public GenericDOMWriter(OutputStream output, boolean compact) throws UnsupportedEncodingException {
        this.compact = compact;
        this.out = new PrintWriter(new OutputStreamWriter(output));
        this.canonical = false;
    }

    public GenericDOMWriter(Writer output, boolean compact) throws UnsupportedEncodingException {
        this.compact = compact;
        this.out = new PrintWriter(output);
        this.canonical = false;
    }

    public GenericDOMWriter(String encoding, boolean canonical, boolean compact) throws UnsupportedEncodingException {
        this.compact = compact;
        this.out = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, encoding));
        this.canonical = canonical;
    }

    public GenericDOMWriter(boolean canonical, boolean compact) throws UnsupportedEncodingException {
        this(GenericDOMWriter.getWriterEncoding(), canonical, compact);
    }

    public void setHTML(boolean b) {
        this.isHTML = b;
    }

    public static String getWriterEncoding() {
        return PRINTWRITER_ENCODING;
    }

    public static void setWriterEncoding(String encoding) {
        if (encoding.equalsIgnoreCase("DEFAULT") || encoding.equalsIgnoreCase("UTF-8") || encoding.equalsIgnoreCase("UTF8")) {
            PRINTWRITER_ENCODING = "UTF8";
        } else if (encoding.equalsIgnoreCase("UTF-16") || encoding.equalsIgnoreCase("Unicode")) {
            PRINTWRITER_ENCODING = "Unicode";
        } else {
            throw new UnsupportedOperationException(encoding + " not supported");
        }
    }

    public static boolean isValidJavaEncoding(String encoding) {
        int i = 0;
        while (i < MIME2JAVA_ENCODINGS.length) {
            if (encoding.equals(MIME2JAVA_ENCODINGS[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void print(Node node) {
        if (node.getNodeType() == 1 && node != node.getOwnerDocument().getDocumentElement()) {
            DOMWriteCursor wc = new DOMWriteCursor();
            wc.copyUnder(new DOMCursor((Element)node));
            node = wc.getElement();
        }
        this.print(node, 0, true);
        this.out.print("\n");
        this.out.flush();
    }

    public boolean print(Node node, int indent_lvl, boolean can_indent_from_parent) {
        if (node == null) {
            return false;
        }
        short type = node.getNodeType();
        boolean print_end = false;
        boolean ret = false;
        boolean indent_okay = can_indent_from_parent;
        int column = 0;
        int indentColumn = 0;
        switch (type) {
            case 9: {
                if (!this.canonical) {
                    String Encoding2 = GenericDOMWriter.getWriterEncoding();
                    if (Encoding2.equalsIgnoreCase("DEFAULT") || Encoding2.equalsIgnoreCase("UTF8") || Encoding2.equalsIgnoreCase("UTF-8")) {
                        Encoding2 = "UTF-8";
                    } else if (Encoding2.equalsIgnoreCase("Unicode") || Encoding2.equalsIgnoreCase("UTF-16")) {
                        Encoding2 = "UTF-16";
                    } else {
                        throw new UnsupportedOperationException(Encoding2 + " not supported");
                    }
                    if (!this.isHTML) {
                        this.out.println("<?xml version=\"1.0\" encoding=\"" + Encoding2 + "\"?>");
                    }
                }
                boolean firstNode = true;
                Node child = node.getFirstChild();
                while (child != null) {
                    if (!firstNode) {
                        this.out.println();
                    }
                    this.print(child, 0, indent_okay);
                    firstNode = false;
                    child = child.getNextSibling();
                }
                this.out.flush();
                break;
            }
            case 1: {
                boolean compact_orig = this.compact;
                if (!this.compact && indent_okay) {
                    this.out.print("\n");
                    indentColumn = column = 4 * indent_lvl;
                    this.out.print(WHITESPACE.substring(0, column));
                }
                this.out.print('<');
                this.out.print(node.getNodeName());
                indentColumn = column += node.getNodeName().length() + 1;
                Attr[] attrs = this.sortAttributes(node.getAttributes());
                int i = 0;
                while (i < attrs.length) {
                    Attr attr = attrs[i];
                    String attrname = attr.getNodeName();
                    String attrvalue = attr.getNodeValue();
                    String attrString = ' ' + attr.getNodeName() + "=\"" + this.normalize(attr.getNodeValue()) + '\"';
                    if (!this.compact && indent_okay && attrString.length() + column > 78 && i > 0) {
                        this.out.print("\n");
                        column = indentColumn;
                        this.out.print(WHITESPACE.substring(0, column));
                    }
                    this.out.print(attrString);
                    column += attrString.length();
                    if ((this.compact || !indent_okay) && attrname.equals("pretty") && attrvalue.equalsIgnoreCase("true")) {
                        this.compact = false;
                        indent_okay = true;
                        indent_lvl = 0;
                    }
                    ++i;
                }
                indent_okay = true;
                NodeList children = node.getChildNodes();
                if (children != null) {
                    Node nd;
                    int len = children.getLength();
                    int i2 = 0;
                    i2 = 0;
                    while (i2 < len) {
                        nd = children.item(i2);
                        if (nd != null && nd.getNodeType() != 2) break;
                        ++i2;
                    }
                    if (i2 < len) {
                        print_end = true;
                        this.out.print('>');
                        while (i2 < len) {
                            nd = children.item(i2);
                            if (nd != null) {
                                indent_okay = this.print(nd, indent_lvl + 1, indent_okay);
                            }
                            ++i2;
                        }
                    } else if (this.isHTML) {
                        this.out.print("></");
                        this.out.print(node.getNodeName());
                        this.out.print(">");
                    } else {
                        this.out.print("/>");
                    }
                } else if (this.isHTML) {
                    this.out.print("></");
                    this.out.print(node.getNodeName());
                    this.out.print(">");
                } else {
                    this.out.print("/>");
                }
                ret = true;
                this.compact = compact_orig;
                break;
            }
            case 5: {
                if (this.canonical) {
                    NodeList children = node.getChildNodes();
                    if (children != null) {
                        int len = children.getLength();
                        int i = 0;
                        while (i < len) {
                            this.print(children.item(i));
                            ++i;
                        }
                    }
                } else {
                    this.out.print('&');
                    this.out.print(node.getNodeName());
                    this.out.print(';');
                }
                ret = false;
                break;
            }
            case 4: {
                if (this.canonical) {
                    this.out.print(this.normalize(node.getNodeValue()));
                } else {
                    this.out.print("<![CDATA[");
                    this.out.print(node.getNodeValue());
                    this.out.print("]]>");
                }
                ret = true;
                break;
            }
            case 3: {
                this.out.print(this.normalize(node.getNodeValue()));
                ret = false;
                break;
            }
            case 8: {
                if (!this.compact && indent_okay) {
                    this.out.print("\n");
                    column = 4 * indent_lvl;
                    this.out.print(WHITESPACE.substring(0, column));
                }
                this.out.print("<!--");
                this.out.print(node.getNodeValue());
                this.out.print("-->");
                ret = true;
                break;
            }
            case 7: {
                if (!this.compact && indent_okay) {
                    this.out.print("\n");
                    column = 4 * indent_lvl;
                    this.out.print(WHITESPACE.substring(0, column));
                }
                this.out.print("<?");
                this.out.print(node.getNodeName());
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    this.out.print(' ');
                    this.out.print(data);
                }
                this.out.print("?>");
                ret = true;
                break;
            }
            case 10: {
                DocumentType docType = (DocumentType)node;
                this.out.print("<!DOCTYPE ");
                this.out.print(docType.getName());
                String systemId = docType.getSystemId();
                String publicId = docType.getPublicId();
                if (publicId != null && publicId.length() > 0) {
                    this.out.print(" PUBLIC \"");
                    this.out.print(publicId);
                    this.out.print("\"");
                    if (systemId != null && systemId.length() > 0) {
                        this.out.print(" \"");
                        this.out.print(systemId);
                        this.out.print("\"");
                    }
                } else if (systemId != null && systemId.length() > 0) {
                    this.out.print(" SYSTEM \"");
                    this.out.print(systemId);
                    this.out.print("\"");
                }
                this.out.print(">");
                break;
            }
        }
        if (print_end && type == 1) {
            if (!this.compact && indent_okay) {
                this.out.print("\n");
                column = 4 * indent_lvl;
                this.out.print(WHITESPACE.substring(0, column));
            }
            this.out.print("</");
            this.out.print(node.getNodeName());
            this.out.print('>');
        }
        return ret;
    }

    protected Attr[] sortAttributes(NamedNodeMap attrs) {
        int len = attrs != null ? attrs.getLength() : 0;
        Attr[] array = new Attr[len];
        int i = 0;
        while (i < len) {
            array[i] = (Attr)attrs.item(i);
            ++i;
        }
        Arrays.sort(array, new AttrCompare());
        return array;
    }

    protected String normalize(String s) {
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    break;
                }
                case '>': {
                    str.append("&gt;");
                    break;
                }
                case '&': {
                    str.append("&amp;");
                    break;
                }
                case '\"': {
                    str.append("&quot;");
                    break;
                }
                case '\r': {
                    str.append("&#");
                    str.append(Integer.toString(ch));
                    str.append(';');
                    break;
                }
                case '\n': {
                    if (this.canonical) {
                        str.append("&#");
                        str.append(Integer.toString(ch));
                        str.append(';');
                        break;
                    }
                }
                default: {
                    if (ch > '\u007f' && ch < '\u0100') {
                        str.append("&#");
                        str.append(Integer.toString(ch));
                        str.append(';');
                        break;
                    }
                    str.append(ch);
                }
            }
            ++i;
        }
        return str.toString();
    }

    private static void printUsage() {
        System.err.println("usage: java dom.DOMWriter (options) uri ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -p name  Specify DOM parser wrapper by name.");
        System.err.println("           Default parser: dom.wrappers.DOMParser");
        System.err.println("  -c       Canonical XML output.");
        System.err.println("  -h       This help screen.");
        System.err.println("  -e       Output Java Encoding.");
        System.err.println("           Default encoding: UTF-8");
    }

    private static void printValidJavaEncoding() {
        System.err.println("    ENCODINGS:");
        System.err.print("   ");
        int i = 0;
        while (i < MIME2JAVA_ENCODINGS.length) {
            System.err.print(MIME2JAVA_ENCODINGS[i] + " ");
            if (i % 7 == 0) {
                System.err.println();
                System.err.print("   ");
            }
            ++i;
        }
    }

    static {
        INDENT_PER_LEVEL = 4;
        RIGHT_MARGIN = 78;
        WHITESPACE = WHITESPACE;
        DEFAULT_PARSER_NAME = DEFAULT_PARSER_NAME;
        PRINTWRITER_ENCODING = "UTF8";
        MIME2JAVA_ENCODINGS = new String[]{"Default", "UTF-8", "US-ASCII", "ISO-8859-1", "ISO-8859-2", "ISO-8859-3", "ISO-8859-4", "ISO-8859-5", "ISO-8859-6", "ISO-8859-7", "ISO-8859-8", "ISO-8859-9", "ISO-2022-JP", "SHIFT_JIS", "EUC-JP", "GB2312", "BIG5", "EUC-KR", "ISO-2022-KR", "KOI8-R", "EBCDIC-CP-US", "EBCDIC-CP-CA", "EBCDIC-CP-NL", "EBCDIC-CP-DK", "EBCDIC-CP-NO", "EBCDIC-CP-FI", "EBCDIC-CP-SE", "EBCDIC-CP-IT", "EBCDIC-CP-ES", "EBCDIC-CP-GB", "EBCDIC-CP-FR", "EBCDIC-CP-AR1", "EBCDIC-CP-HE", "EBCDIC-CP-CH", "EBCDIC-CP-ROECE", "EBCDIC-CP-YU", "EBCDIC-CP-IS", "EBCDIC-CP-AR2", "UTF-16"};
    }

    class AttrCompare
    implements Comparator {
        AttrCompare() {
        }

        public int compare(Object obj1, Object obj2) {
            return ((Attr)obj1).getNodeName().compareTo(((Attr)obj2).getNodeName());
        }

        public boolean equals(Object obj1, Object obj2) {
            return ((Attr)obj1).getNodeName().equals(((Attr)obj2).getNodeName());
        }
    }
}

